/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RefCountMessageListener;

public abstract class RefCountMessage
implements Message {
    private final AtomicInteger durableRefCount = new AtomicInteger();
    private final AtomicInteger refCount = new AtomicInteger();
    private RefCountMessageListener context;

    @Override
    public Message setContext(RefCountMessageListener context) {
        this.context = context;
        return this;
    }

    @Override
    public RefCountMessageListener getContext() {
        return this.context;
    }

    @Override
    public int getRefCount() {
        return this.refCount.get();
    }

    @Override
    public int incrementRefCount() throws Exception {
        int count = this.refCount.incrementAndGet();
        if (this.context != null) {
            this.context.nonDurableUp(this, count);
        }
        return count;
    }

    @Override
    public int incrementDurableRefCount() {
        int count = this.durableRefCount.incrementAndGet();
        if (this.context != null) {
            this.context.durableUp(this, count);
        }
        return count;
    }

    @Override
    public int decrementDurableRefCount() {
        int count = this.durableRefCount.decrementAndGet();
        if (this.context != null) {
            this.context.durableDown(this, count);
        }
        return count;
    }

    @Override
    public int decrementRefCount() throws Exception {
        int count = this.refCount.decrementAndGet();
        if (this.context != null) {
            this.context.nonDurableDown(this, count);
        }
        return count;
    }
}

