/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.buffers.impl.ChannelBufferWrapper;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.core.security.ActiveMQPrincipal;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.BaseConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;
import org.apache.activemq.artemis.utils.Env;
import org.apache.activemq.artemis.utils.IPV6Util;
import org.jboss.logging.Logger;

public class NettyConnection
implements Connection {
    private static final Logger logger = Logger.getLogger(NettyConnection.class);
    private static final int DEFAULT_BATCH_BYTES = Integer.getInteger("io.netty.batch.bytes", 8192);
    private static final int DEFAULT_WAIT_MILLIS = 10000;
    protected final Channel channel;
    private final BaseConnectionLifeCycleListener<?> listener;
    private final boolean directDeliver;
    private final Map<String, Object> configuration;
    private final List<ReadyListener> readyListeners = new ArrayList<ReadyListener>();
    private final ThreadLocal<ArrayList<ReadyListener>> localListenersPool = ThreadLocal.withInitial(ArrayList::new);
    private final boolean batchingEnabled;
    private final int writeBufferHighWaterMark;
    private final int batchLimit;
    private final AtomicLong pendingWritesOnEventLoopView = new AtomicLong();
    private long pendingWritesOnEventLoop = 0L;
    private boolean closed;
    private RemotingConnection protocolConnection;
    private boolean ready = true;

    public NettyConnection(Map<String, Object> configuration, Channel channel, BaseConnectionLifeCycleListener<?> listener, boolean batchingEnabled, boolean directDeliver) {
        this.configuration = configuration;
        this.channel = channel;
        this.listener = listener;
        this.directDeliver = directDeliver;
        this.batchingEnabled = batchingEnabled;
        this.writeBufferHighWaterMark = this.channel.config().getWriteBufferHighWaterMark();
        this.batchLimit = batchingEnabled ? Math.min(this.writeBufferHighWaterMark, DEFAULT_BATCH_BYTES) : 0;
    }

    private static void waitFor(ChannelPromise promise, long millis) {
        try {
            boolean completed = promise.await(millis);
            if (!completed) {
                ActiveMQClientLogger.LOGGER.timeoutFlushingPacket();
            }
        }
        catch (InterruptedException e) {
            throw new ActiveMQInterruptedException((Throwable)e);
        }
    }

    private static int batchBufferSize(Channel channel, int writeBufferHighWaterMark) {
        int bytesBeforeUnwritable = (int)channel.bytesBeforeUnwritable();
        assert (bytesBeforeUnwritable >= 0);
        int writtenBytes = writeBufferHighWaterMark - bytesBeforeUnwritable;
        assert (writtenBytes >= 0);
        return writtenBytes;
    }

    public final int pendingWritesOnChannel() {
        return NettyConnection.batchBufferSize(this.channel, this.writeBufferHighWaterMark);
    }

    public final long pendingWritesOnEventLoop() {
        EventLoop eventLoop = this.channel.eventLoop();
        boolean inEventLoop = eventLoop.inEventLoop();
        long pendingWritesOnEventLoop = inEventLoop ? this.pendingWritesOnEventLoop : this.pendingWritesOnEventLoopView.get();
        return pendingWritesOnEventLoop;
    }

    public final Channel getNettyChannel() {
        return this.channel;
    }

    @Override
    public final void setAutoRead(boolean autoRead) {
        this.channel.config().setAutoRead(autoRead);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isWritable(ReadyListener callback) {
        List<ReadyListener> list = this.readyListeners;
        synchronized (list) {
            if (!this.ready) {
                this.readyListeners.add(callback);
            }
            return this.ready;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void fireReady(boolean ready) {
        ArrayList<ReadyListener> readyToCall = this.localListenersPool.get();
        List<ReadyListener> list = this.readyListeners;
        synchronized (list) {
            this.ready = ready;
            if (ready) {
                int size = this.readyListeners.size();
                readyToCall.ensureCapacity(size);
                try {
                    for (int i = 0; i < size; ++i) {
                        ReadyListener readyListener = this.readyListeners.get(i);
                        if (readyListener == null) {
                            break;
                        }
                        readyToCall.add(readyListener);
                    }
                }
                finally {
                    this.readyListeners.clear();
                }
            }
        }
        try {
            int size = readyToCall.size();
            for (int i = 0; i < size; ++i) {
                try {
                    ReadyListener readyListener = readyToCall.get(i);
                    readyListener.readyForWriting();
                    continue;
                }
                catch (Throwable logOnly) {
                    ActiveMQClientLogger.LOGGER.failedToSetChannelReadyForWriting(logOnly);
                }
            }
        }
        finally {
            readyToCall.clear();
        }
    }

    @Override
    public final void forceClose() {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (Throwable e) {
                ActiveMQClientLogger.LOGGER.failedForceClose(e);
            }
        }
    }

    public final Channel getChannel() {
        return this.channel;
    }

    @Override
    public final RemotingConnection getProtocolConnection() {
        return this.protocolConnection;
    }

    @Override
    public final void setProtocolConnection(RemotingConnection protocolConnection) {
        this.protocolConnection = protocolConnection;
    }

    @Override
    public final void close() {
        if (this.closed) {
            return;
        }
        EventLoop eventLoop = this.channel.eventLoop();
        boolean inEventLoop = eventLoop.inEventLoop();
        if (!inEventLoop) {
            SslHandler sslHandler = (SslHandler)this.channel.pipeline().get("ssl");
            this.closeSSLAndChannel(sslHandler, this.channel, false);
        } else {
            eventLoop.execute(() -> {
                SslHandler sslHandler = (SslHandler)this.channel.pipeline().get("ssl");
                this.closeSSLAndChannel(sslHandler, this.channel, true);
            });
        }
        this.closed = true;
        this.listener.connectionDestroyed(this.getID());
    }

    @Override
    public ActiveMQBuffer createTransportBuffer(int size) {
        try {
            return new ChannelBufferWrapper(this.channel.alloc().directBuffer(size), true);
        }
        catch (OutOfMemoryError oom) {
            long totalPendingWriteBytes = NettyConnection.batchBufferSize(this.channel, this.writeBufferHighWaterMark);
            logger.warn((Object)("Trying to allocate " + size + " bytes, System is throwing OutOfMemoryError on NettyConnection " + this + ", there are currently " + "pendingWrites: [NETTY] -> " + totalPendingWriteBytes + "[EVENT LOOP] -> " + this.pendingWritesOnEventLoopView.get() + " causes: " + oom.getMessage()), (Throwable)oom);
            throw oom;
        }
    }

    @Override
    public final Object getID() {
        return this.channel.id();
    }

    @Override
    public final void checkFlushBatchBuffer() {
        int batchBufferSize;
        if (this.batchingEnabled && (batchBufferSize = NettyConnection.batchBufferSize(this.channel, this.writeBufferHighWaterMark)) > 0) {
            this.channel.flush();
        }
    }

    @Override
    public final void write(ActiveMQBuffer buffer) {
        this.write(buffer, false, false);
    }

    @Override
    public final void write(ActiveMQBuffer buffer, boolean flush, boolean batched) {
        this.write(buffer, flush, batched, null);
    }

    private void checkConnectionState() {
        if (this.closed || !this.channel.isActive()) {
            throw new IllegalStateException("Connection " + this.getID() + " closed or disconnected");
        }
    }

    @Override
    public final boolean blockUntilWritable(int requiredCapacity, long timeout, TimeUnit timeUnit) {
        boolean canWrite;
        this.checkConnectionState();
        boolean isAllowedToBlock = this.isAllowedToBlock();
        if (!isAllowedToBlock) {
            if (Env.isTestEnv()) {
                logger.warn((Object)"FAILURE! The code is using blockUntilWritable inside a Netty worker, which would block. The code will probably need fixing!", (Throwable)new Exception("trace"));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Calling blockUntilWritable using a thread where it's not allowed");
            }
            return this.canWrite(requiredCapacity);
        }
        long timeoutNanos = timeUnit.toNanos(timeout);
        long deadline = System.nanoTime() + timeoutNanos;
        long parkNanos = timeoutNanos >= 1000000L ? 100000L : 1000L;
        while (!(canWrite = this.canWrite(requiredCapacity)) && System.nanoTime() - deadline < 0L) {
            this.checkConnectionState();
            LockSupport.parkNanos(parkNanos);
        }
        return canWrite;
    }

    private boolean isAllowedToBlock() {
        EventLoop eventLoop = this.channel.eventLoop();
        boolean inEventLoop = eventLoop.inEventLoop();
        return !inEventLoop;
    }

    private boolean canWrite(int requiredCapacity) {
        long pendingWritesOnEventLoop = this.pendingWritesOnEventLoop();
        long totalPendingWrites = pendingWritesOnEventLoop + (long)this.pendingWritesOnChannel();
        boolean canWrite = requiredCapacity > this.writeBufferHighWaterMark ? totalPendingWrites == 0L : totalPendingWrites + (long)requiredCapacity <= (long)this.writeBufferHighWaterMark;
        return canWrite;
    }

    @Override
    public final void write(ActiveMQBuffer buffer, boolean flush, boolean batched, ChannelFutureListener futureListener) {
        EventLoop eventLoop;
        boolean inEventLoop;
        int remainingBytes;
        int readableBytes = buffer.readableBytes();
        if (logger.isDebugEnabled() && (remainingBytes = this.writeBufferHighWaterMark - readableBytes) < 0) {
            logger.debug((Object)("a write request is exceeding by " + -remainingBytes + " bytes the writeBufferHighWaterMark size [ " + this.writeBufferHighWaterMark + " ] : consider to set it at least of " + readableBytes + " bytes"));
        }
        if (!(inEventLoop = (eventLoop = this.channel.eventLoop()).inEventLoop())) {
            this.writeNotInEventLoop(buffer, flush, batched, futureListener);
        } else {
            this.pendingWritesOnEventLoop += (long)readableBytes;
            this.pendingWritesOnEventLoopView.lazySet(this.pendingWritesOnEventLoop);
            eventLoop.execute(() -> {
                this.pendingWritesOnEventLoop -= (long)readableBytes;
                this.pendingWritesOnEventLoopView.lazySet(this.pendingWritesOnEventLoop);
                this.writeInEventLoop(buffer, flush, batched, futureListener);
            });
        }
    }

    private void writeNotInEventLoop(ActiveMQBuffer buffer, boolean flush, boolean batched, ChannelFutureListener futureListener) {
        Channel channel = this.channel;
        ChannelPromise promise = flush || futureListener != null ? channel.newPromise() : channel.voidPromise();
        ByteBuf bytes = buffer.byteBuf();
        int readableBytes = bytes.readableBytes();
        assert (readableBytes >= 0);
        int writeBatchSize = this.batchLimit;
        boolean batchingEnabled = this.batchingEnabled;
        ChannelFuture future = batchingEnabled && batched && !flush && readableBytes < writeBatchSize ? this.writeBatch(bytes, readableBytes, promise) : channel.writeAndFlush((Object)bytes, promise);
        if (futureListener != null) {
            future.addListener((GenericFutureListener)futureListener);
        }
        if (flush) {
            NettyConnection.waitFor(promise, 10000L);
        }
    }

    private void writeInEventLoop(ActiveMQBuffer buffer, boolean flush, boolean batched, ChannelFutureListener futureListener) {
        ChannelPromise promise = futureListener != null ? this.channel.newPromise() : this.channel.voidPromise();
        ByteBuf bytes = buffer.byteBuf();
        int readableBytes = bytes.readableBytes();
        int writeBatchSize = this.batchLimit;
        ChannelFuture future = this.batchingEnabled && batched && !flush && readableBytes < writeBatchSize ? this.writeBatch(bytes, readableBytes, promise) : this.channel.writeAndFlush((Object)bytes, promise);
        if (futureListener != null) {
            future.addListener((GenericFutureListener)futureListener);
        }
    }

    private ChannelFuture writeBatch(ByteBuf bytes, int readableBytes, ChannelPromise promise) {
        int batchBufferSize = NettyConnection.batchBufferSize(this.channel, this.writeBufferHighWaterMark);
        int nextBatchSize = batchBufferSize + readableBytes;
        if (nextBatchSize > this.batchLimit) {
            this.channel.flush();
            return this.channel.write((Object)bytes, promise);
        }
        if (nextBatchSize == this.batchLimit) {
            return this.channel.writeAndFlush((Object)bytes, promise);
        }
        return this.channel.write((Object)bytes, promise);
    }

    @Override
    public final String getRemoteAddress() {
        SocketAddress address = this.channel.remoteAddress();
        if (address == null) {
            return null;
        }
        return address.toString();
    }

    @Override
    public final String getLocalAddress() {
        SocketAddress address = this.channel.localAddress();
        if (address == null) {
            return null;
        }
        return "tcp://" + IPV6Util.encloseHost((String)address.toString());
    }

    public final boolean isDirectDeliver() {
        return this.directDeliver;
    }

    @Override
    public final ActiveMQPrincipal getDefaultActiveMQPrincipal() {
        return null;
    }

    @Override
    public final TransportConfiguration getConnectorConfig() {
        if (this.configuration != null) {
            return new TransportConfiguration(NettyConnectorFactory.class.getName(), this.configuration);
        }
        return null;
    }

    @Override
    public final boolean isUsingProtocolHandling() {
        return true;
    }

    public final String toString() {
        return super.toString() + "[ID=" + this.getID() + ", local= " + this.channel.localAddress() + ", remote=" + this.channel.remoteAddress() + "]";
    }

    private void closeSSLAndChannel(SslHandler sslHandler, Channel channel, boolean inEventLoop) {
        block6: {
            this.checkFlushBatchBuffer();
            if (sslHandler != null) {
                try {
                    ChannelFuture sslCloseFuture = sslHandler.close();
                    sslCloseFuture.addListener(future -> channel.close());
                    if (!inEventLoop && !sslCloseFuture.awaitUninterruptibly(10000L)) {
                        ActiveMQClientLogger.LOGGER.timeoutClosingSSL();
                    }
                    break block6;
                }
                catch (Throwable t) {
                    if (ActiveMQClientLogger.LOGGER.isTraceEnabled()) {
                        ActiveMQClientLogger.LOGGER.trace(t.getMessage(), t);
                    }
                    break block6;
                }
            }
            ChannelFuture closeFuture = channel.close();
            if (!inEventLoop && !closeFuture.awaitUninterruptibly(10000L)) {
                ActiveMQClientLogger.LOGGER.timeoutClosingNettyChannel();
            }
        }
    }
}

