/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.osgi.service.notifier;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.pentaho.di.osgi.OSGIPluginTracker;
import org.pentaho.di.osgi.OSGIPluginTrackerException;
import org.pentaho.di.osgi.service.lifecycle.LifecycleEvent;
import org.pentaho.di.osgi.service.lifecycle.OSGIServiceLifecycleListener;
import org.pentaho.di.osgi.service.notifier.DelayedServiceNotifierListener;
import org.pentaho.osgi.api.BeanFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedServiceNotifier
implements Runnable {
    private final Map<Class, List<OSGIServiceLifecycleListener>> listeners;
    private final ScheduledExecutorService scheduler;
    private final OSGIPluginTracker osgiPluginTracker;
    private final Class<?> classToTrack;
    private final LifecycleEvent eventType;
    private final Object serviceObject;
    private final DelayedServiceNotifierListener delayedServiceNotifierListener;
    private Logger logger = LoggerFactory.getLogger(DelayedServiceNotifier.class);

    public DelayedServiceNotifier(OSGIPluginTracker osgiPluginTracker, Class<?> classToTrack, LifecycleEvent eventType, Object serviceObject, Map<Class, List<OSGIServiceLifecycleListener>> listeners, ScheduledExecutorService scheduler, DelayedServiceNotifierListener delayedServiceNotifierListener) {
        this.osgiPluginTracker = osgiPluginTracker;
        this.classToTrack = classToTrack;
        this.eventType = eventType;
        this.serviceObject = serviceObject;
        this.listeners = listeners;
        this.scheduler = scheduler;
        this.delayedServiceNotifierListener = delayedServiceNotifierListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BeanFactory factory = null;
        try {
            factory = this.osgiPluginTracker.findOrCreateBeanFactoryFor(this.serviceObject);
        }
        catch (OSGIPluginTrackerException e) {
            this.logger.debug("Error in the plugin tracker. We cannot proceed.", (Throwable)e);
            this.notifyListener();
            return;
        }
        catch (Exception e) {
            this.logger.debug("Error trying to notify on service registration", (Throwable)e);
            this.notifyListener();
            return;
        }
        if ((factory == null || this.osgiPluginTracker.getProxyUnwrapper() == null) && this.eventType != LifecycleEvent.STOP) {
            ScheduledFuture<?> e = this.scheduler.schedule(this, 100L, TimeUnit.MILLISECONDS);
        } else {
            try {
                List<OSGIServiceLifecycleListener> listenerList = this.listeners.get(this.classToTrack);
                if (listenerList != null) {
                    block11: for (OSGIServiceLifecycleListener listener : listenerList) {
                        switch (this.eventType) {
                            case START: {
                                listener.pluginAdded(this.serviceObject);
                                continue block11;
                            }
                            case STOP: {
                                listener.pluginRemoved(this.serviceObject);
                                continue block11;
                            }
                            case MODIFY: {
                                listener.pluginChanged(this.serviceObject);
                                continue block11;
                            }
                        }
                        throw new IllegalStateException("Unhandled enum value: " + (Object)((Object)this.eventType));
                    }
                }
            }
            finally {
                this.notifyListener();
            }
        }
    }

    public void notifyListener() {
        if (this.delayedServiceNotifierListener != null) {
            this.delayedServiceNotifierListener.onRun(this.eventType, this.serviceObject);
        }
    }
}

