/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.kettle;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.AbstractDataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryRegistry;
import org.pentaho.reporting.engine.classic.core.metadata.MetaDataLookupException;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.EmbeddedKettleTransformationProducer;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleTransformationProducer;

public class KettleDataFactory
extends AbstractDataFactory {
    private static final long serialVersionUID = 3378733681824193349L;
    private static final Log logger = LogFactory.getLog(KettleDataFactory.class);
    private LinkedHashMap<String, KettleTransformationProducer> queries = new LinkedHashMap();
    private transient KettleTransformationProducer currentlyRunningQuery;
    private DataFactoryMetaData metadata;

    public void setMetadata(DataFactoryMetaData metadata) {
        this.metadata = metadata;
    }

    public void setQuery(String name, KettleTransformationProducer value) {
        if (value == null) {
            this.queries.remove(name);
        } else {
            this.queries.put(name, value);
        }
    }

    public KettleTransformationProducer getQuery(String name) {
        return this.queries.get(name);
    }

    public String[] getQueryNames() {
        return this.queries.keySet().toArray(new String[this.queries.size()]);
    }

    public TableModel queryData(String query, DataRow parameters) throws ReportDataFactoryException {
        int queryLimit = this.calculateQueryLimit(parameters);
        KettleTransformationProducer producer = this.queries.get(query);
        if (producer == null) {
            throw new ReportDataFactoryException("There is no such query defined: " + query);
        }
        try {
            this.currentlyRunningQuery = producer;
            TableModel tableModel = producer.performQuery(parameters, queryLimit, this.getDataFactoryContext());
            return tableModel;
        }
        catch (ReportDataFactoryException rdfe) {
            throw rdfe;
        }
        catch (Throwable e) {
            throw new ReportDataFactoryException("Caught Kettle Exception: Check your configuration", e);
        }
        finally {
            this.currentlyRunningQuery = null;
        }
    }

    public KettleDataFactory clone() {
        KettleDataFactory df = (KettleDataFactory)super.clone();
        df.queries = (LinkedHashMap)this.queries.clone();
        df.currentlyRunningQuery = null;
        for (Map.Entry<String, KettleTransformationProducer> entry : df.queries.entrySet()) {
            KettleTransformationProducer value = entry.getValue();
            entry.setValue((KettleTransformationProducer)value.clone());
        }
        return df;
    }

    public TableModel queryDesignTimeStructure(String query, DataRow parameter) throws ReportDataFactoryException {
        KettleTransformationProducer producer = this.queries.get(query);
        if (producer == null) {
            throw new ReportDataFactoryException("There is no such query defined: " + query);
        }
        try {
            this.currentlyRunningQuery = producer;
            TableModel tableModel = producer.queryDesignTimeStructure(parameter, this.getDataFactoryContext());
            return tableModel;
        }
        catch (ReportDataFactoryException rdfe) {
            throw rdfe;
        }
        catch (Throwable e) {
            throw new ReportDataFactoryException("Caught Kettle Exception: Check your configuration", e);
        }
        finally {
            this.currentlyRunningQuery = null;
        }
    }

    public void close() {
    }

    public boolean isQueryExecutable(String query, DataRow parameters) {
        return this.queries.containsKey(query);
    }

    public void cancelRunningQuery() {
        KettleTransformationProducer producer = this.currentlyRunningQuery;
        if (producer != null) {
            producer.cancelQuery();
            this.currentlyRunningQuery = null;
        }
    }

    public Object getQueryHash(String queryName) {
        KettleTransformationProducer transformationProducer = this.getQuery(queryName);
        if (transformationProducer == null) {
            return null;
        }
        return transformationProducer.getQueryHash(this.getResourceManager(), this.getContextKey());
    }

    public boolean queriesAreHomogeneous() {
        if (this.queries == null || this.queries.isEmpty()) {
            return true;
        }
        KettleTransformationProducer key = null;
        for (KettleTransformationProducer producer : this.queries.values()) {
            if (key == null) {
                key = producer;
                if (key instanceof EmbeddedKettleTransformationProducer) continue;
                return false;
            }
            if (key.getClass() != producer.getClass()) {
                return false;
            }
            if (key instanceof EmbeddedKettleTransformationProducer && producer instanceof EmbeddedKettleTransformationProducer) {
                EmbeddedKettleTransformationProducer k = (EmbeddedKettleTransformationProducer)key;
                EmbeddedKettleTransformationProducer p = (EmbeddedKettleTransformationProducer)producer;
                if (!k.getPluginId().equals(p.getPluginId())) {
                    return false;
                }
            }
            key = producer;
        }
        return true;
    }

    public DataFactoryMetaData getMetaData() {
        block4: {
            KettleTransformationProducer defaultProducer;
            if (this.metadata != null) {
                return this.metadata;
            }
            if (!this.queries.isEmpty() && (defaultProducer = this.queries.values().iterator().next()) instanceof EmbeddedKettleTransformationProducer) {
                EmbeddedKettleTransformationProducer producer = (EmbeddedKettleTransformationProducer)defaultProducer;
                String pluginId = producer.getPluginId();
                try {
                    this.metadata = DataFactoryRegistry.getInstance().getMetaData(pluginId);
                    return this.metadata;
                }
                catch (MetaDataLookupException e) {
                    if (!logger.isTraceEnabled()) break block4;
                    logger.trace((Object)("Failed to lookup metadata for plugin-id " + pluginId), (Throwable)e);
                }
            }
        }
        return DataFactoryRegistry.getInstance().getMetaData(((Object)((Object)this)).getClass().getName());
    }
}

