/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import netscape.ldap.LDAPBind;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPRebind;

public class LDAPSearchConstraints
extends LDAPConstraints
implements Cloneable {
    private int deref;
    private int maxRes;
    private int batch;
    private int serverTimeLimit;
    private int m_maxBacklog = 100;

    public LDAPSearchConstraints() {
        this.deref = 0;
        this.maxRes = 1000;
        this.batch = 1;
        this.serverTimeLimit = 0;
    }

    public LDAPSearchConstraints(int n, int n2, int n3, int n4, boolean bl, int n5, LDAPBind lDAPBind, int n6) {
        super(n, bl, lDAPBind, n6);
        this.serverTimeLimit = n2;
        this.deref = n3;
        this.maxRes = n4;
        this.batch = n5;
    }

    public LDAPSearchConstraints(int n, int n2, int n3, int n4, boolean bl, int n5, LDAPRebind lDAPRebind, int n6) {
        super(n, bl, lDAPRebind, n6);
        this.serverTimeLimit = n2;
        this.deref = n3;
        this.maxRes = n4;
        this.batch = n5;
    }

    public LDAPSearchConstraints(int n, int n2, int n3, boolean bl, int n4, LDAPRebind lDAPRebind, int n5) {
        super(n, bl, lDAPRebind, n5);
        this.deref = n2;
        this.maxRes = n3;
        this.batch = n4;
    }

    public Object clone() {
        LDAPControl[] lDAPControlArray;
        LDAPSearchConstraints lDAPSearchConstraints = new LDAPSearchConstraints();
        lDAPSearchConstraints.serverTimeLimit = this.serverTimeLimit;
        lDAPSearchConstraints.deref = this.deref;
        lDAPSearchConstraints.maxRes = this.maxRes;
        lDAPSearchConstraints.batch = this.batch;
        lDAPSearchConstraints.setHopLimit(this.getHopLimit());
        lDAPSearchConstraints.setReferrals(this.getReferrals());
        lDAPSearchConstraints.setTimeLimit(this.getTimeLimit());
        if (this.getBindProc() != null) {
            lDAPSearchConstraints.setBindProc(this.getBindProc());
        } else {
            lDAPSearchConstraints.setRebindProc(this.getRebindProc());
        }
        LDAPControl[] lDAPControlArray2 = this.getClientControls();
        if (lDAPControlArray2 != null && lDAPControlArray2.length > 0) {
            LDAPControl[] lDAPControlArray3 = new LDAPControl[lDAPControlArray2.length];
            int n = 0;
            while (n < lDAPControlArray2.length) {
                lDAPControlArray3[n] = (LDAPControl)lDAPControlArray2[n].clone();
                ++n;
            }
            lDAPSearchConstraints.setClientControls(lDAPControlArray3);
        }
        if ((lDAPControlArray = this.getServerControls()) != null && lDAPControlArray.length > 0) {
            LDAPControl[] lDAPControlArray4 = new LDAPControl[lDAPControlArray.length];
            int n = 0;
            while (n < lDAPControlArray.length) {
                lDAPControlArray4[n] = (LDAPControl)lDAPControlArray[n].clone();
                ++n;
            }
            lDAPSearchConstraints.setServerControls(lDAPControlArray4);
        }
        return lDAPSearchConstraints;
    }

    public int getBatchSize() {
        return this.batch;
    }

    public int getDereference() {
        return this.deref;
    }

    public int getMaxBacklog() {
        return this.m_maxBacklog;
    }

    public int getMaxResults() {
        return this.maxRes;
    }

    public int getServerTimeLimit() {
        return this.serverTimeLimit;
    }

    public void setBatchSize(int n) {
        this.batch = n;
    }

    public void setDereference(int n) {
        this.deref = n;
    }

    public void setMaxBacklog(int n) {
        this.m_maxBacklog = n;
    }

    public void setMaxResults(int n) {
        this.maxRes = n;
    }

    public void setServerTimeLimit(int n) {
        this.serverTimeLimit = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("LDAPSearchConstraints {");
        stringBuffer.append(String.valueOf(super.toString()) + ' ');
        stringBuffer.append("size limit " + this.maxRes + ", ");
        stringBuffer.append("server time limit " + this.serverTimeLimit + ", ");
        stringBuffer.append("aliases " + this.deref + ", ");
        stringBuffer.append("batch size " + this.batch);
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

