/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swing.tags;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulDomException;
import org.pentaho.ui.xul.containers.XulVbox;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swing.AbstractSwingContainer;
import org.pentaho.ui.xul.swing.ScrollablePanel;
import org.pentaho.ui.xul.swing.tags.SwingImage;
import org.pentaho.ui.xul.util.Orient;

public class SwingVbox
extends AbstractSwingContainer
implements XulVbox {
    private String background;
    private Image backgroundImage;
    private static final Log logger = LogFactory.getLog(SwingVbox.class);
    private XulDomContainer domContainer;

    public SwingVbox(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super("Vbox");
        this.domContainer = domContainer;
        this.orientation = Orient.VERTICAL;
        this.container = new ScrollablePanel(new GridBagLayout()){

            @Override
            public void paintComponent(Graphics g) {
                if (SwingVbox.this.backgroundImage != null) {
                    g.drawImage(SwingVbox.this.backgroundImage, 0, 0, SwingVbox.this.container);
                }
            }
        };
        this.container.setOpaque(false);
        this.setManagedObject(this.container);
        this.setPadding(2);
    }

    @Override
    public void resetContainer() {
        this.container.removeAll();
        this.gc = new GridBagConstraints();
        this.gc.gridy = -1;
        this.gc.gridx = 0;
        this.gc.gridheight = 1;
        this.gc.gridwidth = 0;
        int pad = this.getPadding();
        this.gc.insets = new Insets(pad, pad, pad, pad);
        this.gc.fill = 2;
        this.gc.anchor = 18;
        this.gc.weightx = 1.0;
    }

    @Override
    public void replaceChild(XulComponent oldElement, XulComponent newElement) throws XulDomException {
        this.resetContainer();
        super.replaceChild(oldElement, newElement);
    }

    @Override
    public void layout() {
        this.resetContainer();
        if (this.getBgcolor() != null) {
            this.container.setOpaque(true);
            this.container.setBackground(Color.decode(this.getBgcolor()));
        }
        super.layout();
    }

    public String getBackground() {
        return this.background;
    }

    public void setBackground(String src) {
        this.background = src;
        URL url = SwingImage.class.getClassLoader().getResource(this.domContainer.getXulLoader().getRootDir() + src);
        if (url == null) {
            try {
                url = new File(src).toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (url == null) {
            logger.error((Object)("Could not find resource: " + src));
            return;
        }
        ImageIcon ico = new ImageIcon(url);
        this.backgroundImage = ico.getImage();
    }
}

