/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.big.data.bundles.impl.shim.hbase.table;

import com.pentaho.big.data.bundles.impl.shim.hbase.connectionPool.HBaseConnectionHandle;
import com.pentaho.big.data.bundles.impl.shim.hbase.connectionPool.HBaseConnectionPool;
import com.pentaho.big.data.bundles.impl.shim.hbase.meta.HBaseValueMetaInterfaceFactoryImpl;
import com.pentaho.big.data.bundles.impl.shim.hbase.table.HBaseTableWriteOperationManagerImpl;
import com.pentaho.big.data.bundles.impl.shim.hbase.table.ResultScannerBuilderImpl;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.pentaho.bigdata.api.hbase.mapping.Mapping;
import org.pentaho.bigdata.api.hbase.table.HBaseTable;
import org.pentaho.bigdata.api.hbase.table.HBaseTableWriteOperationManager;
import org.pentaho.bigdata.api.hbase.table.ResultScannerBuilder;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.hbase.shim.api.HBaseValueMeta;
import org.pentaho.hbase.shim.api.Mapping;
import org.pentaho.hbase.shim.spi.HBaseBytesUtilShim;

public class HBaseTableImpl
implements HBaseTable {
    private static final Class<?> PKG = HBaseTableImpl.class;
    private final HBaseConnectionPool hBaseConnectionPool;
    private final HBaseValueMetaInterfaceFactoryImpl hBaseValueMetaInterfaceFactory;
    private final HBaseBytesUtilShim hBaseBytesUtilShim;
    private final String name;

    public HBaseTableImpl(HBaseConnectionPool hBaseConnectionPool, HBaseValueMetaInterfaceFactoryImpl hBaseValueMetaInterfaceFactory, HBaseBytesUtilShim hBaseBytesUtilShim, String name) {
        this.hBaseConnectionPool = hBaseConnectionPool;
        this.hBaseValueMetaInterfaceFactory = hBaseValueMetaInterfaceFactory;
        this.hBaseBytesUtilShim = hBaseBytesUtilShim;
        this.name = name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exists() throws IOException {
        try (HBaseConnectionHandle hBaseConnectionHandle = this.hBaseConnectionPool.getConnectionHandle();){
            boolean bl = hBaseConnectionHandle.getConnection().tableExists(this.name);
            return bl;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean disabled() throws IOException {
        try (HBaseConnectionHandle hBaseConnectionHandle = this.hBaseConnectionPool.getConnectionHandle();){
            boolean bl = hBaseConnectionHandle.getConnection().isTableDisabled(this.name);
            return bl;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean available() throws IOException {
        try (HBaseConnectionHandle hBaseConnectionHandle = this.hBaseConnectionPool.getConnectionHandle();){
            boolean bl = hBaseConnectionHandle.getConnection().isTableAvailable(this.name);
            return bl;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void disable() throws IOException {
        try (HBaseConnectionHandle hBaseConnectionHandle = this.hBaseConnectionPool.getConnectionHandle();){
            hBaseConnectionHandle.getConnection().disableTable(this.name);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void enable() throws IOException {
        try (HBaseConnectionHandle hBaseConnectionHandle = this.hBaseConnectionPool.getConnectionHandle();){
            hBaseConnectionHandle.getConnection().enableTable(this.name);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void delete() throws IOException {
        try (HBaseConnectionHandle hBaseConnectionHandle = this.hBaseConnectionPool.getConnectionHandle();){
            hBaseConnectionHandle.getConnection().deleteTable(this.name);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void create(List<String> colFamilyNames, Properties creationProps) throws IOException {
        try (HBaseConnectionHandle hBaseConnectionHandle = this.hBaseConnectionPool.getConnectionHandle();){
            hBaseConnectionHandle.getConnection().createTable(this.name, colFamilyNames, creationProps);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public ResultScannerBuilder createScannerBuilder(byte[] keyLowerBound, byte[] keyUpperBound) {
        return new ResultScannerBuilderImpl(this.hBaseConnectionPool, this.hBaseValueMetaInterfaceFactory, this.hBaseBytesUtilShim, this.name, 0, keyLowerBound, keyUpperBound);
    }

    public ResultScannerBuilder createScannerBuilder(Mapping tableMapping, String dateOrNumberConversionMaskForKey, String keyStartS, String keyStopS, String scannerCacheSize, LogChannelInterface log, VariableSpace vars) throws KettleException {
        byte[] keyLowerBound = null;
        byte[] keyUpperBound = null;
        Mapping.KeyType keyType = Mapping.KeyType.valueOf((String)tableMapping.getKeyType().name());
        if (!Const.isEmpty((String)keyStartS)) {
            Number num;
            DecimalFormat df;
            Date d;
            SimpleDateFormat sdf;
            String[] parts;
            keyStartS = vars.environmentSubstitute(keyStartS);
            String convM = dateOrNumberConversionMaskForKey;
            if (tableMapping.getKeyType() == Mapping.KeyType.BINARY) {
                keyLowerBound = HBaseValueMeta.encodeKeyValue((String)keyStartS, (Mapping.KeyType)keyType, (HBaseBytesUtilShim)this.hBaseBytesUtilShim);
            } else if (tableMapping.getKeyType() != Mapping.KeyType.STRING) {
                parts = keyStartS.split("@");
                if (parts.length == 2) {
                    keyStartS = parts[0];
                    convM = parts[1];
                }
                if (!Const.isEmpty((String)convM) && convM.length() > 0) {
                    if (tableMapping.getKeyType() == Mapping.KeyType.DATE || tableMapping.getKeyType() == Mapping.KeyType.UNSIGNED_DATE) {
                        sdf = new SimpleDateFormat();
                        sdf.applyPattern(convM);
                        try {
                            d = sdf.parse(keyStartS);
                            keyLowerBound = HBaseValueMeta.encodeKeyValue((Object)d, (Mapping.KeyType)keyType, (HBaseBytesUtilShim)this.hBaseBytesUtilShim);
                        }
                        catch (ParseException e) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseInput.Error.UnableToParseLowerBoundKeyValue", (String[])new String[]{keyStartS}), (Throwable)e);
                        }
                    } else {
                        df = new DecimalFormat();
                        df.applyPattern(convM);
                        num = null;
                        try {
                            num = df.parse(keyStartS);
                            keyLowerBound = HBaseValueMeta.encodeKeyValue((Object)num, (Mapping.KeyType)keyType, (HBaseBytesUtilShim)this.hBaseBytesUtilShim);
                        }
                        catch (ParseException e) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseInput.Error.UnableToParseLowerBoundKeyValue", (String[])new String[]{keyStartS}), (Throwable)e);
                        }
                    }
                } else {
                    keyLowerBound = HBaseValueMeta.encodeKeyValue((String)keyStartS, (Mapping.KeyType)keyType, (HBaseBytesUtilShim)this.hBaseBytesUtilShim);
                }
            } else {
                keyLowerBound = HBaseValueMeta.encodeKeyValue((String)keyStartS, (Mapping.KeyType)keyType, (HBaseBytesUtilShim)this.hBaseBytesUtilShim);
            }
            if (!Const.isEmpty((String)keyStopS)) {
                keyStopS = vars.environmentSubstitute(keyStopS);
                convM = dateOrNumberConversionMaskForKey;
                if (tableMapping.getKeyType() == Mapping.KeyType.BINARY) {
                    keyUpperBound = HBaseValueMeta.encodeKeyValue((String)keyStopS, (Mapping.KeyType)keyType, (HBaseBytesUtilShim)this.hBaseBytesUtilShim);
                } else if (tableMapping.getKeyType() != Mapping.KeyType.STRING) {
                    parts = keyStopS.split("@");
                    if (parts.length == 2) {
                        keyStopS = parts[0];
                        convM = parts[1];
                    }
                    if (!Const.isEmpty((String)convM) && convM.length() > 0) {
                        if (tableMapping.getKeyType() == Mapping.KeyType.DATE || tableMapping.getKeyType() == Mapping.KeyType.UNSIGNED_DATE) {
                            sdf = new SimpleDateFormat();
                            sdf.applyPattern(convM);
                            try {
                                d = sdf.parse(keyStopS);
                                keyUpperBound = HBaseValueMeta.encodeKeyValue((Object)d, (Mapping.KeyType)keyType, (HBaseBytesUtilShim)this.hBaseBytesUtilShim);
                            }
                            catch (ParseException e) {
                                throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseInput.Error.UnableToParseUpperBoundKeyValue", (String[])new String[]{keyStopS}), (Throwable)e);
                            }
                        } else {
                            df = new DecimalFormat();
                            df.applyPattern(convM);
                            num = null;
                            try {
                                num = df.parse(keyStopS);
                                keyUpperBound = HBaseValueMeta.encodeKeyValue((Object)num, (Mapping.KeyType)keyType, (HBaseBytesUtilShim)this.hBaseBytesUtilShim);
                            }
                            catch (ParseException e) {
                                throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseInput.Error.UnableToParseUpperBoundKeyValue", (String[])new String[]{keyStopS}), (Throwable)e);
                            }
                        }
                    } else {
                        keyUpperBound = HBaseValueMeta.encodeKeyValue((String)keyStopS, (Mapping.KeyType)keyType, (HBaseBytesUtilShim)this.hBaseBytesUtilShim);
                    }
                } else {
                    keyUpperBound = HBaseValueMeta.encodeKeyValue((String)keyStopS, (Mapping.KeyType)keyType, (HBaseBytesUtilShim)this.hBaseBytesUtilShim);
                }
            }
        }
        int cacheSize = 0;
        if (!Const.isEmpty((String)scannerCacheSize)) {
            String temp = vars.environmentSubstitute(scannerCacheSize);
            cacheSize = Integer.parseInt(temp);
            if (log != null) {
                log.logBasic(BaseMessages.getString(PKG, (String)"HBaseInput.Message.SettingScannerCaching", (Object[])new Object[]{cacheSize}));
            }
        }
        return new ResultScannerBuilderImpl(this.hBaseConnectionPool, this.hBaseValueMetaInterfaceFactory, this.hBaseBytesUtilShim, this.name, cacheSize, keyLowerBound, keyUpperBound);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getColumnFamilies() throws IOException {
        try (HBaseConnectionHandle hBaseConnectionHandle = this.hBaseConnectionPool.getConnectionHandle();){
            List<String> list = hBaseConnectionHandle.getConnection().getTableFamiles(this.name);
            return list;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean keyExists(byte[] key) throws IOException {
        try (HBaseConnectionHandle hBaseConnectionHandle = this.hBaseConnectionPool.getConnectionHandle(this.name);){
            boolean bl = hBaseConnectionHandle.getConnection().sourceTableRowExists(key);
            return bl;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public HBaseTableWriteOperationManager createWriteOperationManager(Long writeBufferSize) throws IOException {
        Properties targetTableProps = new Properties();
        if (writeBufferSize != null) {
            targetTableProps.setProperty("htable.writeBufferSize", writeBufferSize.toString());
        }
        return new HBaseTableWriteOperationManagerImpl(this.hBaseConnectionPool.getConnectionHandle(this.name, targetTableProps), writeBufferSize != null);
    }

    public void close() throws IOException {
    }
}

