/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.dialect.SybaseASE15Dialect;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.sql.ForUpdateFragment;
import org.hibernate.type.StandardBasicTypes;

public class SybaseASE157Dialect
extends SybaseASE15Dialect {
    public SybaseASE157Dialect() {
        this.registerFunction("create_locator", new SQLFunctionTemplate(StandardBasicTypes.BINARY, "create_locator(?1, ?2)"));
        this.registerFunction("locator_literal", new SQLFunctionTemplate(StandardBasicTypes.BINARY, "locator_literal(?1, ?2)"));
        this.registerFunction("locator_valid", new SQLFunctionTemplate(StandardBasicTypes.BOOLEAN, "locator_valid(?1)"));
        this.registerFunction("return_lob", new SQLFunctionTemplate(StandardBasicTypes.BINARY, "return_lob(?1, ?2)"));
        this.registerFunction("setdata", new SQLFunctionTemplate(StandardBasicTypes.BOOLEAN, "setdata(?1, ?2, ?3)"));
        this.registerFunction("charindex", new SQLFunctionTemplate(StandardBasicTypes.INTEGER, "charindex(?1, ?2, ?3)"));
    }

    public boolean supportsExpectedLobUsagePattern() {
        return true;
    }

    public boolean supportsLobValueChangePropogation() {
        return false;
    }

    public boolean forUpdateOfColumns() {
        return true;
    }

    public String getForUpdateString() {
        return " for update";
    }

    public String getForUpdateString(String aliases) {
        return this.getForUpdateString() + " of " + aliases;
    }

    public String appendLockHint(LockMode mode, String tableName) {
        return tableName;
    }

    public String applyLocksToSql(String sql, LockOptions aliasedLockOptions, Map keyColumnNames) {
        return sql + new ForUpdateFragment(this, aliasedLockOptions, keyColumnNames).toFragmentString();
    }
}

