/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.mstor.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;
import net.fortuna.mstor.data.MboxEncoder;
import net.fortuna.mstor.util.Configurator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageAppender {
    private static final Pattern MESSAGE_WITH_FROM__LINE_PATTERN = Pattern.compile("^From .*", 32);
    public static final String FROM__PREFIX = "From ";
    private static final char[] DEFAULT_LINE_SEPARATOR = new char[]{'\r', '\n'};
    private static final String FROM__DATE_PATTERN = "EEE MMM d HH:mm:ss yyyy";
    private Log log = LogFactory.getLog(MessageAppender.class);
    private CharsetDecoder decoder;
    private CharsetEncoder encoder;
    private final DateFormat from_DateFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Locale.US);
    private FileChannel channel;

    public MessageAppender(FileChannel channel) {
        this(channel, Charset.forName(Configurator.getProperty("mstor.mbox.encoding", "ISO-8859-1")));
    }

    public MessageAppender(FileChannel channel, Charset charset) {
        this.from_DateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.channel = channel;
        this.decoder = charset.newDecoder();
        this.encoder = charset.newEncoder();
        this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    public long appendMessage(byte[] message) throws IOException {
        long messagePosition = this.channel.size();
        ByteBuffer buffer = ByteBuffer.wrap(MboxEncoder.encode(message));
        CharBuffer decoded = this.decoder.decode(buffer);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Appending message [" + decoded + "]"));
        }
        if (!this.hasFromLine(decoded)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"No From_ line found - inserting..");
            }
            this.channel.write(this.encoder.encode(CharBuffer.wrap(this.createFromLine())), this.channel.size());
        }
        buffer.rewind();
        this.channel.write(buffer, this.channel.size());
        return messagePosition;
    }

    private boolean hasFromLine(CharSequence message) {
        return MESSAGE_WITH_FROM__LINE_PATTERN.matcher(message).matches();
    }

    private String createFromLine() throws IOException {
        StringBuffer from_Line = new StringBuffer();
        if (this.channel.size() > 0L) {
            from_Line.append(DEFAULT_LINE_SEPARATOR);
            from_Line.append(DEFAULT_LINE_SEPARATOR);
        }
        from_Line.append(FROM__PREFIX);
        from_Line.append("- ");
        from_Line.append(this.from_DateFormat.format(new Date()));
        from_Line.append(DEFAULT_LINE_SEPARATOR);
        return from_Line.toString();
    }
}

