/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hbase.input;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.cluster.NamedClusterService;
import org.pentaho.big.data.api.cluster.service.locator.NamedClusterServiceLocator;
import org.pentaho.big.data.api.initializer.ClusterInitializationException;
import org.pentaho.big.data.kettle.plugins.hbase.FilterDefinition;
import org.pentaho.big.data.kettle.plugins.hbase.MappingDefinition;
import org.pentaho.big.data.kettle.plugins.hbase.NamedClusterLoadSaveUtil;
import org.pentaho.big.data.kettle.plugins.hbase.ServiceStatus;
import org.pentaho.big.data.kettle.plugins.hbase.input.HBaseInput;
import org.pentaho.big.data.kettle.plugins.hbase.input.HBaseInputData;
import org.pentaho.big.data.kettle.plugins.hbase.input.Messages;
import org.pentaho.big.data.kettle.plugins.hbase.input.OutputFieldDefinition;
import org.pentaho.big.data.kettle.plugins.hbase.mapping.MappingAdmin;
import org.pentaho.big.data.kettle.plugins.hbase.mapping.MappingUtils;
import org.pentaho.big.data.kettle.plugins.hbase.meta.AELHBaseMappingImpl;
import org.pentaho.big.data.kettle.plugins.hbase.meta.AELHBaseValueMetaImpl;
import org.pentaho.bigdata.api.hbase.ByteConversionUtil;
import org.pentaho.bigdata.api.hbase.HBaseConnection;
import org.pentaho.bigdata.api.hbase.HBaseService;
import org.pentaho.bigdata.api.hbase.mapping.ColumnFilter;
import org.pentaho.bigdata.api.hbase.mapping.ColumnFilterFactory;
import org.pentaho.bigdata.api.hbase.mapping.Mapping;
import org.pentaho.bigdata.api.hbase.mapping.MappingFactory;
import org.pentaho.bigdata.api.hbase.meta.HBaseValueMetaInterface;
import org.pentaho.bigdata.api.hbase.meta.HBaseValueMetaInterfaceFactory;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.runtime.test.RuntimeTester;
import org.pentaho.runtime.test.action.RuntimeTestActionService;
import org.w3c.dom.Node;

@Step(id="HBaseInput", image="HB.svg", name="HBaseInput.Name", description="HBaseInput.Description", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.BigData", documentationUrl="Products/Data_Integration/Transformation_Step_Reference/HBase_Input", i18nPackageName="org.pentaho.di.trans.steps.hbaseinput")
@InjectionSupported(localizationPrefix="HBaseInput.Injection.", groups={"OUTPUT_FIELDS", "MAPPING", "FILTER"})
public class HBaseInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    protected static Class<?> PKG = HBaseInputMeta.class;
    private final NamedClusterLoadSaveUtil namedClusterLoadSaveUtil;
    private final NamedClusterService namedClusterService;
    private final NamedClusterServiceLocator namedClusterServiceLocator;
    private final RuntimeTestActionService runtimeTestActionService;
    private final RuntimeTester runtimeTester;
    protected NamedCluster namedCluster;
    @Injection(name="HBASE_SITE_XML_URL")
    protected String m_coreConfigURL;
    @Injection(name="HBASE_DEFAULT_XML_URL")
    protected String m_defaultConfigURL;
    @Injection(name="SOURCE_TABLE_NAME")
    protected String m_sourceTableName;
    @Injection(name="SOURCE_MAPPING_NAME")
    protected String m_sourceMappingName;
    @Injection(name="START_KEY_VALUE")
    protected String m_keyStart;
    @Injection(name="STOP_KEY_VALUE")
    protected String m_keyStop;
    @Injection(name="SCANNER_ROW_CACHE_SIZE")
    protected String m_scannerCacheSize;
    protected transient Mapping m_cachedMapping;
    protected List<HBaseValueMetaInterface> m_outputFields;
    @InjectionDeep
    protected List<OutputFieldDefinition> outputFieldsDefinition;
    protected List<ColumnFilter> m_filters;
    @InjectionDeep
    protected List<FilterDefinition> filtersDefinition;
    @Injection(name="MATCH_ANY_FILTER")
    protected boolean m_matchAnyFilter;
    protected Mapping m_mapping;
    @InjectionDeep
    protected MappingDefinition mappingDefinition;
    private ServiceStatus serviceStatus = ServiceStatus.OK;

    public HBaseInputMeta(NamedClusterService namedClusterService, NamedClusterServiceLocator namedClusterServiceLocator, RuntimeTestActionService runtimeTestActionService, RuntimeTester runtimeTester) {
        this.namedClusterService = namedClusterService;
        this.namedClusterServiceLocator = namedClusterServiceLocator;
        this.runtimeTestActionService = runtimeTestActionService;
        this.runtimeTester = runtimeTester;
        this.namedClusterLoadSaveUtil = new NamedClusterLoadSaveUtil();
    }

    public void setMapping(Mapping m) {
        this.m_mapping = m;
    }

    public Mapping getMapping() {
        return this.m_mapping;
    }

    public void setCoreConfigURL(String coreConfig) {
        this.m_coreConfigURL = coreConfig;
        this.m_cachedMapping = null;
    }

    public String getCoreConfigURL() {
        return this.m_coreConfigURL;
    }

    public void setDefaulConfigURL(String defaultConfig) {
        this.m_defaultConfigURL = defaultConfig;
        this.m_cachedMapping = null;
    }

    public String getDefaultConfigURL() {
        return this.m_defaultConfigURL;
    }

    public void setSourceTableName(String sourceTable) {
        this.m_sourceTableName = sourceTable;
        this.m_cachedMapping = null;
    }

    public String getSourceTableName() {
        return this.m_sourceTableName;
    }

    public void setSourceMappingName(String sourceMapping) {
        this.m_sourceMappingName = sourceMapping;
        this.m_cachedMapping = null;
    }

    public String getSourceMappingName() {
        return this.m_sourceMappingName;
    }

    public void setMatchAnyFilter(boolean a) {
        this.m_matchAnyFilter = a;
    }

    public boolean getMatchAnyFilter() {
        return this.m_matchAnyFilter;
    }

    public void setKeyStartValue(String start) {
        this.m_keyStart = start;
    }

    public String getKeyStartValue() {
        return this.m_keyStart;
    }

    public void setKeyStopValue(String stop) {
        this.m_keyStop = stop;
    }

    public String getKeyStopValue() {
        return this.m_keyStop;
    }

    public void setScannerCacheSize(String s) {
        this.m_scannerCacheSize = s;
    }

    public String getScannerCacheSize() {
        return this.m_scannerCacheSize;
    }

    public void setOutputFields(List<HBaseValueMetaInterface> fields) {
        this.m_outputFields = fields;
    }

    public List<HBaseValueMetaInterface> getOutputFields() {
        return this.m_outputFields;
    }

    public void setColumnFilters(List<ColumnFilter> list) {
        this.m_filters = list;
    }

    public List<ColumnFilter> getColumnFilters() {
        return this.m_filters;
    }

    public void setDefault() {
        this.m_coreConfigURL = null;
        this.m_defaultConfigURL = null;
        this.m_cachedMapping = null;
        this.m_sourceTableName = null;
        this.m_sourceMappingName = null;
        this.m_keyStart = null;
        this.m_keyStop = null;
        this.namedCluster = this.namedClusterService.getClusterTemplate();
    }

    private String getIndexValues(HBaseValueMetaInterface vm) {
        Object[] labels = vm.getIndex();
        StringBuffer vals = new StringBuffer();
        vals.append("{");
        for (int i = 0; i < labels.length; ++i) {
            if (i != labels.length - 1) {
                vals.append(labels[i].toString().trim()).append(",");
                continue;
            }
            vals.append(labels[i].toString().trim()).append("}");
        }
        return vals.toString();
    }

    void applyInjection(VariableSpace space) throws KettleException {
        if (this.namedCluster == null) {
            throw new KettleException("Named cluster was not initialized!");
        }
        try {
            HBaseService hBaseService = this.getService();
            Mapping tempMapping = null;
            if (this.mappingDefinition != null) {
                tempMapping = this.getMapping(this.mappingDefinition, hBaseService);
                this.setMapping(tempMapping);
            }
            if (this.outputFieldsDefinition != null && !this.outputFieldsDefinition.isEmpty()) {
                if (this.mappingDefinition == null) {
                    tempMapping = !Const.isEmpty((String)this.m_sourceMappingName) ? HBaseInputMeta.getMappingFromHBase(hBaseService, space, this.m_sourceTableName, this.m_sourceMappingName, this.m_coreConfigURL, this.m_defaultConfigURL) : this.m_mapping;
                }
                this.setOutputFields(this.createOutputFieldsDefinition(tempMapping, hBaseService));
            }
            if (this.filtersDefinition != null && !this.filtersDefinition.isEmpty()) {
                ColumnFilterFactory columnFilterFactory = hBaseService.getColumnFilterFactory();
                this.setColumnFilters(this.createColumnFiltersFromDefinition(columnFilterFactory));
            }
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    @VisibleForTesting
    Mapping getMapping(MappingDefinition mappingDefinition, HBaseService hBaseService) throws KettleException {
        return MappingUtils.getMapping(mappingDefinition, hBaseService);
    }

    static Mapping getMappingFromHBase(HBaseService hBaseService, VariableSpace space, String tableName, String mappingName, String coreConfigURL, String defaultConfigURL) throws KettleException {
        try {
            String siteConfig = "";
            if (!Const.isEmpty((String)coreConfigURL)) {
                siteConfig = space.environmentSubstitute(coreConfigURL);
            }
            String defaultConfig = "";
            if (!Const.isEmpty((String)defaultConfigURL)) {
                defaultConfig = space.environmentSubstitute(defaultConfigURL);
            }
            MappingAdmin mappingAdmin = MappingUtils.getMappingAdmin(hBaseService, space, siteConfig, defaultConfig);
            return mappingAdmin.getMapping(tableName, mappingName);
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    @VisibleForTesting
    List<HBaseValueMetaInterface> createOutputFieldsDefinition(Mapping mapping, HBaseService hBaseService) {
        return HBaseInputMeta.createOutputFieldsDefinition(this.outputFieldsDefinition, mapping, hBaseService);
    }

    static List<HBaseValueMetaInterface> createOutputFieldsDefinition(List<OutputFieldDefinition> outputFieldsDefinition, Mapping m_mapping, HBaseService hBaseService) {
        HBaseValueMetaInterfaceFactory valueMetaInterfaceFactory = hBaseService.getHBaseValueMetaInterfaceFactory();
        ByteConversionUtil byteConversionUtil = hBaseService.getByteConversionUtil();
        ArrayList<HBaseValueMetaInterface> outputFields = new ArrayList<HBaseValueMetaInterface>();
        Map columns = m_mapping.getMappedColumns();
        for (OutputFieldDefinition fieldDefinition : outputFieldsDefinition) {
            HBaseValueMetaInterface valueMeta = valueMetaInterfaceFactory.createHBaseValueMetaInterface(fieldDefinition.getFamily(), fieldDefinition.getColumnName(), fieldDefinition.getAlias(), ValueMeta.getType((String)fieldDefinition.getHbaseType()), -1, -1);
            valueMeta.setKey(fieldDefinition.isKey());
            valueMeta.setConversionMask(fieldDefinition.getFormat());
            HBaseValueMetaInterface mappedColumn = (HBaseValueMetaInterface)columns.get(fieldDefinition.getAlias());
            if (mappedColumn != null && mappedColumn.getIndex() != null) {
                Object[] indexVal = mappedColumn.getIndex();
                String indexStrign = byteConversionUtil.objectIndexValuesToString(indexVal);
                Object[] vals = byteConversionUtil.stringIndexListToObjects(indexStrign);
                valueMeta.setIndex(vals);
                valueMeta.setStorageType(2);
            }
            outputFields.add(valueMeta);
        }
        return outputFields;
    }

    @VisibleForTesting
    List<ColumnFilter> createColumnFiltersFromDefinition(ColumnFilterFactory c) {
        return HBaseInputMeta.createColumnFiltersFromDefinition(this.filtersDefinition, c);
    }

    static List<ColumnFilter> createColumnFiltersFromDefinition(List<FilterDefinition> filtersDefinition, ColumnFilterFactory columnFilterFactory) {
        ArrayList<ColumnFilter> filters = new ArrayList<ColumnFilter>();
        for (FilterDefinition filterDefinition : filtersDefinition) {
            ColumnFilter columnFilter = columnFilterFactory.createFilter(filterDefinition.getAlias());
            columnFilter.setFieldType(filterDefinition.getFieldType());
            columnFilter.setComparisonOperator(filterDefinition.getComparisonType());
            columnFilter.setConstant(filterDefinition.getConstant());
            columnFilter.setSignedComparison(filterDefinition.isSignedComparison());
            columnFilter.setFormat(filterDefinition.getFormat());
            filters.add(columnFilter);
        }
        return filters;
    }

    public String getXML() {
        try {
            this.applyInjection((VariableSpace)new Variables());
        }
        catch (KettleException e) {
            this.logError("Error occurred while injecting metadata. Transformation meta could be incorrect!", e);
        }
        StringBuilder retval = new StringBuilder();
        this.namedClusterLoadSaveUtil.getXml(retval, this.namedClusterService, this.namedCluster, this.repository == null ? null : this.repository.getMetaStore(), this.getLog());
        if (!Const.isEmpty((String)this.m_coreConfigURL)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"core_config_url", (String)this.m_coreConfigURL));
        }
        if (!Const.isEmpty((String)this.m_defaultConfigURL)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"default_config_url", (String)this.m_defaultConfigURL));
        }
        if (!Const.isEmpty((String)this.m_sourceTableName)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"source_table_name", (String)this.m_sourceTableName));
        }
        if (!Const.isEmpty((String)this.m_sourceMappingName)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"source_mapping_name", (String)this.m_sourceMappingName));
        }
        if (!Const.isEmpty((String)this.m_keyStart)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"key_start", (String)this.m_keyStart));
        }
        if (!Const.isEmpty((String)this.m_keyStop)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"key_stop", (String)this.m_keyStop));
        }
        if (!Const.isEmpty((String)this.m_scannerCacheSize)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"scanner_cache_size", (String)this.m_scannerCacheSize));
        }
        if (this.m_outputFields != null && this.m_outputFields.size() > 0) {
            retval.append("\n    ").append(XMLHandler.openTag((String)"output_fields"));
            for (HBaseValueMetaInterface vm : this.m_outputFields) {
                vm.getXml(retval);
            }
            retval.append("\n    ").append(XMLHandler.closeTag((String)"output_fields"));
        }
        if (this.m_filters != null && this.m_filters.size() > 0) {
            retval.append("\n    ").append(XMLHandler.openTag((String)"column_filters"));
            for (ColumnFilter f : this.m_filters) {
                f.appendXML(retval);
            }
            retval.append("\n    ").append(XMLHandler.closeTag((String)"column_filters"));
        }
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"match_any_filter", (boolean)this.m_matchAnyFilter));
        if (this.m_mapping != null) {
            retval.append(this.m_mapping.getXML());
        }
        return retval.toString();
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        System.out.println("loading data");
        this.namedCluster = this.namedClusterLoadSaveUtil.loadClusterConfig(this.namedClusterService, null, this.repository, metaStore, stepnode, this.getLog());
        HBaseService hBaseService = null;
        try {
            hBaseService = this.getService();
        }
        catch (Exception e) {
            this.getLog().logError(e.getMessage());
        }
        this.m_coreConfigURL = XMLHandler.getTagValue((Node)stepnode, (String)"core_config_url");
        this.m_defaultConfigURL = XMLHandler.getTagValue((Node)stepnode, (String)"default_config_url");
        this.m_sourceTableName = XMLHandler.getTagValue((Node)stepnode, (String)"source_table_name");
        this.m_sourceMappingName = XMLHandler.getTagValue((Node)stepnode, (String)"source_mapping_name");
        this.m_keyStart = XMLHandler.getTagValue((Node)stepnode, (String)"key_start");
        this.m_keyStop = XMLHandler.getTagValue((Node)stepnode, (String)"key_stop");
        this.m_scannerCacheSize = XMLHandler.getTagValue((Node)stepnode, (String)"scanner_cache_size");
        String m = XMLHandler.getTagValue((Node)stepnode, (String)"match_any_filter");
        if (!Const.isEmpty((String)m)) {
            this.m_matchAnyFilter = m.equalsIgnoreCase("Y");
        }
        if (hBaseService != null) {
            Mapping tempMapping;
            HBaseValueMetaInterfaceFactory valueMetaInterfaceFactory = hBaseService.getHBaseValueMetaInterfaceFactory();
            this.m_outputFields = valueMetaInterfaceFactory.createListFromNode(stepnode);
            ColumnFilterFactory columnFilterFactory = hBaseService.getColumnFilterFactory();
            MappingFactory mappingFactory = hBaseService.getMappingFactory();
            Node filters = XMLHandler.getSubNode((Node)stepnode, (String)"column_filters");
            if (filters != null && XMLHandler.countNodes((Node)filters, (String)"filter") > 0) {
                int nrFilters = XMLHandler.countNodes((Node)filters, (String)"filter");
                this.m_filters = new ArrayList<ColumnFilter>();
                for (int i = 0; i < nrFilters; ++i) {
                    Node filterNode = XMLHandler.getSubNodeByNr((Node)filters, (String)"filter", (int)i);
                    this.m_filters.add(columnFilterFactory.createFilter(filterNode));
                }
            }
            this.m_mapping = (tempMapping = mappingFactory.createMapping()).loadXML(stepnode) ? tempMapping : null;
        } else {
            AELHBaseMappingImpl tempMapping = new AELHBaseMappingImpl();
            if (tempMapping.loadXML(stepnode)) {
                this.m_mapping = tempMapping;
            } else {
                this.getLog().logError("There is no meta data to inflate meta object");
            }
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"output_fields");
            if (fields != null) {
                int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
                ArrayList<HBaseValueMetaInterface> m_outputFields = new ArrayList<HBaseValueMetaInterface>(nrfields);
                for (int i = 0; i < nrfields; ++i) {
                    m_outputFields.add(this.createFromNode(XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i)));
                }
            }
        }
    }

    private HBaseValueMetaInterface createFromNode(Node fieldNode) {
        String isKey = XMLHandler.getTagValue((Node)fieldNode, (String)"key").trim();
        String alias = XMLHandler.getTagValue((Node)fieldNode, (String)"alias").trim();
        String columnFamily = "";
        String columnName = alias;
        if (!isKey.equalsIgnoreCase("Y")) {
            if (XMLHandler.getTagValue((Node)fieldNode, (String)"family") != null) {
                columnFamily = XMLHandler.getTagValue((Node)fieldNode, (String)"family").trim();
            }
            if (XMLHandler.getTagValue((Node)fieldNode, (String)"column") != null) {
                columnName = XMLHandler.getTagValue((Node)fieldNode, (String)"column").trim();
            }
        }
        String typeS = XMLHandler.getTagValue((Node)fieldNode, (String)"type").trim();
        String tableName = XMLHandler.getTagValue((Node)fieldNode, (String)"table_name");
        String mappingName = XMLHandler.getTagValue((Node)fieldNode, (String)"mapping_name");
        AELHBaseValueMetaImpl vm = new AELHBaseValueMetaImpl(isKey.equalsIgnoreCase("Y"), alias, columnName, columnFamily, tableName, mappingName);
        vm.setHBaseTypeFromString(typeS);
        return vm;
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        int i;
        this.namedClusterLoadSaveUtil.saveRep(rep, metaStore, id_transformation, id_step, this.namedClusterService, this.namedCluster, this.getLog());
        if (!Const.isEmpty((String)this.m_coreConfigURL)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "core_config_url", this.m_coreConfigURL);
        }
        if (!Const.isEmpty((String)this.m_defaultConfigURL)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "default_config_url", this.m_defaultConfigURL);
        }
        if (!Const.isEmpty((String)this.m_sourceTableName)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "source_table_name", this.m_sourceTableName);
        }
        if (!Const.isEmpty((String)this.m_sourceMappingName)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "source_mapping_name", this.m_sourceMappingName);
        }
        if (!Const.isEmpty((String)this.m_keyStart)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "key_start", this.m_keyStart);
        }
        if (!Const.isEmpty((String)this.m_keyStop)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "key_stop", this.m_keyStop);
        }
        if (!Const.isEmpty((String)this.m_scannerCacheSize)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "scanner_cache_size", this.m_scannerCacheSize);
        }
        if (this.m_outputFields != null && this.m_outputFields.size() > 0) {
            for (i = 0; i < this.m_outputFields.size(); ++i) {
                this.m_outputFields.get(i).saveRep(rep, id_transformation, id_step, i);
            }
        }
        if (this.m_filters != null && this.m_filters.size() > 0) {
            for (i = 0; i < this.m_filters.size(); ++i) {
                ColumnFilter f = this.m_filters.get(i);
                f.saveRep(rep, id_transformation, id_step, i);
            }
        }
        rep.saveStepAttribute(id_transformation, id_step, 0, "match_any_filter", this.m_matchAnyFilter);
        if (this.m_mapping != null) {
            this.m_mapping.saveRep(rep, id_transformation, id_step);
        }
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        this.namedCluster = this.namedClusterLoadSaveUtil.loadClusterConfig(this.namedClusterService, id_step, rep, metaStore, null, this.getLog());
        HBaseService hBaseService = null;
        try {
            hBaseService = this.getService();
        }
        catch (Exception e) {
            this.getLog().logError(e.getMessage());
        }
        this.m_coreConfigURL = rep.getStepAttributeString(id_step, 0, "core_config_url");
        this.m_defaultConfigURL = rep.getStepAttributeString(id_step, 0, "default_config_url");
        this.m_sourceTableName = rep.getStepAttributeString(id_step, 0, "source_table_name");
        this.m_sourceMappingName = rep.getStepAttributeString(id_step, 0, "source_mapping_name");
        this.m_keyStart = rep.getStepAttributeString(id_step, 0, "key_start");
        this.m_keyStop = rep.getStepAttributeString(id_step, 0, "key_stop");
        this.m_matchAnyFilter = rep.getStepAttributeBoolean(id_step, 0, "match_any_filter");
        this.m_scannerCacheSize = rep.getStepAttributeString(id_step, 0, "scanner_cache_size");
        if (hBaseService != null) {
            Mapping tempMapping;
            HBaseValueMetaInterfaceFactory valueMetaInterfaceFactory = hBaseService.getHBaseValueMetaInterfaceFactory();
            ColumnFilterFactory columnFilterFactory = hBaseService.getColumnFilterFactory();
            MappingFactory mappingFactory = hBaseService.getMappingFactory();
            this.m_outputFields = valueMetaInterfaceFactory.createListFromRepository(rep, id_step);
            int nrFilters = rep.countNrStepAttributes(id_step, "cf_comparison_opp");
            if (nrFilters > 0) {
                this.m_filters = new ArrayList<ColumnFilter>();
                for (int i = 0; i < nrFilters; ++i) {
                    this.m_filters.add(columnFilterFactory.createFilter(rep, i, id_step));
                }
            }
            this.m_mapping = (tempMapping = mappingFactory.createMapping()).readRep(rep, id_step) ? tempMapping : null;
        }
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace variableSpace, Repository repository, IMetaStore metaStore) {
        RowMeta r = new RowMeta();
        try {
            this.getFields((RowMetaInterface)r, "testName", null, null, null, repository, metaStore);
            CheckResult cr = new CheckResult(1, "Step can connect to HBase. Named mapping exists", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        catch (Exception ex) {
            CheckResult cr = new CheckResult(4, ex.getMessage(), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        return new HBaseInput(stepMeta, stepDataInterface, copyNr, transMeta, trans, this.namedClusterServiceLocator);
    }

    public StepDataInterface getStepData() {
        return new HBaseInputData();
    }

    private void setupCachedMapping(VariableSpace space) throws KettleStepException {
        HBaseService hBaseService = null;
        try {
            hBaseService = this.getService();
        }
        catch (ClusterInitializationException e) {
            throw new KettleStepException((Throwable)e);
        }
        if (Const.isEmpty((String)this.m_coreConfigURL) && Const.isEmpty((String)this.namedCluster.getZooKeeperHost())) {
            throw new KettleStepException("No output fields available (missing connection details)!");
        }
        if (this.m_mapping == null && (Const.isEmpty((String)this.m_sourceTableName) || Const.isEmpty((String)this.m_sourceMappingName))) {
            throw new KettleStepException("No output fields available (missing table mapping details)!");
        }
        if (this.m_cachedMapping == null) {
            if (this.m_mapping != null) {
                this.m_cachedMapping = this.m_mapping;
            } else {
                String coreConf = null;
                String defaultConf = null;
                try {
                    if (!Const.isEmpty((String)this.m_coreConfigURL)) {
                        coreConf = space.environmentSubstitute(this.m_coreConfigURL);
                    }
                    if (!Const.isEmpty((String)this.m_defaultConfigURL)) {
                        defaultConf = space.environmentSubstitute(this.m_defaultConfigURL);
                    }
                }
                catch (Exception ex) {
                    throw new KettleStepException(ex.getMessage(), (Throwable)ex);
                }
                ArrayList forLogging = new ArrayList();
                try (HBaseConnection conf = hBaseService.getHBaseConnection(space, coreConf, defaultConf, this.getLog());){
                    MappingAdmin mappingAdmin = null;
                    for (String m : forLogging) {
                        this.logBasic(m);
                    }
                    mappingAdmin = new MappingAdmin(conf);
                    this.m_cachedMapping = mappingAdmin.getMapping(this.m_sourceTableName, this.m_sourceMappingName);
                }
                catch (Exception ex) {
                    throw new KettleStepException(ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        rowMeta.clear();
        if (this.m_outputFields != null && this.m_outputFields.size() > 0) {
            for (HBaseValueMetaInterface vm : this.m_outputFields) {
                vm.setOrigin(origin);
                rowMeta.addValueMeta((ValueMetaInterface)vm);
            }
        } else {
            this.setupCachedMapping(space);
            int kettleType = this.m_cachedMapping.getKeyType() == Mapping.KeyType.DATE || this.m_cachedMapping.getKeyType() == Mapping.KeyType.UNSIGNED_DATE ? 3 : (this.m_cachedMapping.getKeyType() == Mapping.KeyType.STRING ? 2 : (this.m_cachedMapping.getKeyType() == Mapping.KeyType.BINARY ? 8 : 5));
            ValueMeta keyMeta = new ValueMeta(this.m_cachedMapping.getKeyName(), kettleType);
            keyMeta.setOrigin(origin);
            rowMeta.addValueMeta((ValueMetaInterface)keyMeta);
            Map mappedColumnsByAlias = this.m_cachedMapping.getMappedColumns();
            Set aliasSet = mappedColumnsByAlias.keySet();
            for (String alias : aliasSet) {
                HBaseValueMetaInterface columnMeta = (HBaseValueMetaInterface)mappedColumnsByAlias.get(alias);
                columnMeta.setOrigin(origin);
                rowMeta.addValueMeta((ValueMetaInterface)columnMeta);
            }
        }
    }

    public NamedCluster getNamedCluster() {
        return this.namedCluster;
    }

    public void setNamedCluster(NamedCluster namedCluster) {
        this.namedCluster = namedCluster;
    }

    public NamedClusterService getNamedClusterService() {
        return this.namedClusterService;
    }

    public NamedClusterServiceLocator getNamedClusterServiceLocator() {
        return this.namedClusterServiceLocator;
    }

    public RuntimeTestActionService getRuntimeTestActionService() {
        return this.runtimeTestActionService;
    }

    public RuntimeTester getRuntimeTester() {
        return this.runtimeTester;
    }

    public List<OutputFieldDefinition> getOutputFieldsDefinition() {
        return this.outputFieldsDefinition;
    }

    public void setOutputFieldsDefinition(List<OutputFieldDefinition> outputFieldsDefinition) {
        this.outputFieldsDefinition = outputFieldsDefinition;
    }

    public List<FilterDefinition> getFiltersDefinition() {
        return this.filtersDefinition;
    }

    public void setFiltersDefinition(List<FilterDefinition> filtersDefinition) {
        this.filtersDefinition = filtersDefinition;
    }

    public MappingDefinition getMappingDefinition() {
        return this.mappingDefinition;
    }

    public void setMappingDefinition(MappingDefinition mappingDefinition) {
        this.mappingDefinition = mappingDefinition;
    }

    protected HBaseService getService() throws ClusterInitializationException {
        HBaseService service = null;
        try {
            service = (HBaseService)this.namedClusterServiceLocator.getService(this.namedCluster, HBaseService.class);
            this.serviceStatus = ServiceStatus.OK;
        }
        catch (Exception e) {
            this.serviceStatus = ServiceStatus.notOk(e);
            this.logError(Messages.getString("HBaseInput.Error.ServiceStatus"));
            throw e;
        }
        return service;
    }

    public ServiceStatus getServiceStatus() {
        if (this.serviceStatus == null) {
            this.serviceStatus = ServiceStatus.OK;
        }
        return this.serviceStatus;
    }
}

