/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Function;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.MathUtils;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

public class Operation
extends Expression {
    public static final int CONCAT = 0;
    public static final int PLUS = 1;
    public static final int MINUS = 2;
    public static final int MULTIPLY = 3;
    public static final int DIVIDE = 4;
    public static final int NEGATE = 5;
    private int opType;
    private Expression left;
    private Expression right;
    private int dataType;

    public Operation(int n, Expression expression, Expression expression2) {
        this.opType = n;
        this.left = expression;
        this.right = expression2;
    }

    public String getSQL() {
        String string;
        switch (this.opType) {
            case 5: {
                string = "- " + this.left.getSQL();
                break;
            }
            case 0: {
                string = this.left.getSQL() + " || " + this.right.getSQL();
                break;
            }
            case 1: {
                string = this.left.getSQL() + " + " + this.right.getSQL();
                break;
            }
            case 2: {
                string = this.left.getSQL() + " - " + this.right.getSQL();
                break;
            }
            case 3: {
                string = this.left.getSQL() + " * " + this.right.getSQL();
                break;
            }
            case 4: {
                string = this.left.getSQL() + " / " + this.right.getSQL();
                break;
            }
            default: {
                throw DbException.throwInternalError("opType=" + this.opType);
            }
        }
        return "(" + string + ")";
    }

    public Value getValue(Session session) {
        Value value = this.left.getValue(session).convertTo(this.dataType);
        Value value2 = this.right == null ? null : this.right.getValue(session).convertTo(this.dataType);
        switch (this.opType) {
            case 5: {
                return value == ValueNull.INSTANCE ? value : value.negate();
            }
            case 0: {
                Mode mode = session.getDatabase().getMode();
                if (value == ValueNull.INSTANCE) {
                    if (mode.nullConcatIsNull) {
                        return ValueNull.INSTANCE;
                    }
                    return value2;
                }
                if (value2 == ValueNull.INSTANCE) {
                    if (mode.nullConcatIsNull) {
                        return ValueNull.INSTANCE;
                    }
                    return value;
                }
                String string = value.getString();
                String string2 = value2.getString();
                StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length());
                stringBuilder.append(string).append(string2);
                return ValueString.get(stringBuilder.toString());
            }
            case 1: {
                if (value == ValueNull.INSTANCE || value2 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return value.add(value2);
            }
            case 2: {
                if (value == ValueNull.INSTANCE || value2 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return value.subtract(value2);
            }
            case 3: {
                if (value == ValueNull.INSTANCE || value2 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return value.multiply(value2);
            }
            case 4: {
                if (value == ValueNull.INSTANCE || value2 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return value.divide(value2);
            }
        }
        throw DbException.throwInternalError("type=" + this.opType);
    }

    public void mapColumns(ColumnResolver columnResolver, int n) {
        this.left.mapColumns(columnResolver, n);
        if (this.right != null) {
            this.right.mapColumns(columnResolver, n);
        }
    }

    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        switch (this.opType) {
            case 5: {
                this.dataType = this.left.getType();
                if (this.dataType != -1) break;
                this.dataType = 6;
                break;
            }
            case 0: {
                this.right = this.right.optimize(session);
                this.dataType = 13;
                if (!this.left.isConstant() || !this.right.isConstant()) break;
                return ValueExpression.get(this.getValue(session));
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.right = this.right.optimize(session);
                int n = this.left.getType();
                int n2 = this.right.getType();
                if (n == 0 && n2 == 0 || n == -1 && n2 == -1) {
                    this.dataType = 6;
                    break;
                }
                if (n == 10 || n == 11) {
                    if (n2 == 4 && (this.opType == 1 || this.opType == 2)) {
                        Function function = Function.getFunction(session.getDatabase(), "DATEADD");
                        function.setParameter(0, ValueExpression.get(ValueString.get("DAY")));
                        if (this.opType == 2) {
                            this.right = new Operation(5, this.right, null);
                            this.right = this.right.optimize(session);
                        }
                        function.setParameter(1, this.right);
                        function.setParameter(2, this.left);
                        function.doneWithParameters();
                        return function.optimize(session);
                    }
                    if (this.opType != 2 || n != 10 && n != 11) break;
                    Function function = Function.getFunction(session.getDatabase(), "DATEDIFF");
                    function.setParameter(0, ValueExpression.get(ValueString.get("DAY")));
                    function.setParameter(1, this.right);
                    function.setParameter(2, this.left);
                    function.doneWithParameters();
                    return function.optimize(session);
                }
                this.dataType = Value.getHigherOrder(n, n2);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.opType);
            }
        }
        if (this.left.isConstant() && (this.right == null || this.right.isConstant())) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        if (this.right != null) {
            this.right.setEvaluatable(tableFilter, bl);
        }
    }

    public int getType() {
        return this.dataType;
    }

    public long getPrecision() {
        if (this.right != null) {
            switch (this.opType) {
                case 0: {
                    return this.left.getPrecision() + this.right.getPrecision();
                }
            }
            return Math.max(this.left.getPrecision(), this.right.getPrecision());
        }
        return this.left.getPrecision();
    }

    public int getDisplaySize() {
        if (this.right != null) {
            switch (this.opType) {
                case 0: {
                    return MathUtils.convertLongToInt((long)this.left.getDisplaySize() + (long)this.right.getDisplaySize());
                }
            }
            return Math.max(this.left.getDisplaySize(), this.right.getDisplaySize());
        }
        return this.left.getDisplaySize();
    }

    public int getScale() {
        if (this.right != null) {
            return Math.max(this.left.getScale(), this.right.getScale());
        }
        return this.left.getScale();
    }

    public void updateAggregate(Session session) {
        this.left.updateAggregate(session);
        if (this.right != null) {
            this.right.updateAggregate(session);
        }
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && (this.right == null || this.right.isEverything(expressionVisitor));
    }

    public int getCost() {
        return this.left.getCost() + 1 + (this.right == null ? 0 : this.right.getCost());
    }
}

