/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import org.h2.util.MathUtils;
import org.h2.util.StatementBuilder;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueArray
extends Value {
    private final Value[] values;
    private int hash;

    private ValueArray(Value[] valueArray) {
        this.values = valueArray;
    }

    public static ValueArray get(Value[] valueArray) {
        return new ValueArray(valueArray);
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int n = 1;
        for (Value value : this.values) {
            n = n * 31 + value.hashCode();
        }
        this.hash = n;
        return n;
    }

    public Value[] getList() {
        return this.values;
    }

    public int getType() {
        return 17;
    }

    public long getPrecision() {
        return 0L;
    }

    public String getString() {
        StatementBuilder statementBuilder = new StatementBuilder("(");
        for (Value value : this.values) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(value.getString());
        }
        return statementBuilder.append(')').toString();
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueArray valueArray = (ValueArray)value;
        if (this.values == valueArray.values) {
            return 0;
        }
        int n = this.values.length;
        int n2 = valueArray.values.length;
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            Value value2 = this.values[i];
            Value value3 = valueArray.values[i];
            int n4 = value2.compareTo(value3, compareMode);
            if (n4 == 0) continue;
            return n4;
        }
        return n > n2 ? 1 : (n == n2 ? 0 : -1);
    }

    public Object getObject() {
        Object[] objectArray = new Object[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            objectArray[i] = this.values[i].getObject();
        }
        return objectArray;
    }

    public void set(PreparedStatement preparedStatement, int n) {
        throw this.throwUnsupportedExceptionForType();
    }

    public String getSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("(");
        for (Value value : this.values) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(value.getSQL());
        }
        return statementBuilder.append(')').toString();
    }

    public String getTraceSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("(");
        for (Value value : this.values) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(value.getTraceSQL());
        }
        return statementBuilder.append(')').toString();
    }

    public int getDisplaySize() {
        long l = 0L;
        for (Value value : this.values) {
            l += (long)value.getDisplaySize();
        }
        return MathUtils.convertLongToInt(l);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ValueArray)) {
            return false;
        }
        ValueArray valueArray = (ValueArray)object;
        if (this.values == valueArray.values) {
            return true;
        }
        if (this.values.length != valueArray.values.length) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i].equals(valueArray.values[i])) continue;
            return false;
        }
        return true;
    }

    public int getMemory() {
        int n = 0;
        for (Value value : this.values) {
            n += value.getMemory();
        }
        return n;
    }
}

