/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.api.repository2.unified;

import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.pentaho.platform.api.locale.IPentahoLocale;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAce;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.repository2.unified.RepositoryFileTree;
import org.pentaho.platform.api.repository2.unified.RepositoryRequest;
import org.pentaho.platform.api.repository2.unified.VersionSummary;

public interface IUnifiedRepository {
    public static final String SYSTEM_FOLDER = "system_folder";

    public RepositoryFile getFile(String var1);

    @Deprecated
    public RepositoryFileTree getTree(String var1, int var2, String var3, boolean var4);

    public RepositoryFileTree getTree(RepositoryRequest var1);

    public RepositoryFile getFileAtVersion(Serializable var1, Serializable var2);

    public RepositoryFile getFileById(Serializable var1);

    public RepositoryFile getFile(String var1, boolean var2);

    public RepositoryFile getFileById(Serializable var1, boolean var2);

    public RepositoryFile getFile(String var1, IPentahoLocale var2);

    public RepositoryFile getFileById(Serializable var1, IPentahoLocale var2);

    public RepositoryFile getFile(String var1, boolean var2, IPentahoLocale var3);

    public RepositoryFile getFileById(Serializable var1, boolean var2, IPentahoLocale var3);

    public <T extends IRepositoryFileData> T getDataForRead(Serializable var1, Class<T> var2);

    public <T extends IRepositoryFileData> T getDataAtVersionForRead(Serializable var1, Serializable var2, Class<T> var3);

    public <T extends IRepositoryFileData> T getDataForExecute(Serializable var1, Class<T> var2);

    public <T extends IRepositoryFileData> T getDataAtVersionForExecute(Serializable var1, Serializable var2, Class<T> var3);

    public <T extends IRepositoryFileData> List<T> getDataForReadInBatch(List<RepositoryFile> var1, Class<T> var2);

    public <T extends IRepositoryFileData> List<T> getDataForExecuteInBatch(List<RepositoryFile> var1, Class<T> var2);

    public RepositoryFile createFile(Serializable var1, RepositoryFile var2, IRepositoryFileData var3, String var4);

    public RepositoryFile createFile(Serializable var1, RepositoryFile var2, IRepositoryFileData var3, RepositoryFileAcl var4, String var5);

    public RepositoryFile createFolder(Serializable var1, RepositoryFile var2, String var3);

    public RepositoryFile createFolder(Serializable var1, RepositoryFile var2, RepositoryFileAcl var3, String var4);

    public RepositoryFile updateFolder(RepositoryFile var1, String var2);

    @Deprecated
    public List<RepositoryFile> getChildren(Serializable var1);

    @Deprecated
    public List<RepositoryFile> getChildren(Serializable var1, String var2);

    @Deprecated
    public List<RepositoryFile> getChildren(Serializable var1, String var2, Boolean var3);

    public List<RepositoryFile> getChildren(RepositoryRequest var1);

    public RepositoryFile updateFile(RepositoryFile var1, IRepositoryFileData var2, String var3);

    public void deleteFile(Serializable var1, boolean var2, String var3);

    public void deleteFile(Serializable var1, String var2);

    public void moveFile(Serializable var1, String var2, String var3);

    public void copyFile(Serializable var1, String var2, String var3);

    public void undeleteFile(Serializable var1, String var2);

    public List<RepositoryFile> getDeletedFiles(String var1);

    public List<RepositoryFile> getDeletedFiles(String var1, String var2);

    public List<RepositoryFile> getDeletedFiles();

    default public List<RepositoryFile> getAllDeletedFiles() {
        return this.getDeletedFiles();
    }

    public boolean canUnlockFile(Serializable var1);

    public void lockFile(Serializable var1, String var2);

    public void unlockFile(Serializable var1);

    public RepositoryFileAcl getAcl(Serializable var1);

    public RepositoryFileAcl updateAcl(RepositoryFileAcl var1);

    public boolean hasAccess(String var1, EnumSet<RepositoryFilePermission> var2);

    public List<RepositoryFileAce> getEffectiveAces(Serializable var1);

    public List<RepositoryFileAce> getEffectiveAces(Serializable var1, boolean var2);

    public VersionSummary getVersionSummary(Serializable var1, Serializable var2);

    public List<VersionSummary> getVersionSummaryInBatch(List<RepositoryFile> var1);

    public List<VersionSummary> getVersionSummaries(Serializable var1);

    public void deleteFileAtVersion(Serializable var1, Serializable var2);

    public void restoreFileAtVersion(Serializable var1, Serializable var2, String var3);

    public List<RepositoryFile> getReferrers(Serializable var1);

    public void setFileMetadata(Serializable var1, Map<String, Serializable> var2);

    public Map<String, Serializable> getFileMetadata(Serializable var1);

    public List<Character> getReservedChars();

    public List<Locale> getAvailableLocalesForFileById(Serializable var1);

    public List<Locale> getAvailableLocalesForFileByPath(String var1);

    public List<Locale> getAvailableLocalesForFile(RepositoryFile var1);

    public Properties getLocalePropertiesForFileById(Serializable var1, String var2);

    public Properties getLocalePropertiesForFileByPath(String var1, String var2);

    public Properties getLocalePropertiesForFile(RepositoryFile var1, String var2);

    public void setLocalePropertiesForFileById(Serializable var1, String var2, Properties var3);

    public void setLocalePropertiesForFileByPath(String var1, String var2, Properties var3);

    public void setLocalePropertiesForFile(RepositoryFile var1, String var2, Properties var3);

    public void deleteLocalePropertiesForFile(RepositoryFile var1, String var2);
}

