/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.fileio;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.engine.services.outputhandler.BaseOutputHandler;
import org.pentaho.platform.repository2.ClientRepositoryPaths;
import org.pentaho.platform.repository2.unified.fileio.RepositoryFileContentItem;
import org.pentaho.platform.util.web.MimeHelper;

public class RepositoryContentOutputHandler
extends BaseOutputHandler {
    public IContentItem getFileOutputContentItem() {
        String filePath = this.getSolutionPath();
        if (StringUtils.isEmpty((String)filePath)) {
            filePath = this.getContentRef();
        }
        if (filePath.startsWith("~/") || filePath.startsWith("~\\") || filePath.equals("~")) {
            filePath = ClientRepositoryPaths.getUserHomeFolderPath(this.getSession().getName()) + "/";
            filePath = filePath + (this.getSolutionPath().length() > 1 ? this.getSolutionPath().substring(2) : this.getSolutionPath().substring(1));
        }
        filePath = this.replaceIllegalChars(filePath);
        RepositoryFileContentItem contentItem = null;
        String requestedFileExtension = MimeHelper.getExtension((String)this.getMimeType());
        if (requestedFileExtension == null) {
            contentItem = new RepositoryFileContentItem(filePath);
        } else {
            String tempFilePath = FilenameUtils.getFullPathNoEndSeparator((String)filePath) + "/" + FilenameUtils.getBaseName((String)filePath) + requestedFileExtension;
            contentItem = new RepositoryFileContentItem(tempFilePath);
        }
        return contentItem;
    }

    protected String replaceIllegalChars(String inStr) {
        String outStr = inStr.replaceAll("'", "");
        return outStr;
    }
}

