/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.lifecycle;

import java.io.IOException;
import java.util.ArrayList;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.security.AccessControlException;
import org.apache.jackrabbit.api.JackrabbitWorkspace;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.pentaho.platform.api.engine.IPentahoObjectFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.api.engine.security.userroledao.IUserRoleDao;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.api.mt.ITenantManager;
import org.pentaho.platform.api.util.IPasswordService;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.StandaloneSession;
import org.pentaho.platform.repository2.unified.IRepositoryFileAclDao;
import org.pentaho.platform.repository2.unified.IRepositoryFileDao;
import org.pentaho.platform.repository2.unified.ServerRepositoryPaths;
import org.pentaho.platform.repository2.unified.jcr.IPathConversionHelper;
import org.pentaho.platform.repository2.unified.jcr.JcrTenantUtils;
import org.pentaho.platform.repository2.unified.jcr.PentahoJcrConstants;
import org.pentaho.platform.repository2.unified.lifecycle.AbstractBackingRepositoryLifecycleManager;
import org.springframework.extensions.jcr.JcrCallback;
import org.springframework.extensions.jcr.JcrTemplate;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

public class DefaultBackingRepositoryLifecycleManager
extends AbstractBackingRepositoryLifecycleManager {
    IUserRoleDao userRoleDao;
    ITenantManager tenantManager;
    protected String repositoryAdminUsername;
    protected String tenantAdminRoleName;
    protected String systemTenantAdminUserName;
    protected String systemTenantAdminPassword;
    protected String tenantAuthenticatedRoleName;
    protected String tenantAnonymousRoleName;
    protected IRepositoryFileDao repositoryFileDao;
    protected IRepositoryFileAclDao repositoryFileAclDao;
    private IPasswordService passwordService;

    public DefaultBackingRepositoryLifecycleManager(IRepositoryFileDao contentDao, IRepositoryFileAclDao repositoryFileAclDao, TransactionTemplate txnTemplate, String repositoryAdminUsername, String systemTenantAdminUserName, String systemTenantAdminPassword, String tenantAdminRoleName, String tenantAuthenticatedRoleName, String tenantAnonymousRoleName, IPasswordService passwordService, JcrTemplate adminJcrTemplate, IPathConversionHelper pathConversionHelper) {
        super(txnTemplate, adminJcrTemplate, pathConversionHelper);
        Assert.notNull((Object)contentDao);
        Assert.notNull((Object)repositoryFileAclDao);
        Assert.hasText((String)repositoryAdminUsername);
        Assert.hasText((String)tenantAuthenticatedRoleName);
        this.repositoryFileDao = contentDao;
        this.repositoryFileAclDao = repositoryFileAclDao;
        this.repositoryAdminUsername = repositoryAdminUsername;
        this.tenantAuthenticatedRoleName = tenantAuthenticatedRoleName;
        this.tenantAdminRoleName = tenantAdminRoleName;
        this.systemTenantAdminUserName = systemTenantAdminUserName;
        this.tenantAnonymousRoleName = tenantAnonymousRoleName;
        this.systemTenantAdminPassword = systemTenantAdminPassword;
        this.passwordService = passwordService;
    }

    @Override
    protected void initTransactionTemplate() {
        this.txnTemplate.setPropagationBehavior(3);
    }

    public synchronized void newTenant(ITenant tenant) {
    }

    public synchronized void newUser(ITenant tenant, String username) {
        if (this.getTenantManager().getUserHomeFolder(tenant, username) == null) {
            this.getTenantManager().createUserHomeFolder(tenant, username);
        }
    }

    public void newTenant() {
        this.newTenant(JcrTenantUtils.getTenant());
    }

    public void newUser() {
    }

    public synchronized void shutdown() {
    }

    public synchronized void startup() {
        ITenant defaultTenant = null;
        this.loginAsRepositoryAdmin();
        this.createCustomPrivilege();
        ITenantManager tenantMgr = this.getTenantManager();
        ITenant systemTenant = tenantMgr.createTenant(null, ServerRepositoryPaths.getPentahoRootFolderName(), this.tenantAdminRoleName, this.tenantAuthenticatedRoleName, this.tenantAnonymousRoleName);
        if (systemTenant != null) {
            try {
                this.userRoleDao.createUser(systemTenant, this.systemTenantAdminUserName, this.passwordService.decrypt(this.systemTenantAdminPassword), "System Tenant User", new String[]{this.tenantAdminRoleName, this.tenantAuthenticatedRoleName});
                defaultTenant = tenantMgr.getTenant(JcrTenantUtils.getDefaultTenant().getId());
                if (defaultTenant == null) {
                    defaultTenant = tenantMgr.createTenant(systemTenant, "tenant0", this.tenantAdminRoleName, this.tenantAuthenticatedRoleName, this.tenantAnonymousRoleName);
                }
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    public ITenantManager getTenantManager() {
        try {
            IPentahoObjectFactory objectFactory = PentahoSystem.getObjectFactory();
            IPentahoSession pentahoSession = PentahoSessionHolder.getSession();
            return null != this.tenantManager ? this.tenantManager : (ITenantManager)objectFactory.get(ITenantManager.class, "tenantMgrProxy", pentahoSession);
        }
        catch (ObjectFactoryException e) {
            return null;
        }
    }

    private void createCustomPrivilege() {
        this.txnTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                DefaultBackingRepositoryLifecycleManager.this.adminJcrTemplate.execute(new JcrCallback(){

                    public Object doInJcr(Session session) throws IOException, RepositoryException {
                        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
                        Workspace workspace = session.getWorkspace();
                        PrivilegeManager privilegeManager = ((JackrabbitWorkspace)workspace).getPrivilegeManager();
                        try {
                            privilegeManager.getPrivilege(pentahoJcrConstants.getPHO_ACLMANAGEMENT_PRIVILEGE());
                        }
                        catch (AccessControlException ace) {
                            privilegeManager.registerPrivilege(pentahoJcrConstants.getPHO_ACLMANAGEMENT_PRIVILEGE(), false, new String[0]);
                        }
                        session.save();
                        return null;
                    }
                });
            }
        });
    }

    public void setTenantManager(ITenantManager tenantManager) {
        assert (null != tenantManager);
        this.tenantManager = tenantManager;
    }

    public IUserRoleDao getUserRoleDao() {
        return this.userRoleDao;
    }

    public void setUserRoleDao(IUserRoleDao userRoleDao) {
        this.userRoleDao = userRoleDao;
    }

    protected void loginAsRepositoryAdmin() {
        StandaloneSession pentahoSession = new StandaloneSession(this.repositoryAdminUsername);
        pentahoSession.setAuthenticated(this.repositoryAdminUsername);
        ArrayList repositoryAdminAuthorities = new ArrayList();
        String password = "ignored";
        User repositoryAdminUserDetails = new User(this.repositoryAdminUsername, "ignored", true, true, true, true, repositoryAdminAuthorities);
        UsernamePasswordAuthenticationToken repositoryAdminAuthentication = new UsernamePasswordAuthenticationToken((Object)repositoryAdminUserDetails, (Object)"ignored", repositoryAdminAuthorities);
        PentahoSessionHolder.setSession((IPentahoSession)pentahoSession);
        SecurityContextHolder.getContext().setAuthentication((Authentication)repositoryAdminAuthentication);
    }
}

