/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.ReplStateLogWork;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.ReplLogger;
import org.apache.hadoop.hive.ql.plan.AlterTableDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.ImportTableDesc;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class ReplUtils {
    public static final String REPL_CHECKPOINT_KEY = "hive.repl.ckpt.key";

    public static Map<Integer, List<ExprNodeGenericFuncDesc>> genPartSpecs(Table table, List<Map<String, String>> partitions) throws SemanticException {
        HashMap<Integer, List<ExprNodeGenericFuncDesc>> partSpecs = new HashMap<Integer, List<ExprNodeGenericFuncDesc>>();
        int partPrefixLength = 0;
        if (partitions.size() > 0) {
            partPrefixLength = partitions.get(0).size();
        }
        ArrayList<ExprNodeGenericFuncDesc> partitionDesc = new ArrayList<ExprNodeGenericFuncDesc>();
        for (Map<String, String> ptn : partitions) {
            ExprNodeGenericFuncDesc expr = null;
            for (Map.Entry<String, String> kvp : ptn.entrySet()) {
                String key = kvp.getKey();
                String val = kvp.getValue();
                String type = table.getPartColByName(key).getType();
                PrimitiveTypeInfo pti = TypeInfoFactory.getPrimitiveTypeInfo((String)type);
                ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)pti, key, null, true);
                ExprNodeGenericFuncDesc op = DDLSemanticAnalyzer.makeBinaryPredicate("=", column, new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, val));
                expr = expr == null ? op : DDLSemanticAnalyzer.makeBinaryPredicate("and", expr, op);
            }
            if (expr == null) continue;
            partitionDesc.add(expr);
        }
        if (partitionDesc.size() > 0) {
            partSpecs.put(partPrefixLength, partitionDesc);
        }
        return partSpecs;
    }

    public static Task<?> getTableReplLogTask(ImportTableDesc tableDesc, ReplLogger replLogger, HiveConf conf) throws SemanticException {
        ReplStateLogWork replLogWork = new ReplStateLogWork(replLogger, tableDesc.getTableName(), tableDesc.tableType());
        return TaskFactory.get(replLogWork, conf);
    }

    public static Task<?> getTableCheckpointTask(ImportTableDesc tableDesc, HashMap<String, String> partSpec, String dumpRoot, HiveConf conf) throws SemanticException {
        HashMap<String, String> mapProp = new HashMap<String, String>();
        mapProp.put(REPL_CHECKPOINT_KEY, dumpRoot);
        AlterTableDesc alterTblDesc = new AlterTableDesc(AlterTableDesc.AlterTableTypes.ADDPROPS);
        alterTblDesc.setProps(mapProp);
        alterTblDesc.setOldName(StatsUtils.getFullyQualifiedTableName(tableDesc.getDatabaseName(), tableDesc.getTableName()));
        if (partSpec != null) {
            alterTblDesc.setPartSpec(partSpec);
        }
        return TaskFactory.get(new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), alterTblDesc), conf);
    }

    public static boolean replCkptStatus(String dbName, Map<String, String> props, String dumpRoot) throws InvalidOperationException {
        if (props != null && props.containsKey(REPL_CHECKPOINT_KEY) && !props.get(REPL_CHECKPOINT_KEY).isEmpty()) {
            if (props.get(REPL_CHECKPOINT_KEY).equals(dumpRoot)) {
                return true;
            }
            throw new InvalidOperationException("REPL LOAD with Dump: " + dumpRoot + " is not allowed as the target DB: " + dbName + " is already bootstrap loaded by another Dump " + props.get(REPL_CHECKPOINT_KEY));
        }
        return false;
    }

    public static enum ReplLoadOpType {
        LOAD_NEW,
        LOAD_SKIP,
        LOAD_REPLACE;

    }
}

