/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import com.google.common.base.Preconditions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;

public class VectorPTFEvaluatorLongFirstValue
extends VectorPTFEvaluatorBase {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorPTFEvaluatorLongFirstValue.class.getName();
    private static final Log LOG = LogFactory.getLog((String)CLASS_NAME);
    protected boolean haveFirstValue;
    protected boolean isGroupResultNull;
    protected long firstValue;

    public VectorPTFEvaluatorLongFirstValue(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch, boolean isLastGroupBatch) throws HiveException {
        this.evaluateInputExpr(batch);
        Preconditions.checkState((!batch.selectedInUse ? 1 : 0) != 0);
        if (!this.haveFirstValue) {
            int size = batch.size;
            if (size == 0) {
                return;
            }
            LongColumnVector longColVector = (LongColumnVector)batch.cols[this.inputColumnNum];
            if (longColVector.isRepeating) {
                if (longColVector.noNulls || !longColVector.isNull[0]) {
                    this.firstValue = longColVector.vector[0];
                    this.isGroupResultNull = false;
                }
            } else if (longColVector.noNulls) {
                this.firstValue = longColVector.vector[0];
                this.isGroupResultNull = false;
            } else if (!longColVector.isNull[0]) {
                this.firstValue = longColVector.vector[0];
                this.isGroupResultNull = false;
            }
            this.haveFirstValue = true;
        }
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
        outputColVector.isRepeating = true;
        if (this.isGroupResultNull) {
            outputColVector.noNulls = false;
            outputColVector.isNull[0] = true;
        } else {
            outputColVector.isNull[0] = false;
            outputColVector.vector[0] = this.firstValue;
        }
    }

    @Override
    public boolean streamsResult() {
        return true;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.LONG;
    }

    @Override
    public void resetEvaluator() {
        this.haveFirstValue = false;
        this.isGroupResultNull = true;
        this.firstValue = 0L;
    }
}

