/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.reducesink;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.TerminalOperator;
import org.apache.hadoop.hive.ql.exec.TopNHash;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.VectorSerializeRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContextRegion;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationOperator;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.ql.plan.VectorReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.VectorReduceSinkInfo;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableSerializeWrite;
import org.apache.hadoop.hive.serde2.lazybinary.fast.LazyBinarySerializeWrite;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapred.OutputCollector;

public abstract class VectorReduceSinkCommonOperator
extends TerminalOperator<ReduceSinkDesc>
implements Serializable,
TopNHash.BinaryCollector,
VectorizationOperator,
VectorizationContextRegion {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorReduceSinkCommonOperator.class.getName();
    private static final Log LOG = LogFactory.getLog((String)CLASS_NAME);
    protected VectorReduceSinkInfo vectorReduceSinkInfo;
    protected VectorizationContext vContext;
    protected VectorReduceSinkDesc vectorDesc;
    protected boolean isEmptyKey;
    protected int[] reduceSinkKeyColumnMap;
    protected TypeInfo[] reduceSinkKeyTypeInfos;
    protected VectorExpression[] reduceSinkKeyExpressions;
    protected boolean isEmptyValue;
    protected int[] reduceSinkValueColumnMap;
    protected TypeInfo[] reduceSinkValueTypeInfos;
    protected VectorExpression[] reduceSinkValueExpressions;
    protected transient boolean reduceSkipTag;
    protected transient byte reduceTagByte;
    protected transient BinarySortableSerializeWrite keyBinarySortableSerializeWrite;
    protected transient LazyBinarySerializeWrite valueLazyBinarySerializeWrite;
    protected transient VectorSerializeRow<LazyBinarySerializeWrite> valueVectorSerializeRow;
    protected transient ByteStream.Output valueOutput;
    protected transient HiveKey keyWritable;
    protected transient BytesWritable valueBytesWritable;
    protected transient TopNHash reducerHash;
    private transient OutputCollector out;
    private transient long cntr = 1L;
    private transient long logEveryNRows = 0L;
    protected transient String taskName;
    protected transient long batchCounter;

    protected VectorReduceSinkCommonOperator() {
    }

    public VectorReduceSinkCommonOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorReduceSinkCommonOperator(CompilationOpContext ctx, OperatorDesc conf, VectorizationContext vContext, VectorDesc vectorDesc) throws HiveException {
        this(ctx);
        ReduceSinkDesc desc = (ReduceSinkDesc)conf;
        this.conf = desc;
        this.vContext = vContext;
        this.vectorDesc = (VectorReduceSinkDesc)vectorDesc;
        this.vectorReduceSinkInfo = this.vectorDesc.getVectorReduceSinkInfo();
        this.isEmptyKey = this.vectorDesc.getIsEmptyKey();
        if (!this.isEmptyKey) {
            this.reduceSinkKeyColumnMap = this.vectorReduceSinkInfo.getReduceSinkKeyColumnMap();
            this.reduceSinkKeyTypeInfos = this.vectorReduceSinkInfo.getReduceSinkKeyTypeInfos();
            this.reduceSinkKeyExpressions = this.vectorReduceSinkInfo.getReduceSinkKeyExpressions();
        }
        this.isEmptyValue = this.vectorDesc.getIsEmptyValue();
        if (!this.isEmptyValue) {
            this.reduceSinkValueColumnMap = this.vectorReduceSinkInfo.getReduceSinkValueColumnMap();
            this.reduceSinkValueTypeInfos = this.vectorReduceSinkInfo.getReduceSinkValueTypeInfos();
            this.reduceSinkValueExpressions = this.vectorReduceSinkInfo.getReduceSinkValueExpressions();
        }
    }

    private boolean[] getColumnSortOrder(Properties properties, int columnCount) {
        String columnSortOrder = properties.getProperty("serialization.sort.order");
        boolean[] columnSortOrderIsDesc = new boolean[columnCount];
        if (columnSortOrder == null) {
            Arrays.fill(columnSortOrderIsDesc, false);
        } else {
            for (int i = 0; i < columnSortOrderIsDesc.length; ++i) {
                columnSortOrderIsDesc[i] = columnSortOrder.charAt(i) == '-';
            }
        }
        return columnSortOrderIsDesc;
    }

    private byte[] getColumnNullMarker(Properties properties, int columnCount, boolean[] columnSortOrder) {
        String columnNullOrder = properties.getProperty("serialization.sort.order.null");
        byte[] columnNullMarker = new byte[columnCount];
        for (int i = 0; i < columnNullMarker.length; ++i) {
            if (columnSortOrder[i]) {
                if (columnNullOrder != null && columnNullOrder.charAt(i) == 'a') {
                    columnNullMarker[i] = 1;
                    continue;
                }
                columnNullMarker[i] = 0;
                continue;
            }
            columnNullMarker[i] = columnNullOrder != null && columnNullOrder.charAt(i) == 'z' ? (byte)1 : 0;
        }
        return columnNullMarker;
    }

    private byte[] getColumnNotNullMarker(Properties properties, int columnCount, boolean[] columnSortOrder) {
        String columnNullOrder = properties.getProperty("serialization.sort.order.null");
        byte[] columnNotNullMarker = new byte[columnCount];
        for (int i = 0; i < columnNotNullMarker.length; ++i) {
            if (columnSortOrder[i]) {
                if (columnNullOrder != null && columnNullOrder.charAt(i) == 'a') {
                    columnNotNullMarker[i] = 0;
                    continue;
                }
                columnNotNullMarker[i] = 1;
                continue;
            }
            columnNotNullMarker[i] = columnNullOrder != null && columnNullOrder.charAt(i) == 'z' ? (byte)0 : 1;
        }
        return columnNotNullMarker;
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        String context;
        super.initializeOp(hconf);
        VectorExpression.doTransientInit(this.reduceSinkKeyExpressions);
        VectorExpression.doTransientInit(this.reduceSinkValueExpressions);
        if (LOG.isDebugEnabled()) {
            BaseWork work = Utilities.getMapWork(hconf);
            if (work == null) {
                work = Utilities.getReduceWork(hconf);
            }
            this.taskName = work.getName();
        }
        if ((context = hconf.get("__hive.context.name", "")) != null && !context.isEmpty()) {
            context = "_" + context.replace(" ", "_");
        }
        this.reduceSkipTag = ((ReduceSinkDesc)this.conf).getSkipTag();
        this.reduceTagByte = (byte)((ReduceSinkDesc)this.conf).getTag();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Using tag = " + this.reduceTagByte));
        }
        if (!this.isEmptyKey) {
            TableDesc keyTableDesc = ((ReduceSinkDesc)this.conf).getKeySerializeInfo();
            boolean[] columnSortOrder = this.getColumnSortOrder(keyTableDesc.getProperties(), this.reduceSinkKeyColumnMap.length);
            byte[] columnNullMarker = this.getColumnNullMarker(keyTableDesc.getProperties(), this.reduceSinkKeyColumnMap.length, columnSortOrder);
            byte[] columnNotNullMarker = this.getColumnNotNullMarker(keyTableDesc.getProperties(), this.reduceSinkKeyColumnMap.length, columnSortOrder);
            this.keyBinarySortableSerializeWrite = new BinarySortableSerializeWrite(columnSortOrder, columnNullMarker, columnNotNullMarker);
        }
        if (!this.isEmptyValue) {
            this.valueLazyBinarySerializeWrite = new LazyBinarySerializeWrite(this.reduceSinkValueColumnMap.length);
            this.valueVectorSerializeRow = new VectorSerializeRow<LazyBinarySerializeWrite>(this.valueLazyBinarySerializeWrite);
            this.valueVectorSerializeRow.init(this.reduceSinkValueTypeInfos, this.reduceSinkValueColumnMap);
            this.valueOutput = new ByteStream.Output();
            this.valueVectorSerializeRow.setOutput(this.valueOutput);
        }
        this.keyWritable = new HiveKey();
        this.valueBytesWritable = new BytesWritable();
        int limit = ((ReduceSinkDesc)this.conf).getTopN();
        float memUsage = ((ReduceSinkDesc)this.conf).getTopNMemoryUsage();
        if (limit >= 0 && memUsage > 0.0f) {
            this.reducerHash = new TopNHash();
            this.reducerHash.initialize(limit, memUsage, ((ReduceSinkDesc)this.conf).isMapGroupBy(), this, this.conf, hconf);
        }
        this.batchCounter = 0L;
    }

    protected void initializeEmptyKey(int tag) {
        if (tag == -1 || this.reduceSkipTag) {
            this.keyWritable.setSize(0);
        } else {
            this.keyWritable.setSize(1);
            this.keyWritable.get()[0] = this.reduceTagByte;
        }
        this.keyWritable.setDistKeyLength(0);
        this.keyWritable.setHashCode(0);
    }

    @Override
    public void collect(byte[] key, byte[] value, int hash) throws IOException {
        HiveKey keyWritable = new HiveKey(key, hash);
        BytesWritable valueWritable = new BytesWritable(value);
        this.doCollect(keyWritable, valueWritable);
    }

    protected void collect(HiveKey keyWritable, BytesWritable valueWritable) throws HiveException, IOException {
        if (this.reducerHash != null) {
            int firstIndex = this.reducerHash.tryStoreKey(keyWritable, false);
            if (firstIndex == -2) {
                return;
            }
            if (firstIndex == -1) {
                this.doCollect(keyWritable, valueWritable);
            } else {
                Preconditions.checkState((firstIndex >= 0 ? 1 : 0) != 0);
                this.reducerHash.storeValue(firstIndex, keyWritable.hashCode(), valueWritable, false);
            }
        } else {
            this.doCollect(keyWritable, valueWritable);
        }
    }

    private void doCollect(HiveKey keyWritable, BytesWritable valueWritable) throws IOException {
        if (null != this.out) {
            ++this.numRows;
            if (LOG.isInfoEnabled() && this.numRows == this.cntr) {
                long l = this.cntr = this.logEveryNRows == 0L ? this.cntr * 10L : this.numRows + this.logEveryNRows;
                if (this.cntr < 0L || this.numRows < 0L) {
                    this.cntr = 0L;
                    this.numRows = 1L;
                }
                LOG.info((Object)(this.toString() + ": records written - " + this.numRows));
            }
            this.out.collect((Object)keyWritable, (Object)valueWritable);
        }
    }

    @Override
    protected void closeOp(boolean abort) throws HiveException {
        if (!abort && this.reducerHash != null) {
            this.reducerHash.flush();
        }
        this.runTimeNumRows = this.numRows;
        super.closeOp(abort);
        this.out = null;
        this.reducerHash = null;
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)(this.toString() + ": records written - " + this.numRows));
        }
        this.runTimeNumRows = this.numRows;
    }

    @Override
    public String getName() {
        return VectorReduceSinkCommonOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "RS";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.REDUCESINK;
    }

    @Override
    public VectorizationContext getOutputVectorizationContext() {
        return this.vContext;
    }

    @Override
    public boolean getIsReduceSink() {
        return true;
    }

    @Override
    public String getReduceOutputName() {
        return ((ReduceSinkDesc)this.conf).getOutputName();
    }

    @Override
    public void setOutputCollector(OutputCollector _out) {
        this.out = _out;
    }

    @Override
    public VectorizationContext getInputVectorizationContext() {
        return this.vContext;
    }

    @Override
    public VectorDesc getVectorDesc() {
        return this.vectorDesc;
    }
}

