/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.reducesink;

import com.google.common.base.Preconditions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.reducesink.VectorReduceSinkCommonOperator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;

public class VectorReduceSinkEmptyKeyOperator
extends VectorReduceSinkCommonOperator {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorReduceSinkEmptyKeyOperator.class.getName();
    private static final Log LOG = LogFactory.getLog((String)CLASS_NAME);
    private transient boolean isKeyInitialized;

    protected VectorReduceSinkEmptyKeyOperator() {
    }

    public VectorReduceSinkEmptyKeyOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorReduceSinkEmptyKeyOperator(CompilationOpContext ctx, OperatorDesc conf, VectorizationContext vContext, VectorDesc vectorDesc) throws HiveException {
        super(ctx, conf, vContext, vectorDesc);
        LOG.info((Object)("VectorReduceSinkEmptyKeyOperator constructor vectorReduceSinkInfo " + this.vectorReduceSinkInfo));
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        this.isKeyInitialized = false;
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        try {
            VectorizedRowBatch batch = (VectorizedRowBatch)row;
            ++this.batchCounter;
            if (batch.size == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " batch #" + this.batchCounter + " empty"));
                }
                return;
            }
            if (!this.isKeyInitialized) {
                this.isKeyInitialized = true;
                Preconditions.checkState((boolean)this.isEmptyKey);
                this.initializeEmptyKey(tag);
            }
            if (this.reduceSinkValueExpressions != null) {
                for (VectorExpression ve : this.reduceSinkValueExpressions) {
                    ve.evaluate(batch);
                }
            }
            int size = batch.size;
            if (!this.isEmptyValue) {
                if (batch.selectedInUse) {
                    int[] selected = batch.selected;
                    for (int logical = 0; logical < size; ++logical) {
                        int batchIndex = selected[logical];
                        this.valueLazyBinarySerializeWrite.reset();
                        this.valueVectorSerializeRow.serializeWrite(batch, batchIndex);
                        this.valueBytesWritable.set(this.valueOutput.getData(), 0, this.valueOutput.getLength());
                        this.collect(this.keyWritable, this.valueBytesWritable);
                    }
                } else {
                    for (int batchIndex = 0; batchIndex < size; ++batchIndex) {
                        this.valueLazyBinarySerializeWrite.reset();
                        this.valueVectorSerializeRow.serializeWrite(batch, batchIndex);
                        this.valueBytesWritable.set(this.valueOutput.getData(), 0, this.valueOutput.getLength());
                        this.collect(this.keyWritable, this.valueBytesWritable);
                    }
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    this.collect(this.keyWritable, this.valueBytesWritable);
                }
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }
}

