/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.listbucketingpruner;

import java.util.List;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;

public final class ListBucketingPrunerUtils {
    public static final String HIVE_LIST_BUCKETING_DEFAULT_DIR_NAME = "HIVE_DEFAULT_LIST_BUCKETING_DIR_NAME";
    public static final String HIVE_LIST_BUCKETING_DEFAULT_KEY = "HIVE_DEFAULT_LIST_BUCKETING_KEY";

    public static boolean skipSkewedDirectory(Boolean bool) {
        if (bool == null) {
            return false;
        }
        return bool == false;
    }

    public static Boolean orBoolOperand(Boolean o, Boolean a) {
        if (o == null) {
            if (a == null || !a.booleanValue()) {
                return null;
            }
            return a;
        }
        if (a == null) {
            return null;
        }
        return o != false || a != false;
    }

    public static Boolean andBoolOperand(Boolean o, Boolean a) {
        if (o == null) {
            if (a == null || a.booleanValue()) {
                return null;
            }
            return a;
        }
        if (a == null) {
            return o != false ? null : Boolean.FALSE;
        }
        return o != false && a != false;
    }

    public static Boolean notBoolOperand(Boolean input) {
        if (input == null) {
            return null;
        }
        return input != false ? Boolean.FALSE : Boolean.TRUE;
    }

    static Boolean evaluateExprOnCell(List<String> skewedCols, List<String> cell, ExprNodeDesc pruner, List<List<String>> uniqSkewedValues) throws SemanticException {
        return ListBucketingPrunerUtils.recursiveExpr(pruner, skewedCols, cell, uniqSkewedValues);
    }

    private static Boolean recursiveExpr(ExprNodeDesc node, List<String> skewedCols, List<String> cell, List<List<String>> uniqSkewedValues) throws SemanticException {
        if (ListBucketingPrunerUtils.isUnknownState(node)) {
            return null;
        }
        if (node instanceof ExprNodeGenericFuncDesc) {
            if (((ExprNodeGenericFuncDesc)node).getGenericUDF() instanceof GenericUDFOPEqual) {
                return ListBucketingPrunerUtils.evaluateEqualNd(node, skewedCols, cell, uniqSkewedValues);
            }
            if (FunctionRegistry.isOpAnd(node)) {
                return ListBucketingPrunerUtils.evaluateAndNode(node, skewedCols, cell, uniqSkewedValues);
            }
            if (FunctionRegistry.isOpOr(node)) {
                return ListBucketingPrunerUtils.evaluateOrNode(node, skewedCols, cell, uniqSkewedValues);
            }
            if (FunctionRegistry.isOpNot(node)) {
                return ListBucketingPrunerUtils.evaluateNotNode(node, skewedCols, cell, uniqSkewedValues);
            }
            return null;
        }
        return null;
    }

    private static Boolean evaluateEqualNd(ExprNodeDesc node, List<String> skewedCols, List<String> cell, List<List<String>> uniqSkewedValues) throws SemanticException {
        Boolean result = null;
        List<ExprNodeDesc> children = ((ExprNodeGenericFuncDesc)node).getChildren();
        assert (children != null && children.size() == 2) : "GenericUDFOPEqual should have 2 ExprNodeDesc. Node name : " + node.getName();
        ExprNodeDesc left = children.get(0);
        ExprNodeDesc right = children.get(1);
        assert (left instanceof ExprNodeColumnDesc && right instanceof ExprNodeConstantDesc) : "GenericUDFOPEqual should have 2 children:  the first is ExprNodeColumnDesc and the second is ExprNodeConstantDesc. But this one, the first one is " + left.getName() + " and the second is " + right.getName();
        result = ListBucketingPrunerUtils.startComparisonInEqualNode(skewedCols, cell, uniqSkewedValues, result, left, right);
        return result;
    }

    private static Boolean startComparisonInEqualNode(List<String> skewedCols, List<String> cell, List<List<String>> uniqSkewedValues, Boolean result, ExprNodeDesc left, ExprNodeDesc right) throws SemanticException {
        String columnNameInFilter = ((ExprNodeColumnDesc)left).getColumn();
        String constantValueInFilter = ((ExprNodeConstantDesc)right).getValue().toString();
        assert (skewedCols.contains(columnNameInFilter)) : "List bucketing pruner has a column name " + columnNameInFilter + " which is not found in the partition's skewed column list";
        int index = skewedCols.indexOf(columnNameInFilter);
        assert (index < cell.size()) : "GenericUDFOPEqual has a ExprNodeColumnDesc (" + columnNameInFilter + ") which is " + index + "th" + "skewed column. " + " But it can't find the matching part in cell." + " Because the cell size is " + cell.size();
        String cellValueInPosition = cell.get(index);
        assert (index < uniqSkewedValues.size()) : "GenericUDFOPEqual has a ExprNodeColumnDesc (" + columnNameInFilter + ") which is " + index + "th" + "skewed column. " + " But it can't find the matching part in uniq skewed value list." + " Because the cell size is " + uniqSkewedValues.size();
        List<String> uniqSkewedValuesInPosition = uniqSkewedValues.get(index);
        result = ListBucketingPrunerUtils.coreComparisonInEqualNode(constantValueInFilter, cellValueInPosition, uniqSkewedValuesInPosition);
        return result;
    }

    private static Boolean coreComparisonInEqualNode(String constantValueInFilter, String cellValueInPosition, List<String> uniqSkewedValuesInPosition) {
        Object result = cellValueInPosition.equals(constantValueInFilter) && !cellValueInPosition.equals(HIVE_LIST_BUCKETING_DEFAULT_KEY) ? Boolean.TRUE : (cellValueInPosition.equals(HIVE_LIST_BUCKETING_DEFAULT_KEY) && !uniqSkewedValuesInPosition.contains(constantValueInFilter) ? null : Boolean.FALSE);
        return result;
    }

    private static Boolean evaluateNotNode(ExprNodeDesc node, List<String> skewedCols, List<String> cell, List<List<String>> uniqSkewedValues) throws SemanticException {
        List<ExprNodeDesc> children = ((ExprNodeGenericFuncDesc)node).getChildren();
        if (children == null || children.size() != 1) {
            throw new SemanticException("GenericUDFOPNot should have 1 ExprNodeDesc. Node name : " + node.getName());
        }
        ExprNodeDesc child = children.get(0);
        return ListBucketingPrunerUtils.notBoolOperand(ListBucketingPrunerUtils.recursiveExpr(child, skewedCols, cell, uniqSkewedValues));
    }

    private static Boolean evaluateOrNode(ExprNodeDesc node, List<String> skewedCols, List<String> cell, List<List<String>> uniqSkewedValues) throws SemanticException {
        List<ExprNodeDesc> children = ((ExprNodeGenericFuncDesc)node).getChildren();
        if (children == null || children.size() != 2) {
            throw new SemanticException("GenericUDFOPOr should have 2 ExprNodeDesc. Node name : " + node.getName());
        }
        ExprNodeDesc left = children.get(0);
        ExprNodeDesc right = children.get(1);
        return ListBucketingPrunerUtils.orBoolOperand(ListBucketingPrunerUtils.recursiveExpr(left, skewedCols, cell, uniqSkewedValues), ListBucketingPrunerUtils.recursiveExpr(right, skewedCols, cell, uniqSkewedValues));
    }

    private static Boolean evaluateAndNode(ExprNodeDesc node, List<String> skewedCols, List<String> cell, List<List<String>> uniqSkewedValues) throws SemanticException {
        List<ExprNodeDesc> children = ((ExprNodeGenericFuncDesc)node).getChildren();
        if (children == null || children.size() != 2) {
            throw new SemanticException("GenericUDFOPAnd should have 2 ExprNodeDesc. Node name : " + node.getName());
        }
        ExprNodeDesc left = children.get(0);
        ExprNodeDesc right = children.get(1);
        return ListBucketingPrunerUtils.andBoolOperand(ListBucketingPrunerUtils.recursiveExpr(left, skewedCols, cell, uniqSkewedValues), ListBucketingPrunerUtils.recursiveExpr(right, skewedCols, cell, uniqSkewedValues));
    }

    static boolean isUnknownState(ExprNodeDesc descNd) {
        boolean unknown = false;
        if (descNd == null || descNd instanceof ExprNodeConstantDesc && ((ExprNodeConstantDesc)descNd).getValue() == null) {
            unknown = true;
        }
        return unknown;
    }

    public static boolean isListBucketingPart(Partition part) {
        return part.getSkewedColNames() != null && part.getSkewedColNames().size() > 0 && part.getSkewedColValues() != null && part.getSkewedColValues().size() > 0 && part.getSkewedColValueLocationMaps() != null && part.getSkewedColValueLocationMaps().size() > 0;
    }
}

