/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileWriterImpl;
import org.apache.hadoop.hbase.mapreduce.CellSerialization;
import org.apache.hadoop.hbase.mapreduce.CellSortReducer;
import org.apache.hadoop.hbase.mapreduce.MultiTableHFileOutputFormat;
import org.apache.hadoop.hbase.mapreduce.MutationSerialization;
import org.apache.hadoop.hbase.mapreduce.PutSortReducer;
import org.apache.hadoop.hbase.mapreduce.ResultSerialization;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TextSortReducer;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.MapReduceExtendedCell;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.partition.TotalOrderPartitioner;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class HFileOutputFormat2
extends FileOutputFormat<ImmutableBytesWritable, Cell> {
    private static final Logger LOG = LoggerFactory.getLogger(HFileOutputFormat2.class);
    protected static final byte[] tableSeparator = Bytes.toBytes((String)";");
    static final String COMPRESSION_FAMILIES_CONF_KEY = "hbase.hfileoutputformat.families.compression";
    static final String BLOOM_TYPE_FAMILIES_CONF_KEY = "hbase.hfileoutputformat.families.bloomtype";
    static final String BLOCK_SIZE_FAMILIES_CONF_KEY = "hbase.mapreduce.hfileoutputformat.blocksize";
    static final String DATABLOCK_ENCODING_FAMILIES_CONF_KEY = "hbase.mapreduce.hfileoutputformat.families.datablock.encoding";
    public static final String DATABLOCK_ENCODING_OVERRIDE_CONF_KEY = "hbase.mapreduce.hfileoutputformat.datablock.encoding";
    public static final String LOCALITY_SENSITIVE_CONF_KEY = "hbase.bulkload.locality.sensitive.enabled";
    private static final boolean DEFAULT_LOCALITY_SENSITIVE = true;
    static final String OUTPUT_TABLE_NAME_CONF_KEY = "hbase.mapreduce.hfileoutputformat.table.name";
    static final String MULTI_TABLE_HFILEOUTPUTFORMAT_CONF_KEY = "hbase.mapreduce.use.multi.table.hfileoutputformat";
    public static final String STORAGE_POLICY_PROPERTY = "hbase.hstore.block.storage.policy";
    public static final String STORAGE_POLICY_PROPERTY_CF_PREFIX = "hbase.hstore.block.storage.policy.";
    @VisibleForTesting
    static Function<ColumnFamilyDescriptor, String> compressionDetails = familyDescriptor -> familyDescriptor.getCompressionType().getName();
    @VisibleForTesting
    static Function<ColumnFamilyDescriptor, String> blockSizeDetails = familyDescriptor -> String.valueOf(familyDescriptor.getBlocksize());
    @VisibleForTesting
    static Function<ColumnFamilyDescriptor, String> bloomTypeDetails = familyDescriptor -> {
        String bloomType = familyDescriptor.getBloomFilterType().toString();
        if (bloomType == null) {
            bloomType = ColumnFamilyDescriptorBuilder.DEFAULT_BLOOMFILTER.name();
        }
        return bloomType;
    };
    @VisibleForTesting
    static Function<ColumnFamilyDescriptor, String> dataBlockEncodingDetails = familyDescriptor -> {
        DataBlockEncoding encoding = familyDescriptor.getDataBlockEncoding();
        if (encoding == null) {
            encoding = DataBlockEncoding.NONE;
        }
        return encoding.toString();
    };

    protected static byte[] combineTableNameSuffix(byte[] tableName, byte[] suffix) {
        return Bytes.add((byte[])tableName, (byte[])tableSeparator, (byte[])suffix);
    }

    public RecordWriter<ImmutableBytesWritable, Cell> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        return HFileOutputFormat2.createRecordWriter(context, this.getOutputCommitter(context));
    }

    protected static byte[] getTableNameSuffixedWithFamily(byte[] tableName, byte[] family) {
        return HFileOutputFormat2.combineTableNameSuffix(tableName, family);
    }

    static <V extends Cell> RecordWriter<ImmutableBytesWritable, V> createRecordWriter(final TaskAttemptContext context, OutputCommitter committer) throws IOException {
        final Path outputDir = ((FileOutputCommitter)committer).getWorkPath();
        final Configuration conf = context.getConfiguration();
        final boolean writeMultipleTables = conf.getBoolean(MULTI_TABLE_HFILEOUTPUTFORMAT_CONF_KEY, false);
        final String writeTableNames = conf.get(OUTPUT_TABLE_NAME_CONF_KEY);
        if (writeTableNames == null || writeTableNames.isEmpty()) {
            throw new IllegalArgumentException("Configuration parameter hbase.mapreduce.hfileoutputformat.table.name cannot be empty");
        }
        final FileSystem fs = outputDir.getFileSystem(conf);
        final long maxsize = conf.getLong("hbase.hregion.max.filesize", 0x280000000L);
        String defaultCompressionStr = conf.get("hfile.compression", Compression.Algorithm.NONE.getName());
        final Compression.Algorithm defaultCompression = HFileWriterImpl.compressionByName((String)defaultCompressionStr);
        final boolean compactionExclude = conf.getBoolean("hbase.mapreduce.hfileoutputformat.compaction.exclude", false);
        final Set allTableNames = Arrays.stream(writeTableNames.split(Bytes.toString((byte[])tableSeparator))).collect(Collectors.toSet());
        final Map<byte[], Compression.Algorithm> compressionMap = HFileOutputFormat2.createFamilyCompressionMap(conf);
        final Map<byte[], BloomType> bloomTypeMap = HFileOutputFormat2.createFamilyBloomTypeMap(conf);
        final Map<byte[], Integer> blockSizeMap = HFileOutputFormat2.createFamilyBlockSizeMap(conf);
        String dataBlockEncodingStr = conf.get(DATABLOCK_ENCODING_OVERRIDE_CONF_KEY);
        final Map<byte[], DataBlockEncoding> datablockEncodingMap = HFileOutputFormat2.createFamilyDataBlockEncodingMap(conf);
        final DataBlockEncoding overriddenEncoding = dataBlockEncodingStr != null ? DataBlockEncoding.valueOf((String)dataBlockEncodingStr) : null;
        return new RecordWriter<ImmutableBytesWritable, V>(){
            private final Map<byte[], WriterLength> writers = new TreeMap<byte[], WriterLength>(Bytes.BYTES_COMPARATOR);
            private byte[] previousRow = HConstants.EMPTY_BYTE_ARRAY;
            private final long now = EnvironmentEdgeManager.currentTime();
            private boolean rollRequested = false;

            public void write(ImmutableBytesWritable row, V cell) throws IOException {
                Object kv = cell;
                if (row == null && kv == null) {
                    this.rollWriters(null);
                    return;
                }
                byte[] rowKey = CellUtil.cloneRow(kv);
                int length = PrivateCellUtil.estimatedSerializedSizeOf(kv) - 4;
                byte[] family = CellUtil.cloneFamily(kv);
                byte[] tableNameBytes = null;
                if (writeMultipleTables) {
                    tableNameBytes = MultiTableHFileOutputFormat.getTableName(row.get());
                    if (!allTableNames.contains(Bytes.toString((byte[])(tableNameBytes = TableName.valueOf((byte[])tableNameBytes).getNameWithNamespaceInclAsString().getBytes(Charset.defaultCharset()))))) {
                        throw new IllegalArgumentException("TableName '" + Bytes.toString((byte[])tableNameBytes) + "' not" + " expected");
                    }
                } else {
                    tableNameBytes = Bytes.toBytes((String)writeTableNames);
                }
                String tableName = Bytes.toString((byte[])tableNameBytes);
                Path tableRelPath = this.getTableRelativePath(tableNameBytes);
                byte[] tableAndFamily = HFileOutputFormat2.getTableNameSuffixedWithFamily(tableNameBytes, family);
                WriterLength wl = this.writers.get(tableAndFamily);
                if (wl == null) {
                    Path writerPath = null;
                    writerPath = writeMultipleTables ? new Path(outputDir, new Path(tableRelPath, Bytes.toString((byte[])family))) : new Path(outputDir, Bytes.toString((byte[])family));
                    fs.mkdirs(writerPath);
                    HFileOutputFormat2.configureStoragePolicy(conf, fs, tableAndFamily, writerPath);
                }
                if (wl != null && wl.written + (long)length >= maxsize) {
                    this.rollRequested = true;
                }
                if (this.rollRequested && Bytes.compareTo((byte[])this.previousRow, (byte[])rowKey) != 0) {
                    this.rollWriters(wl);
                }
                if (wl == null || wl.writer == null) {
                    if (conf.getBoolean(HFileOutputFormat2.LOCALITY_SENSITIVE_CONF_KEY, true)) {
                        HRegionLocation loc = null;
                        if (tableName != null) {
                            try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                                 RegionLocator locator = connection.getRegionLocator(TableName.valueOf((String)tableName));){
                                loc = locator.getRegionLocation(rowKey);
                            }
                            catch (Throwable e) {
                                LOG.warn("There's something wrong when locating rowkey: " + Bytes.toString((byte[])rowKey) + " for tablename: " + tableName, e);
                                loc = null;
                            }
                        }
                        if (null == loc) {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("failed to get region location, so use default writer for rowkey: " + Bytes.toString((byte[])rowKey));
                            }
                            wl = this.getNewWriter(tableNameBytes, family, conf, null);
                        } else {
                            InetSocketAddress initialIsa;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("first rowkey: [" + Bytes.toString((byte[])rowKey) + "]");
                            }
                            if ((initialIsa = new InetSocketAddress(loc.getHostname(), loc.getPort())).isUnresolved()) {
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace("failed to resolve bind address: " + loc.getHostname() + ":" + loc.getPort() + ", so use default writer");
                                }
                                wl = this.getNewWriter(tableNameBytes, family, conf, null);
                            } else {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("use favored nodes writer: " + initialIsa.getHostString());
                                }
                                wl = this.getNewWriter(tableNameBytes, family, conf, new InetSocketAddress[]{initialIsa});
                            }
                        }
                    } else {
                        wl = this.getNewWriter(tableNameBytes, family, conf, null);
                    }
                }
                PrivateCellUtil.updateLatestStamp(cell, (long)this.now);
                wl.writer.append(kv);
                wl.written += (long)length;
                this.previousRow = rowKey;
            }

            private Path getTableRelativePath(byte[] tableNameBytes) {
                String tableName = Bytes.toString((byte[])tableNameBytes);
                String[] tableNameParts = tableName.split(":");
                Path tableRelPath = new Path(tableName.split(":")[0]);
                if (tableNameParts.length > 1) {
                    tableRelPath = new Path(tableRelPath, tableName.split(":")[1]);
                }
                return tableRelPath;
            }

            private void rollWriters(WriterLength writerLength) throws IOException {
                if (writerLength != null) {
                    this.closeWriter(writerLength);
                } else {
                    for (WriterLength wl : this.writers.values()) {
                        this.closeWriter(wl);
                    }
                }
                this.rollRequested = false;
            }

            private void closeWriter(WriterLength wl) throws IOException {
                if (wl.writer != null) {
                    LOG.info("Writer=" + wl.writer.getPath() + (wl.written == 0L ? "" : ", wrote=" + wl.written));
                    this.close(wl.writer);
                }
                wl.writer = null;
                wl.written = 0L;
            }

            @SuppressWarnings(value={"BX_UNBOXING_IMMEDIATELY_REBOXED"}, justification="Not important")
            private WriterLength getNewWriter(byte[] tableName, byte[] family, Configuration conf2, InetSocketAddress[] favoredNodes) throws IOException {
                byte[] tableAndFamily = HFileOutputFormat2.getTableNameSuffixedWithFamily(tableName, family);
                Path familydir = new Path(outputDir, Bytes.toString((byte[])family));
                if (writeMultipleTables) {
                    familydir = new Path(outputDir, new Path(this.getTableRelativePath(tableName), Bytes.toString((byte[])family)));
                }
                WriterLength wl = new WriterLength();
                Compression.Algorithm compression = (Compression.Algorithm)compressionMap.get(tableAndFamily);
                compression = compression == null ? defaultCompression : compression;
                BloomType bloomType = (BloomType)bloomTypeMap.get(tableAndFamily);
                bloomType = bloomType == null ? BloomType.NONE : bloomType;
                Integer blockSize = (Integer)blockSizeMap.get(tableAndFamily);
                blockSize = blockSize == null ? 65536 : blockSize;
                DataBlockEncoding encoding = overriddenEncoding;
                encoding = encoding == null ? (DataBlockEncoding)datablockEncodingMap.get(tableAndFamily) : encoding;
                encoding = encoding == null ? DataBlockEncoding.NONE : encoding;
                Configuration tempConf = new Configuration(conf2);
                tempConf.setFloat("hfile.block.cache.size", 0.0f);
                HFileContextBuilder contextBuilder = new HFileContextBuilder().withCompression(compression).withChecksumType(HStore.getChecksumType((Configuration)conf2)).withBytesPerCheckSum(HStore.getBytesPerChecksum((Configuration)conf2)).withBlockSize(blockSize.intValue());
                if (HFile.getFormatVersion((Configuration)conf2) >= 3) {
                    contextBuilder.withIncludesTags(true);
                }
                contextBuilder.withDataBlockEncoding(encoding);
                HFileContext hFileContext = contextBuilder.build();
                wl.writer = null == favoredNodes ? new StoreFileWriter.Builder(conf2, new CacheConfig(tempConf), fs).withOutputDir(familydir).withBloomType(bloomType).withComparator(CellComparator.getInstance()).withFileContext(hFileContext).build() : new StoreFileWriter.Builder(conf2, new CacheConfig(tempConf), (FileSystem)new HFileSystem(fs)).withOutputDir(familydir).withBloomType(bloomType).withComparator(CellComparator.getInstance()).withFileContext(hFileContext).withFavoredNodes(favoredNodes).build();
                this.writers.put(tableAndFamily, wl);
                return wl;
            }

            private void close(StoreFileWriter w) throws IOException {
                if (w != null) {
                    w.appendFileInfo(HStoreFile.BULKLOAD_TIME_KEY, Bytes.toBytes((long)System.currentTimeMillis()));
                    w.appendFileInfo(HStoreFile.BULKLOAD_TASK_KEY, Bytes.toBytes((String)context.getTaskAttemptID().toString()));
                    w.appendFileInfo(HStoreFile.MAJOR_COMPACTION_KEY, Bytes.toBytes((boolean)true));
                    w.appendFileInfo(HStoreFile.EXCLUDE_FROM_MINOR_COMPACTION_KEY, Bytes.toBytes((boolean)compactionExclude));
                    w.appendTrackedTimestampsToMetadata();
                    w.close();
                }
            }

            public void close(TaskAttemptContext c) throws IOException, InterruptedException {
                for (WriterLength wl : this.writers.values()) {
                    this.close(wl.writer);
                }
            }
        };
    }

    static void configureStoragePolicy(Configuration conf, FileSystem fs, byte[] tableAndFamily, Path cfPath) {
        if (null == conf || null == fs || null == tableAndFamily || null == cfPath) {
            return;
        }
        String policy = conf.get(STORAGE_POLICY_PROPERTY_CF_PREFIX + Bytes.toString((byte[])tableAndFamily), conf.get(STORAGE_POLICY_PROPERTY));
        FSUtils.setStoragePolicy((FileSystem)fs, (Path)cfPath, (String)policy);
    }

    private static List<ImmutableBytesWritable> getRegionStartKeys(List<RegionLocator> regionLocators, boolean writeMultipleTables) throws IOException {
        ArrayList<ImmutableBytesWritable> ret = new ArrayList<ImmutableBytesWritable>();
        for (RegionLocator regionLocator : regionLocators) {
            byte[][] byteKeys;
            TableName tableName = regionLocator.getName();
            LOG.info("Looking up current regions for table " + tableName);
            byte[][] byArray = byteKeys = regionLocator.getStartKeys();
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                byte[] byteKey;
                byte[] fullKey = byteKey = byArray[i];
                if (writeMultipleTables) {
                    fullKey = HFileOutputFormat2.combineTableNameSuffix(tableName.getName(), byteKey);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("SplitPoint startkey for table [" + tableName + "]: [" + Bytes.toStringBinary((byte[])fullKey) + "]");
                }
                ret.add(new ImmutableBytesWritable(fullKey));
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePartitions(Configuration conf, Path partitionsPath, List<ImmutableBytesWritable> startKeys, boolean writeMultipleTables) throws IOException {
        LOG.info("Writing partition information to " + partitionsPath);
        if (startKeys.isEmpty()) {
            throw new IllegalArgumentException("No regions passed");
        }
        TreeSet<ImmutableBytesWritable> sorted = new TreeSet<ImmutableBytesWritable>(startKeys);
        ImmutableBytesWritable first = sorted.first();
        if (writeMultipleTables) {
            first = new ImmutableBytesWritable(MultiTableHFileOutputFormat.getSuffix(sorted.first().get()));
        }
        if (!first.equals((Object)HConstants.EMPTY_BYTE_ARRAY)) {
            throw new IllegalArgumentException("First region of table should have empty start key. Instead has: " + Bytes.toStringBinary((byte[])first.get()));
        }
        sorted.remove(sorted.first());
        FileSystem fs = partitionsPath.getFileSystem(conf);
        try (SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)partitionsPath, ImmutableBytesWritable.class, NullWritable.class);){
            for (ImmutableBytesWritable startKey : sorted) {
                writer.append((Writable)startKey, (Writable)NullWritable.get());
            }
        }
    }

    public static void configureIncrementalLoad(Job job, Table table, RegionLocator regionLocator) throws IOException {
        HFileOutputFormat2.configureIncrementalLoad(job, table.getDescriptor(), regionLocator);
    }

    public static void configureIncrementalLoad(Job job, TableDescriptor tableDescriptor, RegionLocator regionLocator) throws IOException {
        ArrayList<TableInfo> singleTableInfo = new ArrayList<TableInfo>();
        singleTableInfo.add(new TableInfo(tableDescriptor, regionLocator));
        HFileOutputFormat2.configureIncrementalLoad(job, singleTableInfo, HFileOutputFormat2.class);
    }

    static void configureIncrementalLoad(Job job, List<TableInfo> multiTableInfo, Class<? extends OutputFormat<?, ?>> cls) throws IOException {
        Configuration conf = job.getConfiguration();
        job.setOutputKeyClass(ImmutableBytesWritable.class);
        job.setOutputValueClass(MapReduceExtendedCell.class);
        job.setOutputFormatClass(cls);
        if (multiTableInfo.stream().distinct().count() != (long)multiTableInfo.size()) {
            throw new IllegalArgumentException("Duplicate entries found in TableInfo argument");
        }
        boolean writeMultipleTables = false;
        if (MultiTableHFileOutputFormat.class.equals(cls)) {
            writeMultipleTables = true;
            conf.setBoolean(MULTI_TABLE_HFILEOUTPUTFORMAT_CONF_KEY, true);
        }
        if (KeyValue.class.equals((Object)job.getMapOutputValueClass()) || MapReduceExtendedCell.class.equals((Object)job.getMapOutputValueClass())) {
            job.setReducerClass(CellSortReducer.class);
        } else if (Put.class.equals((Object)job.getMapOutputValueClass())) {
            job.setReducerClass(PutSortReducer.class);
        } else if (Text.class.equals((Object)job.getMapOutputValueClass())) {
            job.setReducerClass(TextSortReducer.class);
        } else {
            LOG.warn("Unknown map output value type:" + job.getMapOutputValueClass());
        }
        conf.setStrings("io.serializations", new String[]{conf.get("io.serializations"), MutationSerialization.class.getName(), ResultSerialization.class.getName(), CellSerialization.class.getName()});
        if (conf.getBoolean(LOCALITY_SENSITIVE_CONF_KEY, true)) {
            LOG.info("bulkload locality sensitive enabled");
        }
        ArrayList<String> allTableNames = new ArrayList<String>(multiTableInfo.size());
        ArrayList<RegionLocator> regionLocators = new ArrayList<RegionLocator>(multiTableInfo.size());
        ArrayList<TableDescriptor> tableDescriptors = new ArrayList<TableDescriptor>(multiTableInfo.size());
        for (TableInfo tableInfo : multiTableInfo) {
            regionLocators.add(tableInfo.getRegionLocator());
            String tn = writeMultipleTables ? tableInfo.getRegionLocator().getName().getNameWithNamespaceInclAsString() : tableInfo.getRegionLocator().getName().getNameAsString();
            allTableNames.add(tn);
            tableDescriptors.add(tableInfo.getTableDescriptor());
        }
        conf.set(OUTPUT_TABLE_NAME_CONF_KEY, StringUtils.join(allTableNames, (String)Bytes.toString((byte[])tableSeparator)));
        List<ImmutableBytesWritable> startKeys = HFileOutputFormat2.getRegionStartKeys(regionLocators, writeMultipleTables);
        LOG.info("Configuring " + startKeys.size() + " reduce partitions " + "to match current region count for all tables");
        job.setNumReduceTasks(startKeys.size());
        HFileOutputFormat2.configurePartitioner(job, startKeys, writeMultipleTables);
        conf.set(COMPRESSION_FAMILIES_CONF_KEY, HFileOutputFormat2.serializeColumnFamilyAttribute(compressionDetails, tableDescriptors));
        conf.set(BLOCK_SIZE_FAMILIES_CONF_KEY, HFileOutputFormat2.serializeColumnFamilyAttribute(blockSizeDetails, tableDescriptors));
        conf.set(BLOOM_TYPE_FAMILIES_CONF_KEY, HFileOutputFormat2.serializeColumnFamilyAttribute(bloomTypeDetails, tableDescriptors));
        conf.set(DATABLOCK_ENCODING_FAMILIES_CONF_KEY, HFileOutputFormat2.serializeColumnFamilyAttribute(dataBlockEncodingDetails, tableDescriptors));
        TableMapReduceUtil.addDependencyJars(job);
        TableMapReduceUtil.initCredentials(job);
        LOG.info("Incremental output configured for tables: " + StringUtils.join(allTableNames, (String)","));
    }

    public static void configureIncrementalLoadMap(Job job, TableDescriptor tableDescriptor) throws IOException {
        Configuration conf = job.getConfiguration();
        job.setOutputKeyClass(ImmutableBytesWritable.class);
        job.setOutputValueClass(MapReduceExtendedCell.class);
        job.setOutputFormatClass(HFileOutputFormat2.class);
        ArrayList<TableDescriptor> singleTableDescriptor = new ArrayList<TableDescriptor>(1);
        singleTableDescriptor.add(tableDescriptor);
        conf.set(OUTPUT_TABLE_NAME_CONF_KEY, tableDescriptor.getTableName().getNameAsString());
        conf.set(COMPRESSION_FAMILIES_CONF_KEY, HFileOutputFormat2.serializeColumnFamilyAttribute(compressionDetails, singleTableDescriptor));
        conf.set(BLOCK_SIZE_FAMILIES_CONF_KEY, HFileOutputFormat2.serializeColumnFamilyAttribute(blockSizeDetails, singleTableDescriptor));
        conf.set(BLOOM_TYPE_FAMILIES_CONF_KEY, HFileOutputFormat2.serializeColumnFamilyAttribute(bloomTypeDetails, singleTableDescriptor));
        conf.set(DATABLOCK_ENCODING_FAMILIES_CONF_KEY, HFileOutputFormat2.serializeColumnFamilyAttribute(dataBlockEncodingDetails, singleTableDescriptor));
        TableMapReduceUtil.addDependencyJars(job);
        TableMapReduceUtil.initCredentials(job);
        LOG.info("Incremental table " + tableDescriptor.getTableName() + " output configured.");
    }

    @VisibleForTesting
    static Map<byte[], Compression.Algorithm> createFamilyCompressionMap(Configuration conf) {
        Map<byte[], String> stringMap = HFileOutputFormat2.createFamilyConfValueMap(conf, COMPRESSION_FAMILIES_CONF_KEY);
        TreeMap<byte[], Compression.Algorithm> compressionMap = new TreeMap<byte[], Compression.Algorithm>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry<byte[], String> e : stringMap.entrySet()) {
            Compression.Algorithm algorithm = HFileWriterImpl.compressionByName((String)e.getValue());
            compressionMap.put(e.getKey(), algorithm);
        }
        return compressionMap;
    }

    @VisibleForTesting
    static Map<byte[], BloomType> createFamilyBloomTypeMap(Configuration conf) {
        Map<byte[], String> stringMap = HFileOutputFormat2.createFamilyConfValueMap(conf, BLOOM_TYPE_FAMILIES_CONF_KEY);
        TreeMap<byte[], BloomType> bloomTypeMap = new TreeMap<byte[], BloomType>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry<byte[], String> e : stringMap.entrySet()) {
            BloomType bloomType = BloomType.valueOf((String)e.getValue());
            bloomTypeMap.put(e.getKey(), bloomType);
        }
        return bloomTypeMap;
    }

    @VisibleForTesting
    static Map<byte[], Integer> createFamilyBlockSizeMap(Configuration conf) {
        Map<byte[], String> stringMap = HFileOutputFormat2.createFamilyConfValueMap(conf, BLOCK_SIZE_FAMILIES_CONF_KEY);
        TreeMap<byte[], Integer> blockSizeMap = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry<byte[], String> e : stringMap.entrySet()) {
            Integer blockSize = Integer.parseInt(e.getValue());
            blockSizeMap.put(e.getKey(), blockSize);
        }
        return blockSizeMap;
    }

    @VisibleForTesting
    static Map<byte[], DataBlockEncoding> createFamilyDataBlockEncodingMap(Configuration conf) {
        Map<byte[], String> stringMap = HFileOutputFormat2.createFamilyConfValueMap(conf, DATABLOCK_ENCODING_FAMILIES_CONF_KEY);
        TreeMap<byte[], DataBlockEncoding> encoderMap = new TreeMap<byte[], DataBlockEncoding>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry<byte[], String> e : stringMap.entrySet()) {
            encoderMap.put(e.getKey(), DataBlockEncoding.valueOf((String)e.getValue()));
        }
        return encoderMap;
    }

    private static Map<byte[], String> createFamilyConfValueMap(Configuration conf, String confName) {
        TreeMap<byte[], String> confValMap = new TreeMap<byte[], String>(Bytes.BYTES_COMPARATOR);
        String confVal = conf.get(confName, "");
        for (String familyConf : confVal.split("&")) {
            String[] familySplit = familyConf.split("=");
            if (familySplit.length != 2) continue;
            try {
                confValMap.put(Bytes.toBytes((String)URLDecoder.decode(familySplit[0], "UTF-8")), URLDecoder.decode(familySplit[1], "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e);
            }
        }
        return confValMap;
    }

    static void configurePartitioner(Job job, List<ImmutableBytesWritable> splitPoints, boolean writeMultipleTables) throws IOException {
        Configuration conf = job.getConfiguration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        String hbaseTmpFsDir = conf.get("hbase.fs.tmp.dir", HConstants.DEFAULT_TEMPORARY_HDFS_DIRECTORY);
        Path partitionsPath = new Path(hbaseTmpFsDir, "partitions_" + UUID.randomUUID());
        fs.makeQualified(partitionsPath);
        HFileOutputFormat2.writePartitions(conf, partitionsPath, splitPoints, writeMultipleTables);
        fs.deleteOnExit(partitionsPath);
        job.setPartitionerClass(TotalOrderPartitioner.class);
        TotalOrderPartitioner.setPartitionFile((Configuration)conf, (Path)partitionsPath);
    }

    @SuppressWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    @VisibleForTesting
    static String serializeColumnFamilyAttribute(Function<ColumnFamilyDescriptor, String> fn, List<TableDescriptor> allTables) throws UnsupportedEncodingException {
        StringBuilder attributeValue = new StringBuilder();
        int i = 0;
        for (TableDescriptor tableDescriptor : allTables) {
            if (tableDescriptor == null) {
                return "";
            }
            for (ColumnFamilyDescriptor familyDescriptor : tableDescriptor.getColumnFamilies()) {
                if (i++ > 0) {
                    attributeValue.append('&');
                }
                attributeValue.append(URLEncoder.encode(Bytes.toString((byte[])HFileOutputFormat2.combineTableNameSuffix(tableDescriptor.getTableName().getName(), familyDescriptor.getName())), "UTF-8"));
                attributeValue.append('=');
                attributeValue.append(URLEncoder.encode(fn.apply(familyDescriptor), "UTF-8"));
            }
        }
        return attributeValue.toString();
    }

    static class WriterLength {
        long written = 0L;
        StoreFileWriter writer = null;

        WriterLength() {
        }
    }

    static class TableInfo {
        private TableDescriptor tableDesctiptor;
        private RegionLocator regionLocator;

        public TableInfo(TableDescriptor tableDesctiptor, RegionLocator regionLocator) {
            this.tableDesctiptor = tableDesctiptor;
            this.regionLocator = regionLocator;
        }

        @Deprecated
        public HTableDescriptor getHTableDescriptor() {
            return new HTableDescriptor(this.tableDesctiptor);
        }

        public TableDescriptor getTableDescriptor() {
            return this.tableDesctiptor;
        }

        public RegionLocator getRegionLocator() {
            return this.regionLocator;
        }
    }
}

