/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.command.completers;

import java.util.LinkedList;
import java.util.List;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.karaf.jaas.config.JaasRealm;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.StringsCompleter;

public class LoginModuleNameCompleter
implements Completer {
    private List<JaasRealm> realms;

    public int complete(String buffer, int cursor, List<String> candidates) {
        StringsCompleter delegate = new StringsCompleter();
        try {
            if (this.realms != null && !this.realms.isEmpty()) {
                for (JaasRealm realm : this.realms) {
                    List<String> moduleClassNames = this.findLoginModuleClassNames(realm);
                    if (moduleClassNames == null || moduleClassNames.isEmpty()) continue;
                    delegate.getStrings().addAll(moduleClassNames);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return delegate.complete(buffer, cursor, candidates);
    }

    private List<String> findLoginModuleClassNames(JaasRealm realm) {
        LinkedList<String> moduleClassNames = new LinkedList<String>();
        for (AppConfigurationEntry entry : realm.getEntries()) {
            String moduleClass = (String)entry.getOptions().get("org.apache.karaf.jaas.module");
            if (moduleClass == null) continue;
            moduleClassNames.add(moduleClass);
        }
        return moduleClassNames;
    }

    public List<JaasRealm> getRealms() {
        return this.realms;
    }

    public void setRealms(List<JaasRealm> realms) {
        this.realms = realms;
    }
}

