/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.RuntimeStorageException;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageClient;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.StorageIOException;
import org.netbeans.mdr.persistence.StoragePersistentDataException;
import org.netbeans.mdr.persistence.StorageTransientDataException;
import org.netbeans.mdr.persistence.Streamable;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.Btree;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.MofidGenerator;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeDataFile;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeFactory;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeStorage;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.CachedPageInputStream;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.CounterIndex;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.FileCache;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.FileHeader;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.MDRCache;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.MofidIndex;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.NormalBtreeExtent;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.TransactionCache;
import org.netbeans.mdr.util.Logger;

public class BtreeDatabase
implements SinglevaluedIndex,
MDRCache.OverflowHandler {
    static final int PAGE_SIZE = 2048;
    static final int FILE_CACHE_SIZE = 128;
    static final int MDR_CACHE_SIZE = 1024;
    static final int MDR_CACHE_THRESHHOLD = 1000;
    private int modificationLevel;
    private final String repositoryName;
    private BtreeDataFile dataFile;
    private SinglevaluedIndex indexFile;
    private FileCache fileCache;
    private MDRCache cache;
    private CounterIndex classIndex;
    private boolean classIndexChanged;
    private static String CLASS_INDEX_TYPE = "org.netbeans.mdr.persistence.btreeimpl.btreestorage.CounterIndex";
    private ArrayList classes;
    private MofidIndex indexIndex;
    private BtreeStorage myStorage;
    private boolean saveFailed = false;
    private byte[] baoStrmToBytes;
    private ByteArrayOutputStream baoStrm = new ByteArrayOutputStream();
    private DataOutputStream daoStrm = new DataOutputStream(this.baoStrm);
    private TransactionCache transactionCache = null;
    private PrintStream loggingStream;
    static final int DFL = 0;
    static final int IFL = 1;
    static final int LFL = 2;
    private static final String[] SUFFIXES = new String[]{".btd", ".btx", ".btb"};
    private static MofidGenerator currentlyStreamingMofidGenerator = null;
    private Map mofidMap = null;

    BtreeDatabase(String name, BtreeStorage parent, boolean isNew) throws StorageException {
        this.repositoryName = name;
        this.myStorage = parent;
        this.classes = new ArrayList();
        try {
            this.classes.add(Class.forName(CLASS_INDEX_TYPE));
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        this.open(isNew);
    }

    private static String[] getFileNames(String base) {
        String[] names = new String[]{BtreeDatabase.getFileName(base, 0), BtreeDatabase.getFileName(base, 1), BtreeDatabase.getFileName(base, 2)};
        return names;
    }

    static String getFileName(String base, int type) {
        return base.concat(SUFFIXES[type]);
    }

    static boolean exists(String base) {
        String[] names = BtreeDatabase.getFileNames(base);
        return new File(names[0]).exists() || new File(names[1]).exists() || new File(names[2]).exists();
    }

    static boolean delete(String base) {
        String[] names = BtreeDatabase.getFileNames(base);
        return BtreeDatabase.deleteFile(names[0]) & BtreeDatabase.deleteFile(names[1]) & BtreeDatabase.deleteFile(names[2]);
    }

    private static boolean deleteFile(String name) {
        File file = new File(name);
        if (!file.exists()) {
            return true;
        }
        return file.delete();
    }

    static void rename(String from, String to) throws StorageException {
        File fromLog;
        String[] toNames;
        if (BtreeDatabase.exists(to)) {
            throw new StorageBadRequestException(MessageFormat.format("Btree repository {0} already exists", to));
        }
        String[] fromNames = BtreeDatabase.getFileNames(from);
        boolean success = new File(fromNames[0]).renameTo(new File((toNames = BtreeDatabase.getFileNames(to))[0]));
        if (success) {
            success = new File(fromNames[1]).renameTo(new File(toNames[1]));
        }
        if (success && (fromLog = new File(fromNames[2])).exists()) {
            success = fromLog.renameTo(new File(toNames[0]));
        }
        if (!success) {
            throw new StorageBadRequestException(MessageFormat.format("Unable to rename btree repository {0} to {1}", from, to));
        }
    }

    private int getIntProperty(String propertyName, int defaultValue) {
        String value = (String)this.myStorage.getProperty(propertyName);
        int result = defaultValue;
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                Logger.getDefault().log("Error getting value of " + propertyName + " storage property: " + e.getMessage());
            }
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    private void open(boolean isNew) throws StorageException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 375->379)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void copy(String target) throws StorageException {
        FileCache copyCache = null;
        if (this.cache.getModStatus() != 0) {
            throw new StorageBadRequestException(MessageFormat.format("There are changes to repository {0} that have not been committed", target));
        }
        if (BtreeDatabase.exists(target)) {
            throw new StorageBadRequestException(MessageFormat.format("Btree repository {0} already exists", target));
        }
        String[] copyNames = BtreeDatabase.getFileNames(target);
        String[] fileNames = new String[]{copyNames[0]};
        BtreeDataFile.create(this.myStorage, copyNames[0], new FileHeader(), 2048, false);
        try {
            copyCache = new FileCache(fileNames, target);
            BtreeDataFile copyFile = new BtreeDataFile(this.myStorage, copyCache, 0);
            this.dataFile.copy(copyFile);
            copyCache.commit();
            copyCache.close();
            BtreeDatabase db = new BtreeDatabase(target, this.myStorage, false);
            db.close();
        }
        catch (StorageException ex) {
            if (copyCache != null) {
                copyCache.close();
            }
            BtreeDatabase.delete(target);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compress() throws StorageException {
        BtreeStorage btreeStorage = this.myStorage;
        synchronized (btreeStorage) {
            if (this.cache.getModStatus() != 0) {
                throw new StorageBadRequestException(MessageFormat.format("There are changes to repository {0} that have not been committed", this.repositoryName));
            }
            String tempName = "tmp" + new Random().nextInt();
            this.copy(tempName);
            this.closeFiles();
            BtreeDatabase.delete(this.repositoryName);
            BtreeDatabase.rename(tempName, this.repositoryName);
            this.open(false);
        }
    }

    private void rebuildIndexFile() throws StorageException {
        Iterator iter = this.dataFile.iterator(1);
        while (iter.hasNext()) {
            NormalBtreeExtent ext = (NormalBtreeExtent)iter.next();
            MOFID k = this.myStorage.readMOFIDData(new ByteArrayInputStream(ext.key));
            this.indexFile.add(k, new Integer(ext.myChunkNum));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        BtreeStorage btreeStorage = this.myStorage;
        synchronized (btreeStorage) {
            return this.dataFile.size() + this.cache.numberNew() - this.cache.numberDeleted();
        }
    }

    public String getName() {
        return this.repositoryName;
    }

    public Storage.EntryType getValueType() {
        return Storage.EntryType.STREAMABLE;
    }

    public Storage.EntryType getKeyType() {
        return Storage.EntryType.MOFID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() throws StorageException {
        BtreeStorage btreeStorage = this.myStorage;
        synchronized (btreeStorage) {
            this.closeFiles();
            this.cache.shutDown();
            this.cache = null;
            this.transactionCache = null;
        }
    }

    private void closeFiles() throws StorageException {
        ++this.modificationLevel;
        this.fileCache.abort();
        this.fileCache = null;
        this.dataFile = null;
        this.indexFile = null;
    }

    public void cacheThreshholdReached(MDRCache cach, int size) throws StorageException {
        this.saveChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitChanges() throws StorageException {
        BtreeStorage btreeStorage = this.myStorage;
        synchronized (btreeStorage) {
            this.save(false);
            if (this.transactionCache.tresholdReached()) {
                try {
                    this.fileCache.commit();
                    this.transactionCache.clear();
                }
                catch (StorageException ex) {
                    this.saveFailed = true;
                    throw ex;
                }
            } else {
                this.transactionCache.commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() throws StorageException {
        BtreeStorage btreeStorage = this.myStorage;
        synchronized (btreeStorage) {
            this.cache.shutDown();
            try {
                this.fileCache.close();
            }
            catch (StorageException ex) {
                this.saveFailed = true;
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveChanges() throws StorageException {
        BtreeStorage btreeStorage = this.myStorage;
        synchronized (btreeStorage) {
            this.save(false);
        }
    }

    public String toString() {
        return this.myStorage.getStorageId();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void save(boolean commit) throws StorageException {
        if (this.saveFailed) {
            throw new StorageBadRequestException("A save of this repository has failed previously.  Allowing this commit to proceed would potentially corrupt persistent data.");
        }
        try {
            try {
                block16: {
                    ++this.modificationLevel;
                    this.classIndexChanged = false;
                    int modStatus = this.cache.getModStatus();
                    while (true) {
                        Object value;
                        Map.Entry entry;
                        MOFID id;
                        StorageException writeError;
                        if (modStatus == 0) {
                            if (this.classIndexChanged) {
                                writeError = this.replaceRecord(BtreeFactory.classIndexId, this.classIndex);
                                this.transactionCache.addReplaced(BtreeFactory.classIndexId, this.baoStrmToBytes);
                                if (writeError == null) break;
                                throw writeError;
                            }
                            break block16;
                        }
                        if ((modStatus & 1) != 0) {
                            Iterator delIter = this.cache.getDeleted().iterator();
                            while (delIter.hasNext()) {
                                id = (MOFID)delIter.next();
                                this.removeRecord(id);
                                this.transactionCache.addDeleted(id);
                            }
                        }
                        if ((modStatus & 2) != 0) {
                            Iterator dirtyIter = this.cache.getDirty().iterator();
                            while (dirtyIter.hasNext()) {
                                entry = (Map.Entry)dirtyIter.next();
                                id = (MOFID)entry.getKey();
                                writeError = this.replaceRecord(id, value = entry.getValue());
                                if (writeError != null) throw writeError;
                                this.transactionCache.addReplaced(id, this.baoStrmToBytes);
                            }
                        }
                        if ((modStatus & 4) != 0) {
                            Iterator newIter = this.cache.getNew().iterator();
                            while (newIter.hasNext()) {
                                entry = (Map.Entry)newIter.next();
                                id = (MOFID)entry.getKey();
                                writeError = this.addRecord(id, value = entry.getValue());
                                if (writeError != null) throw writeError;
                                this.transactionCache.addInserted(id, this.baoStrmToBytes);
                            }
                        }
                        modStatus = this.cache.getModStatus();
                    }
                    this.classIndexChanged = false;
                }
                if (commit) {
                    this.fileCache.commit();
                    this.transactionCache.clear();
                }
            }
            catch (StorageException ex) {
                this.saveFailed = true;
                throw ex;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.cache.updateSize();
            throw throwable;
        }
        {
            Object var8_11 = null;
            this.cache.updateSize();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackChanges() throws StorageException {
        BtreeStorage btreeStorage = this.myStorage;
        synchronized (btreeStorage) {
            ++this.modificationLevel;
            TransactionCache.CacheIterator iter = this.transactionCache.iterator();
            long counter = this.dataFile.getMofIdCounter();
            boolean dataCommited = this.transactionCache.containsCommitedData();
            this.close();
            this.open(false);
            try {
                while (iter.hasNext()) {
                    TransactionCache.Record rec = iter.next();
                    switch (rec.op) {
                        case 1: {
                            this.removeRecord(rec.id);
                            break;
                        }
                        case 2: {
                            Integer offset = (Integer)this.indexFile.get(rec.id);
                            int dataOffset = this.dataFile.replace((int)offset, rec.id.getSerialNumber(), rec.value);
                            this.indexFile.replace(rec.id, new Integer(dataOffset));
                            break;
                        }
                        case 0: {
                            int dataOffset = this.dataFile.put(rec.id.getSerialNumber(), rec.value);
                            this.indexFile.add(rec.id, new Integer(dataOffset));
                        }
                    }
                }
                this.dataFile.setMofIdCounter(counter);
                this.fileCache.commit();
            }
            catch (StorageException ex) {
                this.saveFailed = true;
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object mKey) throws StorageException {
        BtreeStorage btreeStorage = this.myStorage;
        synchronized (btreeStorage) {
            block4: {
                ++this.modificationLevel;
                if (this.exists((MOFID)mKey)) break block4;
                return false;
            }
            this.cache.remove(mKey);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object key, Object value) throws StorageException {
        MOFID mKey = (MOFID)key;
        BtreeStorage btreeStorage = this.myStorage;
        synchronized (btreeStorage) {
            ++this.modificationLevel;
            if (this.exists(mKey)) {
                throw new StorageBadRequestException(MessageFormat.format("Record with key {0} already exists", mKey));
            }
            this.addToCache(mKey, value);
        }
    }

    private void addToCache(MOFID key, Object value) throws StorageException {
        this.cache.put(key, value);
        this.cache.setNew(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(Object key, Object value) throws StorageException {
        MOFID mKey = (MOFID)key;
        BtreeStorage btreeStorage = this.myStorage;
        synchronized (btreeStorage) {
            ++this.modificationLevel;
            if (!this.exists(mKey)) {
                this.noSuchRecord(mKey);
            }
            this.replaceInCache(mKey, value);
        }
    }

    private void replaceInCache(MOFID key, Object value) throws StorageException {
        boolean isNew = this.cache.isNew(key);
        this.cache.replace(key, value);
        if (isNew) {
            this.cache.setNew(key);
        } else {
            this.cache.setDirty(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(Object key, Object value) throws StorageException {
        BtreeStorage btreeStorage = this.myStorage;
        synchronized (btreeStorage) {
            MOFID mKey;
            block4: {
                ++this.modificationLevel;
                mKey = (MOFID)key;
                if (this.exists(mKey)) break block4;
                this.addToCache(mKey, value);
                return false;
            }
            this.replaceInCache(mKey, value);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getIfExists(Object key) throws StorageException {
        BtreeStorage btreeStorage = this.myStorage;
        synchronized (btreeStorage) {
            Object retval = this.cache.get(key);
            if (retval == null) {
                if (this.cache.isDeleted(key)) {
                    return null;
                }
                retval = this.getRecord((MOFID)key);
                if (retval != null) {
                    this.cache.put(key, retval);
                }
            }
            return retval;
        }
    }

    public Object getObjectIfExists(Object key, SinglevaluedIndex dummy) throws StorageException {
        return this.getIfExists(key);
    }

    public Object get(Object key) throws StorageException {
        Object retval = this.getIfExists(key);
        if (retval == null) {
            this.noSuchRecord(key);
        }
        return retval;
    }

    public Object getObject(Object key, SinglevaluedIndex dummy) throws StorageException {
        return this.get(key);
    }

    public Collection queryByKeyPrefix(Object prefix, SinglevaluedIndex repos) {
        throw new UnsupportedOperationException();
    }

    private boolean exists(MOFID key) throws StorageException {
        if (this.cache.get(key) != null) {
            return true;
        }
        if (this.cache.isDeleted(key)) {
            return false;
        }
        return this.indexFile.getIfExists(key) != null;
    }

    private boolean removeRecord(MOFID mKey) throws StorageException {
        Integer offset = (Integer)this.indexFile.getIfExists(mKey);
        if (offset == null) {
            this.noSuchRecord(mKey);
        }
        this.indexFile.remove(mKey);
        this.dataFile.remove((int)offset, mKey.getSerialNumber());
        return true;
    }

    public void objectStateChanged(Object key) throws StorageException {
        this.objectStateChanged((MOFID)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void objectStateChanged(MOFID mKey) throws StorageException {
        BtreeStorage btreeStorage = this.myStorage;
        synchronized (btreeStorage) {
            ++this.modificationLevel;
            this.cache.setDirty(mKey);
        }
    }

    Object fetchIndex(String name) throws StorageException {
        this.fetchIndexIndex();
        MOFID indexID = this.indexIndex.get(name);
        return indexID == null ? null : this.get(indexID);
    }

    void dropIndex(String name) throws StorageException {
        ++this.modificationLevel;
        this.fetchIndexIndex();
        MOFID indexId = this.indexIndex.get(name);
        this.indexIndex.remove(name);
        this.objectStateChanged(BtreeFactory.indexIndexId);
        this.remove(indexId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listIndexes() throws StorageException {
        BtreeStorage btreeStorage = this.myStorage;
        synchronized (btreeStorage) {
            this.fetchIndexIndex();
            Object[] retval = this.indexIndex.listNames();
            Arrays.sort(retval);
            return retval;
        }
    }

    void addIndex(String name, Object index, MOFID mID) throws StorageException {
        ++this.modificationLevel;
        this.add(mID, index);
        this.fetchIndexIndex();
        this.indexIndex.add(name, mID);
        this.objectStateChanged(BtreeFactory.indexIndexId);
    }

    static MofidGenerator getCurrentlyStreamingMofidGenerator() {
        return currentlyStreamingMofidGenerator;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StorageException writeStreamable(Streamable obj) {
        MofidGenerator previous = currentlyStreamingMofidGenerator;
        currentlyStreamingMofidGenerator = this.dataFile;
        try {
            try {
                this.baoStrm.reset();
                this.daoStrm.writeInt(this.getClassCode(obj.getClass()));
                obj.write(this.daoStrm);
                this.baoStrmToBytes = this.baoStrm.toByteArray();
            }
            catch (StorageException ex) {
                StorageException storageException = ex;
                Object var4_9 = null;
                currentlyStreamingMofidGenerator = previous;
                return storageException;
            }
            catch (IOException ioException) {
                StorageException storageException = (StorageException)Logger.getDefault().annotate((Throwable)new StorageIOException(ioException), (Throwable)ioException);
                Object var4_10 = null;
                currentlyStreamingMofidGenerator = previous;
                return storageException;
            }
            catch (RuntimeException th) {
                StorageException storageException = (StorageException)Logger.getDefault().annotate((Throwable)new StorageTransientDataException(String.valueOf(th.getClass().getName()) + ": " + th.getMessage()), (Throwable)th);
                Object var4_11 = null;
                currentlyStreamingMofidGenerator = previous;
                return storageException;
            }
        }
        catch (Throwable throwable) {
            Object var4_12 = null;
            currentlyStreamingMofidGenerator = previous;
            throw throwable;
        }
        {
            Object var4_13 = null;
            currentlyStreamingMofidGenerator = previous;
            return null;
        }
    }

    private Streamable readStreamable(DataInputStream stream) throws StorageException {
        Streamable data;
        int classCode;
        try {
            classCode = stream.readInt();
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
        try {
            Class cls = (Class)this.classes.get(classCode);
            data = (Streamable)cls.newInstance();
        }
        catch (Exception ex) {
            throw new StoragePersistentDataException(ex.getMessage());
        }
        if (data instanceof StorageClient) {
            ((StorageClient)((Object)data)).setStorage(this.myStorage);
        }
        data.read(stream);
        return data;
    }

    private StorageException addRecord(MOFID mKey, Object value) throws StorageException {
        StorageException ex = this.writeStreamable((Streamable)value);
        if (ex != null) {
            return ex;
        }
        int dataOffset = this.dataFile.put(mKey.getSerialNumber(), this.baoStrmToBytes);
        this.indexFile.add(mKey, new Integer(dataOffset));
        return null;
    }

    int getClassCode(Class cls) throws StorageException {
        String className = cls.getName();
        this.fetchClassIndex();
        Integer i = this.classIndex.getIf(className);
        if (i != null) {
            return i;
        }
        int code = this.classIndex.add(className);
        this.classes.add(code, cls);
        this.classIndexChanged = true;
        return code;
    }

    private StorageException replaceRecord(MOFID mKey, Object value) throws StorageException {
        StorageException ex = this.writeStreamable((Streamable)value);
        if (ex != null) {
            return ex;
        }
        Integer offset = (Integer)this.indexFile.get(mKey);
        int dataOffset = this.dataFile.replace((int)offset, mKey.getSerialNumber(), this.baoStrmToBytes);
        this.indexFile.replace(mKey, new Integer(dataOffset));
        return null;
    }

    private void noSuchRecord(Object key) throws StorageException {
        throw new StorageBadRequestException(MessageFormat.format("No record exists with key {0}", key));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object getRecord(MOFID mKey) throws StorageException {
        Streamable data;
        Integer offset = (Integer)this.indexFile.getIfExists(mKey);
        if (offset == null) {
            return null;
        }
        CachedPageInputStream strm = this.dataFile.get((int)offset, mKey.getSerialNumber());
        try {
            DataInputStream inStream = new DataInputStream(strm);
            data = this.readStreamable(inStream);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                ((InputStream)strm).close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new StorageIOException(ex);
            }
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
        ((InputStream)strm).close();
        return data;
    }

    private void fetchIndexIndex() throws StorageException {
        if (this.indexIndex == null) {
            this.indexIndex = (MofidIndex)this.getIfExists(BtreeFactory.indexIndexId);
            if (this.indexIndex == null) {
                this.indexIndex = new MofidIndex(this.myStorage);
                this.add(BtreeFactory.indexIndexId, this.indexIndex);
            }
            this.indexIndex.setName("Index of secondary Indexes");
        }
    }

    private void fetchClassIndex() throws StorageException {
        if (this.classIndex == null) {
            this.classIndex = (CounterIndex)this.getIfExists(BtreeFactory.classIndexId);
            if (this.classIndex == null) {
                this.classIndex = new CounterIndex();
                this.classIndex.add(CLASS_INDEX_TYPE);
                this.add(BtreeFactory.classIndexId, this.classIndex);
            } else {
                Iterator itr = this.classIndex.iterator();
                while (itr.hasNext()) {
                    Map.Entry ent = (Map.Entry)itr.next();
                    try {
                        int code = (Integer)ent.getValue();
                        while (this.classes.size() < code + 1) {
                            this.classes.add(null);
                        }
                        this.classes.set(code, Class.forName((String)ent.getKey()));
                    }
                    catch (Exception ex) {
                        throw new StoragePersistentDataException(ex.getMessage());
                    }
                }
            }
            this.classIndex.setName("Index of stored classes");
        }
    }

    public Set keySet() throws StorageException {
        return new Keys();
    }

    public Collection values() throws StorageException {
        return new Values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoggingStream(PrintStream strm) {
        BtreeStorage btreeStorage = this.myStorage;
        synchronized (btreeStorage) {
            this.loggingStream = strm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MofidGenerator getMofidGenerator() {
        BtreeStorage btreeStorage = this.myStorage;
        synchronized (btreeStorage) {
            return this.dataFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getMofidMap() {
        BtreeStorage btreeStorage = this.myStorage;
        synchronized (btreeStorage) {
            if (this.mofidMap == null) {
                this.mofidMap = new HashMap();
                this.mofidMap.put(this.dataFile.getMofidPrefix(), this.dataFile);
            }
            return this.mofidMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkConsistency(PrintWriter strm) throws StorageException {
        BtreeStorage btreeStorage = this.myStorage;
        synchronized (btreeStorage) {
            int numErrs = this.dataFile.dump(16, 0, false, strm);
            Iterator recordIter = this.dataFile.iterator(1);
            while (recordIter.hasNext()) {
                NormalBtreeExtent ext = (NormalBtreeExtent)recordIter.next();
                MOFID mKey = this.myStorage.readMOFIDData(new ByteArrayInputStream(ext.key));
                Integer offset = (Integer)this.indexFile.getIfExists(mKey);
                if (offset == null) {
                    strm.println("ID " + mKey + " is not in the index file.");
                    ++numErrs;
                    continue;
                }
                if (offset == ext.myChunkNum) continue;
                strm.println("ID " + mKey + " has differring offsets: " + ext.myChunkNum + " and " + offset);
                ++numErrs;
            }
            Iterator actIter = this.cache.iterateActive();
            while (actIter.hasNext()) {
                MOFID key = (MOFID)actIter.next();
                if (this.cache.isDeleted(key)) {
                    if (this.cache.isNew(key)) continue;
                    strm.println("ID " + key + " is deleted and active but not new");
                    ++numErrs;
                    continue;
                }
                if (this.cache.isNew(key)) {
                    if (!this.inIndexFile(key)) continue;
                    strm.println("ID " + key + " is new but in the index file");
                    ++numErrs;
                    continue;
                }
                if (this.inIndexFile(key)) continue;
                strm.println("ID " + key + " exists but is not in the index file");
                ++numErrs;
            }
            Iterator delIter = this.cache.iterateDeleted();
            while (delIter.hasNext()) {
                MOFID key = (MOFID)delIter.next();
                if (this.inIndexFile(key)) continue;
                strm.println("ID " + key + " is deleted but not in the index file");
                ++numErrs;
            }
            strm.println((numErrs += ((Btree)((Object)this.indexFile)).consistencyCheck(strm)) + " error(s) detected.");
            strm.println();
            this.cache.showStats(strm);
            strm.println();
            this.fileCache.showStats(strm);
            strm.println();
            strm.flush();
            return numErrs;
        }
    }

    private boolean inIndexFile(MOFID key) throws StorageException {
        return this.indexFile.getIfExists(key) != null;
    }

    class KeyIterator
    implements Iterator {
        private int iterModLevel;
        private Iterator fileIter;
        private Iterator newIter;
        private MOFID nextKey;

        KeyIterator(boolean internal) {
            this.fileIter = BtreeDatabase.this.dataFile.iterator(2);
            this.newIter = null;
            this.iterModLevel = BtreeDatabase.this.modificationLevel;
            this.getNextKey();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getNextKey() {
            this.nextKey = null;
            BtreeStorage btreeStorage = BtreeDatabase.this.myStorage;
            synchronized (btreeStorage) {
                this.checkModLevel();
                while (this.fileIter.hasNext()) {
                    MOFID fileKey = (MOFID)this.fileIter.next();
                    if (BtreeDatabase.this.cache.isDeleted(fileKey)) continue;
                    this.nextKey = fileKey;
                    return;
                }
                if (this.newIter == null) {
                    this.newIter = BtreeDatabase.this.cache.iterateNew();
                }
                if (this.newIter.hasNext()) {
                    this.nextKey = (MOFID)this.newIter.next();
                }
            }
        }

        public synchronized boolean hasNext() {
            return this.nextKey != null;
        }

        public synchronized Object next() {
            MOFID current = this.nextKey;
            this.getNextKey();
            return current;
        }

        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported");
        }

        private void checkModLevel() {
            if (this.iterModLevel != BtreeDatabase.this.modificationLevel) {
                throw new ConcurrentModificationException("Database had been modified");
            }
        }
    }

    class ValueIterator
    implements Iterator {
        private Iterator keyIter;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ValueIterator() {
            BtreeStorage btreeStorage = BtreeDatabase.this.myStorage;
            synchronized (btreeStorage) {
                this.keyIter = new KeyIterator(true);
            }
        }

        public boolean hasNext() {
            return this.keyIter.hasNext();
        }

        public Object next() {
            MOFID id = (MOFID)this.keyIter.next();
            try {
                return BtreeDatabase.this.get(id);
            }
            catch (StorageException ex) {
                throw new RuntimeStorageException(ex);
            }
        }

        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported");
        }
    }

    class Keys
    extends AbstractSet
    implements Set {
        Keys() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterator iterator() {
            BtreeStorage btreeStorage = BtreeDatabase.this.myStorage;
            synchronized (btreeStorage) {
                return new KeyIterator(false);
            }
        }

        public int size() {
            return BtreeDatabase.this.size();
        }
    }

    class Values
    extends AbstractCollection
    implements Collection {
        Values() {
        }

        public Iterator iterator() {
            return new ValueIterator();
        }

        public int size() {
            return BtreeDatabase.this.size();
        }
    }
}

