/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.storagemodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageClient;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.Streamable;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.mdr.storagemodel.StorablePackage;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.IOUtils;
import org.netbeans.mdr.util.Logger;

public abstract class StorableBaseObject
implements Streamable,
StorageClient {
    private MOFID id;
    protected MOFID meta;
    protected MOFID immediatePackage;
    private transient MOFID outermostPackage = null;
    private transient StorablePackage immediatePackageObj = null;
    private transient StorablePackage outermostPackageObj = null;
    private transient Storage storage;
    private transient MdrStorage mdrStorage;
    protected boolean initFinished;
    private Object slot1 = null;
    private Object slot2 = null;
    private Object slot3 = null;
    private Object slot4 = null;
    private Map propertiesSlot = null;
    private int slotsCount = 0;

    public StorableBaseObject() {
        this.initFinished = true;
    }

    StorableBaseObject(MdrStorage mdrStorage, MOFID immediatePackage, MOFID meta) throws StorageException {
        this(mdrStorage, immediatePackage, meta, null);
    }

    StorableBaseObject(MdrStorage mdrStorage, MOFID immediatePackage, MOFID meta, String storageId) throws StorageException {
        MOFID parentOutermost;
        this.initFinished = false;
        this.id = storageId == null ? mdrStorage.generateMOFID(immediatePackage) : mdrStorage.generateMOFID(storageId);
        this.meta = meta;
        this.immediatePackage = immediatePackage;
        this.mdrStorage = mdrStorage;
        this.outermostPackage = immediatePackage != null ? ((parentOutermost = mdrStorage.getObject(immediatePackage).getOutermostPackageId()) == null ? immediatePackage : parentOutermost) : this.id;
    }

    public StorableObject getMetaObject() throws StorageException {
        return (StorableObject)this.getMdrStorage().getObject(this.meta);
    }

    public StorablePackage getImmediatePackage() throws StorageException {
        if (this.immediatePackageObj == null) {
            this.immediatePackageObj = (StorablePackage)this.getMdrStorage().getObject(this.immediatePackage);
        }
        return this.immediatePackageObj;
    }

    public MOFID getImmediatePackageId() {
        return this.immediatePackage;
    }

    public MOFID getMetaObjectId() {
        return this.meta;
    }

    public MOFID getOutermostPackageId() {
        if (this.outermostPackage == null) {
            if (this.immediatePackage == null) {
                this.outermostPackage = this.getMofId();
            } else {
                try {
                    StorablePackage temp;
                    StorableBaseObject pkg = this.mdrStorage.getObject(this.immediatePackage);
                    while ((temp = pkg.getImmediatePackage()) != null) {
                        pkg = temp;
                        if (temp != null) continue;
                    }
                    this.outermostPackage = pkg.getMofId();
                }
                catch (StorageException e) {
                    throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
                }
            }
        }
        return this.outermostPackage;
    }

    public StorablePackage getOutermostPackage() throws StorageException {
        if (this.outermostPackageObj == null) {
            this.outermostPackageObj = (StorablePackage)this.getMdrStorage().getObject(this.getOutermostPackageId());
        }
        return this.outermostPackageObj;
    }

    public MOFID getMofId() {
        return this.id;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.id.toString() + ")";
    }

    public boolean equals(Object o) {
        return o instanceof StorableBaseObject && ((StorableBaseObject)o).getMofId().equals(this.getMofId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    protected void deleteRecursive() throws StorageException {
        this.getMdrStorage().removeObject(this);
    }

    public void write(OutputStream outputStream) {
        try {
            IOUtils.writeMOFID(outputStream, this.id, this.getMdrStorage(), this.id);
            outputStream.write(this.slotsCount);
            switch (this.slotsCount) {
                case 5: {
                    IOUtils.write(outputStream, this.propertiesSlot, this);
                }
                case 4: {
                    IOUtils.write(outputStream, this.slot4, this);
                }
                case 3: {
                    IOUtils.write(outputStream, this.slot3, this);
                }
                case 2: {
                    IOUtils.write(outputStream, this.slot2, this);
                }
                case 1: {
                    IOUtils.write(outputStream, this.slot1, this);
                }
            }
        }
        catch (IOException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new RuntimeException(), (Throwable)e);
        }
    }

    public void read(InputStream inputStream) {
        try {
            this.id = IOUtils.readMOFID(inputStream, this.storage);
            this.slotsCount = inputStream.read();
            switch (this.slotsCount) {
                case 5: {
                    this.propertiesSlot = (Map)IOUtils.read(inputStream, this, null);
                }
                case 4: {
                    this.slot4 = IOUtils.read(inputStream, this, null);
                }
                case 3: {
                    this.slot3 = IOUtils.read(inputStream, this, null);
                }
                case 2: {
                    this.slot2 = IOUtils.read(inputStream, this, null);
                }
                case 1: {
                    this.slot1 = IOUtils.read(inputStream, this, null);
                }
            }
            this.outermostPackage = null;
        }
        catch (IOException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    public void setStorage(Storage storage) {
        this.storage = storage;
        this.mdrStorage = MdrStorage.getInstance(storage);
    }

    public MdrStorage getMdrStorage() {
        return this.mdrStorage;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void putProperty(Object key, Object value) {
        if (key == null) throw new IllegalArgumentException();
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.objectWillChange();
        if (this.propertiesSlot == null) {
            this.propertiesSlot = new HashMap();
            this.slotsCount = 5;
        }
        boolean failed = true;
        this.mdrStorage.getRepository().beginTrans(true);
        try {
            this.propertiesSlot.put(key, value);
            this.objectChanged();
            failed = false;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.mdrStorage.getRepository().endTrans(failed);
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.mdrStorage.getRepository().endTrans(failed);
            return;
        }
    }

    public Object removeProperty(Object key) {
        if (this.propertiesSlot == null) {
            return null;
        }
        boolean failed = true;
        this.mdrStorage.getRepository().beginTrans(true);
        try {
            this.objectWillChange();
            Object result = this.propertiesSlot.remove(key);
            if (result != null) {
                this.objectChanged();
            }
            if (this.propertiesSlot.size() == 0) {
                this.propertiesSlot = null;
            }
            failed = false;
            Object v = result;
            Object var4_5 = null;
            this.mdrStorage.getRepository().endTrans(failed);
            return v;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.mdrStorage.getRepository().endTrans(failed);
            throw throwable;
        }
    }

    public Object getProperty(Object key) {
        if (this.propertiesSlot == null) {
            return null;
        }
        return this.propertiesSlot.get(key);
    }

    public Object setSlot1(Object value) {
        Object result = this.slot1;
        this.objectWillChange();
        this.slot1 = value;
        if (this.slotsCount < 1) {
            this.slotsCount = 1;
        }
        this.objectChanged();
        return result;
    }

    public Object getSlot1() {
        return this.slot1;
    }

    public Object setSlot2(Object value) {
        Object result = this.slot2;
        this.objectWillChange();
        this.slot2 = value;
        if (this.slotsCount < 2) {
            this.slotsCount = 2;
        }
        this.objectChanged();
        return result;
    }

    public Object getSlot2() {
        return this.slot2;
    }

    public Object setSlot3(Object value) {
        Object result = this.slot3;
        this.objectWillChange();
        this.slot3 = value;
        if (this.slotsCount < 3) {
            this.slotsCount = 3;
        }
        this.objectChanged();
        return result;
    }

    public Object getSlot3() {
        return this.slot3;
    }

    public Object setSlot4(Object value) {
        Object result = this.slot4;
        this.objectWillChange();
        this.slot4 = value;
        if (this.slotsCount < 4) {
            this.slotsCount = 4;
        }
        this.objectChanged();
        return result;
    }

    public Object getSlot4() {
        return this.slot4;
    }

    protected void replaceValues(Map table) {
        this.meta = (MOFID)table.get(this.meta);
    }

    public void objectWillChange() {
        if (this.initFinished) {
            try {
                this.getMdrStorage().objectStateWillChange(this.id);
            }
            catch (StorageException e) {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
            }
        }
    }

    public void objectChanged() {
        if (this.initFinished) {
            try {
                this.getMdrStorage().objectStateChanged(this.id);
            }
            catch (StorageException e) {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
            }
        }
    }
}

