/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace;

import java.io.Closeable;
import org.apache.htrace.Span;
import org.apache.htrace.Tracer;
import org.apache.htrace.commons.logging.Log;
import org.apache.htrace.commons.logging.LogFactory;

public class TraceScope
implements Closeable {
    private static final Log LOG = LogFactory.getLog(TraceScope.class);
    private final Span span;
    private final Span savedSpan;
    private boolean detached = false;

    TraceScope(Span span, Span saved) {
        this.span = span;
        this.savedSpan = saved;
    }

    public Span getSpan() {
        return this.span;
    }

    public Span detach() {
        if (this.detached) {
            Tracer.clientError("Tried to detach trace span " + this.span + " but " + "it has already been detached.");
        }
        this.detached = true;
        Span cur = Tracer.getInstance().currentSpan();
        if (cur != this.span) {
            Tracer.clientError("Tried to detach trace span " + this.span + " but " + "it is not the current span for the " + Thread.currentThread().getName() + " thread.  You have " + "probably forgotten to close or detach " + cur);
        } else {
            Tracer.getInstance().setCurrentSpan(this.savedSpan);
        }
        return this.span;
    }

    public boolean isDetached() {
        return this.detached;
    }

    @Override
    public void close() {
        if (this.detached) {
            return;
        }
        this.detached = true;
        Span cur = Tracer.getInstance().currentSpan();
        if (cur != this.span) {
            Tracer.clientError("Tried to close trace span " + this.span + " but " + "it is not the current span for the " + Thread.currentThread().getName() + " thread.  You have " + "probably forgotten to close or detach " + cur);
        } else {
            this.span.stop();
            Tracer.getInstance().setCurrentSpan(this.savedSpan);
        }
    }
}

