/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.extensionpoints.job.entry;

import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryListener;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metaverse.analyzer.kettle.extensionpoints.job.JobLineageHolderMap;
import org.pentaho.metaverse.api.analyzer.kettle.jobentry.IJobEntryExternalResourceConsumer;
import org.pentaho.metaverse.api.model.ExternalResourceInfoFactory;
import org.pentaho.metaverse.api.model.IExecutionData;
import org.pentaho.metaverse.api.model.IExecutionProfile;

public class JobEntryExternalResourceListener
implements JobEntryListener {
    IJobEntryExternalResourceConsumer consumer;

    public JobEntryExternalResourceListener() {
    }

    public JobEntryExternalResourceListener(IJobEntryExternalResourceConsumer consumer) {
        this.consumer = consumer;
    }

    public void beforeExecution(Job job, JobEntryCopy jobEntryCopy, JobEntryInterface jobEntryInterface) {
    }

    public void afterExecution(Job job, JobEntryCopy jobEntryCopy, JobEntryInterface jobEntryInterface, Result result) {
        List resultFiles;
        List dependencies;
        IExecutionProfile executionProfile = JobLineageHolderMap.getInstance().getLineageHolder(job).getExecutionProfile();
        IExecutionData executionData = executionProfile.getExecutionData();
        JobMeta jobMeta = job.getJobMeta();
        if (jobMeta != null && (dependencies = jobEntryInterface.getResourceDependencies(jobMeta)) != null) {
            for (ResourceReference ref : dependencies) {
                List resourceEntries = ref.getEntries();
                if (resourceEntries == null) continue;
                for (ResourceEntry entry : resourceEntries) {
                    executionData.addExternalResource(jobEntryInterface.getName(), ExternalResourceInfoFactory.createResource((ResourceEntry)entry, (boolean)true));
                }
            }
        }
        if (result != null && (resultFiles = result.getResultFilesList()) != null) {
            for (ResultFile resultFile : resultFiles) {
                executionData.addExternalResource(jobEntryInterface.getName(), ExternalResourceInfoFactory.createFileResource((FileObject)resultFile.getFile(), (boolean)false));
            }
        }
    }
}

