/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step.rest;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.steps.rest.RestMeta;
import org.pentaho.metaverse.api.IComponentDescriptor;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.IMetaverseObjectFactory;
import org.pentaho.metaverse.api.MetaverseComponentDescriptor;
import org.pentaho.metaverse.api.MetaverseException;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.step.ExternalResourceStepAnalyzer;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;

public class RestClientStepAnalyzer
extends ExternalResourceStepAnalyzer<RestMeta> {
    protected Set<StepField> getUsedFields(RestMeta stepMeta) {
        Object[] headerFields;
        Object[] parameterFields;
        HashSet<StepField> usedFields = new HashSet<StepField>();
        if (stepMeta.isUrlInField() && StringUtils.isNotEmpty((String)stepMeta.getUrlField())) {
            usedFields.addAll(this.createStepFields(stepMeta.getUrlField(), this.getInputs()));
        }
        if (stepMeta.isDynamicMethod() && StringUtils.isNotEmpty((String)stepMeta.getMethodFieldName())) {
            usedFields.addAll(this.createStepFields(stepMeta.getMethodFieldName(), this.getInputs()));
        }
        if (StringUtils.isNotEmpty((String)stepMeta.getBodyField())) {
            usedFields.addAll(this.createStepFields(stepMeta.getBodyField(), this.getInputs()));
        }
        if (ArrayUtils.isNotEmpty((Object[])(parameterFields = stepMeta.getParameterField()))) {
            for (Object paramField : parameterFields) {
                usedFields.addAll(this.createStepFields((String)paramField, this.getInputs()));
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])(headerFields = stepMeta.getHeaderField()))) {
            for (Object headerField : headerFields) {
                usedFields.addAll(this.createStepFields((String)headerField, this.getInputs()));
            }
        }
        return usedFields;
    }

    protected Map<String, RowMetaInterface> getInputRowMetaInterfaces(RestMeta meta) {
        return this.getInputFields((BaseStepMeta)meta);
    }

    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        HashSet<Class<? extends BaseStepMeta>> supportedSteps = new HashSet<Class<? extends BaseStepMeta>>();
        supportedSteps.add(RestMeta.class);
        return supportedSteps;
    }

    public IMetaverseNode createResourceNode(IExternalResourceInfo resource) throws MetaverseException {
        MetaverseComponentDescriptor componentDescriptor = new MetaverseComponentDescriptor(resource.getName(), this.getResourceInputNodeType(), this.descriptor.getNamespace(), this.descriptor.getContext());
        IMetaverseNode node = this.createNodeFromDescriptor((IComponentDescriptor)componentDescriptor);
        return node;
    }

    public String getResourceInputNodeType() {
        return "Web Service";
    }

    public String getResourceOutputNodeType() {
        return null;
    }

    public boolean isOutput() {
        return false;
    }

    public boolean isInput() {
        return true;
    }

    protected void setObjectFactory(IMetaverseObjectFactory objectFactory) {
        this.metaverseObjectFactory = objectFactory;
    }
}

