/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.graph;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.IteratorUtils;
import org.pentaho.metaverse.api.IGraphWriter;
import org.pentaho.metaverse.api.model.BaseMetaverseBuilder;
import org.pentaho.metaverse.impl.MetaverseConfig;

public abstract class BaseGraphWriter
implements IGraphWriter {
    public static void adjustGraph(Graph graph) {
        BaseGraphWriter.mergeOutputsAndInputs(graph);
        if (MetaverseConfig.deduplicateTransformationFields()) {
            BaseGraphWriter.deduplicateTransFields(graph);
        }
        if (MetaverseConfig.adjustExternalResourceFields()) {
            BaseGraphWriter.addExternalResourceContainsFieldsLinks(graph);
            BaseGraphWriter.deduplicateExternalResourceFields(graph);
        }
    }

    public final void outputGraph(Graph graph, OutputStream graphMLOutputStream) throws IOException {
        BaseGraphWriter.adjustGraph(graph);
        this.outputGraphImpl(graph, graphMLOutputStream);
    }

    protected abstract void outputGraphImpl(Graph var1, OutputStream var2) throws IOException;

    private static Set<Vertex> getVerticesByCategoryAndName(Graph graph, String category, String name) {
        Iterator allVertices = graph.getVertices().iterator();
        HashSet<Vertex> documentElementVertices = new HashSet<Vertex>();
        while (allVertices.hasNext()) {
            Vertex vertex = (Vertex)allVertices.next();
            if (category != null && !category.equals(vertex.getProperty("category")) || name != null && !name.equals(vertex.getProperty("name"))) continue;
            documentElementVertices.add(vertex);
        }
        return documentElementVertices;
    }

    private static Set<Vertex> getVerticesByCategory(Graph graph, String category) {
        return BaseGraphWriter.getVerticesByCategoryAndName(graph, category, null);
    }

    private static Set<Vertex> getDocumentElementVertices(Graph graph) {
        return BaseGraphWriter.getVerticesByCategory(graph, "documentelement");
    }

    private static void mergeOutputsAndInputs(Graph graph) {
        for (Vertex documentElementVertex : BaseGraphWriter.getDocumentElementVertices(graph)) {
            List<Vertex> inputFields = BaseGraphWriter.getLinkedVertices(documentElementVertex, Direction.IN, "inputs", "field", true, "Transformation Stream field", true);
            ArrayList<Vertex> orphanedInputFields = new ArrayList<Vertex>();
            for (Vertex inputField : inputFields) {
                if (inputField.getEdges(Direction.IN, new String[]{"outputs"}).iterator().hasNext()) continue;
                orphanedInputFields.add(inputField);
            }
            if (orphanedInputFields.size() <= 0) continue;
            List<Vertex> inputSteps = BaseGraphWriter.getLinkedVertices(documentElementVertex, Direction.IN, "hops_to", "documentelement", true, "Transformation Step", true);
            for (Vertex orphanedInputField : orphanedInputFields) {
                String orphanedInputFieldName = (String)orphanedInputField.getProperty("name");
                int matchCount = 0;
                for (Vertex inputStep : inputSteps) {
                    List<Vertex> inputStepOutputFields = BaseGraphWriter.getLinkedVertices(inputStep, Direction.OUT, "outputs", "field", true, "Transformation Stream field", true);
                    for (Vertex inputStepOutputField : inputStepOutputFields) {
                        String inputStepOutputFieldName = (String)inputStepOutputField.getProperty("name");
                        if (!inputStepOutputFieldName.equals(orphanedInputFieldName)) continue;
                        if (matchCount == 0) {
                            BaseGraphWriter.rewireEdges(graph, inputStepOutputField, orphanedInputField, Direction.IN);
                            BaseGraphWriter.rewireEdges(graph, inputStepOutputField, orphanedInputField, Direction.OUT);
                            orphanedInputField.remove();
                        } else {
                            String newLinkId = BaseMetaverseBuilder.getEdgeId((Vertex)inputStepOutputField, (String)"inputs", (Vertex)documentElementVertex);
                            graph.addEdge((Object)newLinkId, inputStepOutputField, documentElementVertex, "inputs").setProperty("text", (Object)"inputs");
                        }
                        ++matchCount;
                    }
                }
            }
        }
    }

    private static void deduplicateTransFields(Graph graph) {
        for (Vertex documentElementVertex : BaseGraphWriter.getDocumentElementVertices(graph)) {
            BaseGraphWriter.mergeFields(graph, documentElementVertex, Direction.OUT, "outputs", true);
        }
    }

    private static void mergeFields(Graph graph, Vertex documentElementVertex, Direction direction, String linkLabel, boolean isTransformationField) {
        List links = IteratorUtils.toList(documentElementVertex.getEdges(direction, new String[]{linkLabel}).iterator());
        HashMap<String, HashSet<Vertex>> fieldMap = new HashMap<String, HashSet<Vertex>>();
        for (Edge link : links) {
            Vertex vertex = link.getVertex(direction == Direction.IN ? Direction.OUT : Direction.IN);
            String category = (String)vertex.getProperty("category");
            String type = (String)vertex.getProperty("type");
            if (!"field".equals(category) || isTransformationField != "Transformation Stream field".equals(type)) continue;
            String fieldName = (String)vertex.getProperty("name");
            HashSet<Vertex> fieldsWithSameName = (HashSet<Vertex>)fieldMap.get(fieldName);
            if (fieldsWithSameName == null) {
                fieldsWithSameName = new HashSet<Vertex>();
                fieldMap.put(fieldName, fieldsWithSameName);
            }
            fieldsWithSameName.add(vertex);
        }
        List fields = IteratorUtils.toList(fieldMap.entrySet().iterator());
        for (Map.Entry fieldEntry : fields) {
            ArrayList fieldVertices = new ArrayList((Collection)fieldEntry.getValue());
            if (fieldVertices.size() <= 1) continue;
            Vertex fieldVertexToKeep = (Vertex)fieldVertices.get(0);
            for (int i = 1; i < fieldVertices.size(); ++i) {
                Vertex fieldVertexToMerge = (Vertex)fieldVertices.get(i);
                BaseGraphWriter.rewireEdges(graph, fieldVertexToKeep, fieldVertexToMerge, Direction.IN);
                BaseGraphWriter.rewireEdges(graph, fieldVertexToKeep, fieldVertexToMerge, Direction.OUT);
                fieldVertexToMerge.remove();
            }
        }
    }

    private static void rewireEdges(Graph graph, Vertex vertexToKeep, Vertex vertexToMerge, Direction direction) {
        for (Edge originalLink : vertexToMerge.getEdges(direction, new String[0])) {
            String newLinkId;
            String string = newLinkId = direction == Direction.OUT ? BaseMetaverseBuilder.getEdgeId((Vertex)vertexToKeep, (String)originalLink.getLabel(), (Vertex)originalLink.getVertex(Direction.IN)) : BaseMetaverseBuilder.getEdgeId((Vertex)originalLink.getVertex(Direction.OUT), (String)originalLink.getLabel(), (Vertex)vertexToKeep);
            if (graph.getEdge((Object)newLinkId) == null) {
                if (direction == Direction.OUT) {
                    graph.addEdge((Object)newLinkId, vertexToKeep, originalLink.getVertex(Direction.IN), originalLink.getLabel()).setProperty("text", (Object)originalLink.getLabel());
                } else {
                    graph.addEdge((Object)newLinkId, originalLink.getVertex(Direction.OUT), vertexToKeep, originalLink.getLabel()).setProperty("text", (Object)originalLink.getLabel());
                }
            }
            originalLink.remove();
        }
    }

    private static Set<Vertex> getCollectionVertices(Graph graph) {
        return BaseGraphWriter.getVerticesByCategory(graph, "collection");
    }

    private static Set<Vertex> getSQLVertices(Graph graph) {
        return BaseGraphWriter.getVerticesByCategoryAndName(graph, "other", "SQL");
    }

    private static Set<Vertex> getExternalResourceVertices(Graph graph) {
        Set<Vertex> externalResourceVertexSet = BaseGraphWriter.getCollectionVertices(graph);
        externalResourceVertexSet.addAll(BaseGraphWriter.getSQLVertices(graph));
        return externalResourceVertexSet;
    }

    private static List<Vertex> getLinkedVertices(Vertex originVertex, Direction edgeDirection, String edgeLabel, String linkedVertexCategory, boolean equalToCategory, String linkedVertexType, boolean equalToType) {
        ArrayList<Vertex> linkedVertices = new ArrayList<Vertex>();
        for (Edge link : originVertex.getEdges(edgeDirection, new String[]{edgeLabel})) {
            Vertex vertex = link.getVertex(edgeDirection == Direction.IN ? Direction.OUT : Direction.IN);
            String category = (String)vertex.getProperty("category");
            String type = (String)vertex.getProperty("type");
            if (linkedVertexCategory != null && (category == null || equalToCategory != category.equals(linkedVertexCategory)) || linkedVertexType != null && (type == null || equalToType != type.equals(linkedVertexType))) continue;
            linkedVertices.add(vertex);
        }
        return linkedVertices;
    }

    private static List<Vertex> getStepInputExternalResourceFields(Vertex stepVertex) {
        return BaseGraphWriter.getLinkedVertices(stepVertex, Direction.IN, "inputs", "field", true, "Transformation Stream field", false);
    }

    private static List<Vertex> getStepOutputExternalResourceFields(Vertex stepVertex) {
        return BaseGraphWriter.getLinkedVertices(stepVertex, Direction.OUT, "outputs", "field", true, "Transformation Stream field", false);
    }

    private static List<Vertex> getStepsReadingExternalResource(Vertex extenralResourceVertex) {
        return BaseGraphWriter.getLinkedVertices(extenralResourceVertex, Direction.OUT, "isreadby", "documentelement", true, null, false);
    }

    private static List<Vertex> getStepsWritingToExternalResource(Vertex extenralResourceVertex) {
        return BaseGraphWriter.getLinkedVertices(extenralResourceVertex, Direction.IN, "writesto", "documentelement", true, null, false);
    }

    private static void addExternalResourceContainsFieldsLinks(Graph graph) {
        for (Vertex externalResourceVertex : BaseGraphWriter.getExternalResourceVertices(graph)) {
            List<Vertex> fieldVertices;
            List<Vertex> stepVertices = BaseGraphWriter.getStepsReadingExternalResource(externalResourceVertex);
            for (Vertex stepVertex : stepVertices) {
                fieldVertices = BaseGraphWriter.getStepInputExternalResourceFields(stepVertex);
                BaseGraphWriter.addContainsLinks(graph, externalResourceVertex, fieldVertices);
            }
            stepVertices = BaseGraphWriter.getStepsWritingToExternalResource(externalResourceVertex);
            for (Vertex stepVertex : stepVertices) {
                fieldVertices = BaseGraphWriter.getStepOutputExternalResourceFields(stepVertex);
                BaseGraphWriter.addContainsLinks(graph, externalResourceVertex, fieldVertices);
            }
        }
    }

    private static void addContainsLinks(Graph graph, Vertex externalResourceVertex, List<Vertex> fieldVertices) {
        for (Vertex fieldVertex : fieldVertices) {
            String newLinkId = BaseMetaverseBuilder.getEdgeId((Vertex)externalResourceVertex, (String)"contains", (Vertex)fieldVertex);
            if (graph.getEdge((Object)newLinkId) != null) continue;
            graph.addEdge((Object)newLinkId, externalResourceVertex, fieldVertex, "contains").setProperty("text", (Object)"contains");
        }
    }

    private static void deduplicateExternalResourceFields(Graph graph) {
        for (Vertex vertex : BaseGraphWriter.getExternalResourceVertices(graph)) {
            BaseGraphWriter.mergeFields(graph, vertex, Direction.OUT, "contains", false);
        }
    }
}

