/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas.policies;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.quotas.SpaceLimitingException;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.quotas.policies.AbstractViolationPolicyEnforcement;

public class DisableTableViolationPolicyEnforcement
extends AbstractViolationPolicyEnforcement {
    private static final Log LOG = LogFactory.getLog(DisableTableViolationPolicyEnforcement.class);

    @Override
    public void enable() throws IOException {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Starting disable of " + this.getTableName()));
            }
            this.getRegionServerServices().getConnection().getAdmin().disableTable(this.getTableName());
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Disable is complete for " + this.getTableName()));
            }
        }
        catch (TableNotEnabledException tableNotEnabledException) {
            // empty catch block
        }
    }

    @Override
    public void disable() throws IOException {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Starting enable of " + this.getTableName()));
            }
            this.getRegionServerServices().getConnection().getAdmin().enableTable(this.getTableName());
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Enable is complete for " + this.getTableName()));
            }
        }
        catch (TableNotDisabledException tableNotDisabledException) {
            // empty catch block
        }
    }

    @Override
    public void check(Mutation m) throws SpaceLimitingException {
        throw new SpaceLimitingException(this.getPolicyName(), "This table is disabled due to violating a space quota.");
    }

    @Override
    public String getPolicyName() {
        return SpaceViolationPolicy.DISABLE.name();
    }
}

