/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.database.service;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.pentaho.database.IDatabaseDialect;
import org.pentaho.database.IDatabaseDialectProvider;
import org.pentaho.database.IDriverLocator;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.model.IDatabaseType;
import org.pentaho.database.service.IDatabaseDialectService;
import org.pentaho.database.util.ClassUtil;

public class DatabaseDialectService
implements IDatabaseDialectService {
    private static final List<IDatabaseDialectProvider> providers = Collections.unmodifiableList(StreamSupport.stream(ServiceLoader.load(IDatabaseDialectProvider.class, DatabaseDialectService.class.getClassLoader()).spliterator(), false).collect(Collectors.toList()));
    private final boolean isOnlyReturnAvailable;

    public DatabaseDialectService() {
        this(true);
    }

    public DatabaseDialectService(boolean validateClasses) {
        this.isOnlyReturnAvailable = validateClasses;
    }

    @Override
    public void registerDatabaseDialect(IDatabaseDialect databaseDialect) {
    }

    @Override
    public void registerDatabaseDialect(IDatabaseDialect databaseDialect, boolean validateClassExists) {
    }

    @Override
    public boolean validateJdbcDriverClassExists(String classname) {
        return ClassUtil.canLoadClass(classname) || providers.stream().flatMap(provider -> provider.getDialects(this.isOnlyReturnAvailable).stream()).filter(dialect -> classname.equals(dialect.getNativeDriver())).filter(dialect -> dialect instanceof IDriverLocator && ((IDriverLocator)((Object)dialect)).isUsable()).findFirst().isPresent();
    }

    @Override
    public List<IDatabaseType> getDatabaseTypes() {
        return providers.stream().flatMap(provider -> provider.getDialects(this.isOnlyReturnAvailable).stream()).map(IDatabaseDialect::getDatabaseType).collect(Collectors.toList());
    }

    @Override
    public IDatabaseDialect getDialect(IDatabaseType databaseType) {
        return providers.stream().map(provider -> provider.getDialect(this.isOnlyReturnAvailable, databaseType)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    public IDatabaseDialect getDialect(IDatabaseConnection connection) {
        return this.getDialect(connection.getDatabaseType());
    }

    @Override
    public List<IDatabaseDialect> getDatabaseDialects() {
        return providers.stream().flatMap(provider -> provider.getDialects(this.isOnlyReturnAvailable).stream()).collect(Collectors.toList());
    }
}

