/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.Category;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.Resolver;
import mondrian.olap.type.BooleanType;
import mondrian.olap.type.CubeType;
import mondrian.olap.type.DateTimeType;
import mondrian.olap.type.DecimalType;
import mondrian.olap.type.DimensionType;
import mondrian.olap.type.EmptyType;
import mondrian.olap.type.HierarchyType;
import mondrian.olap.type.LevelType;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.NullType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.ScalarType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.SymbolType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;

public class TypeUtil {
    public static Type stripSetType(Type type) {
        while (type instanceof SetType) {
            type = ((SetType)type).getElementType();
        }
        return type;
    }

    public static Type toMemberOrTupleType(Type type) {
        if ((type = TypeUtil.stripSetType(type)) instanceof TupleType) {
            return type;
        }
        return TypeUtil.toMemberType(type);
    }

    public static MemberType toMemberType(Type type) {
        if ((type = TypeUtil.stripSetType(type)) instanceof MemberType) {
            return (MemberType)type;
        }
        if (type instanceof DimensionType || type instanceof HierarchyType || type instanceof LevelType) {
            return MemberType.forType(type);
        }
        return null;
    }

    public static boolean isUnionCompatible(Type type1, Type type2) {
        if (type1 instanceof TupleType) {
            TupleType tupleType1 = (TupleType)type1;
            if (type2 instanceof TupleType) {
                TupleType tupleType2 = (TupleType)type2;
                if (tupleType1.elementTypes.length == tupleType2.elementTypes.length) {
                    for (int i = 0; i < tupleType1.elementTypes.length; ++i) {
                        if (TypeUtil.isUnionCompatible(tupleType1.elementTypes[i], tupleType2.elementTypes[i])) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
        MemberType memberType1 = TypeUtil.toMemberType(type1);
        if (memberType1 == null) {
            return false;
        }
        MemberType memberType2 = TypeUtil.toMemberType(type2);
        if (memberType2 == null) {
            return false;
        }
        Hierarchy hierarchy1 = memberType1.getHierarchy();
        Hierarchy hierarchy2 = memberType2.getHierarchy();
        return TypeUtil.equal(hierarchy1, hierarchy2);
    }

    private static boolean equal(Hierarchy hierarchy1, Hierarchy hierarchy2) {
        return hierarchy1 == null || hierarchy2 == null || hierarchy2.getUniqueName().equals(hierarchy1.getUniqueName());
    }

    public static boolean canEvaluate(Type type) {
        return !(type instanceof SetType) && !(type instanceof CubeType) && !(type instanceof LevelType);
    }

    public static boolean isSet(Type type) {
        return type instanceof SetType;
    }

    public static boolean couldBeMember(Type type) {
        return type instanceof MemberType || type instanceof HierarchyType || type instanceof DimensionType;
    }

    public static int typeToCategory(Type type) {
        if (type instanceof NullType) {
            return 16;
        }
        if (type instanceof EmptyType) {
            return 17;
        }
        if (type instanceof DateTimeType) {
            return 18;
        }
        if (type instanceof DecimalType && ((DecimalType)type).getScale() == 0) {
            return 15;
        }
        if (type instanceof NumericType) {
            return 7;
        }
        if (type instanceof BooleanType) {
            return 5;
        }
        if (type instanceof DimensionType) {
            return 2;
        }
        if (type instanceof HierarchyType) {
            return 3;
        }
        if (type instanceof MemberType) {
            return 6;
        }
        if (type instanceof LevelType) {
            return 4;
        }
        if (type instanceof SymbolType) {
            return 11;
        }
        if (type instanceof StringType) {
            return 9;
        }
        if (type instanceof ScalarType) {
            return 13;
        }
        if (type instanceof SetType) {
            return 8;
        }
        if (type instanceof TupleType) {
            return 10;
        }
        throw Util.newInternal("Unknown type " + type);
    }

    public static Type computeCommonType(boolean allowConversions, Type ... types) {
        int[] nArray;
        if (types.length == 0) {
            return null;
        }
        Type type = types[0];
        if (allowConversions) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            nArray = null;
        }
        int[] conversionCount = nArray;
        for (int i = 1; i < types.length; ++i) {
            if (type == null) {
                return null;
            }
            type = type.computeCommonType(types[i], conversionCount);
        }
        return type;
    }

    public static boolean canConvert(int ordinal, Type fromType, int to, List<Resolver.Conversion> conversions) {
        int from = TypeUtil.typeToCategory(fromType);
        if (from == to) {
            return true;
        }
        RuntimeException e = null;
        switch (from) {
            case 1: {
                return false;
            }
            case 2: {
                switch (to) {
                    case 3: 
                    case 6: 
                    case 10: {
                        conversions.add(new ConversionImpl(from, to, ordinal, 2, e));
                        return true;
                    }
                    case 4: {
                        conversions.add(new ConversionImpl(from, to, ordinal, 3, null));
                        return true;
                    }
                }
                return false;
            }
            case 3: {
                switch (to) {
                    case 2: 
                    case 6: 
                    case 10: {
                        conversions.add(new ConversionImpl(from, to, ordinal, 1, null));
                        return true;
                    }
                }
                return false;
            }
            case 4: {
                switch (to) {
                    case 2: {
                        conversions.add(new ConversionImpl(from, to, ordinal, 2, null));
                        return true;
                    }
                    case 3: {
                        conversions.add(new ConversionImpl(from, to, ordinal, 1, null));
                        return true;
                    }
                }
                return false;
            }
            case 5: {
                switch (to) {
                    case 13: {
                        return true;
                    }
                }
                return false;
            }
            case 6: {
                switch (to) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 10: {
                        conversions.add(new ConversionImpl(from, to, ordinal, 1, null));
                        return true;
                    }
                    case 8: {
                        conversions.add(new ConversionImpl(from, to, ordinal, 2, null));
                        return true;
                    }
                    case 7: {
                        conversions.add(new ConversionImpl(from, to, ordinal, 3, null));
                        return true;
                    }
                    case 9: 
                    case 13: {
                        conversions.add(new ConversionImpl(from, to, ordinal, 4, null));
                        return true;
                    }
                }
                return false;
            }
            case 71: {
                switch (to) {
                    case 7: 
                    case 13: {
                        return true;
                    }
                }
                return false;
            }
            case 7: {
                switch (to) {
                    case 5: {
                        conversions.add(new ConversionImpl(from, to, ordinal, 2, null));
                        return true;
                    }
                    case 13: 
                    case 15: 
                    case 71: 
                    case 79: {
                        return true;
                    }
                }
                return false;
            }
            case 15: {
                switch (to) {
                    case 7: 
                    case 13: 
                    case 71: 
                    case 79: {
                        return true;
                    }
                }
                return false;
            }
            case 8: {
                return false;
            }
            case 73: {
                switch (to) {
                    case 9: 
                    case 13: {
                        return true;
                    }
                }
                return false;
            }
            case 9: {
                switch (to) {
                    case 13: 
                    case 73: {
                        return true;
                    }
                }
                return false;
            }
            case 82: {
                switch (to) {
                    case 13: 
                    case 18: {
                        return true;
                    }
                }
                return false;
            }
            case 18: {
                switch (to) {
                    case 13: 
                    case 82: {
                        return true;
                    }
                }
                return false;
            }
            case 10: {
                switch (to) {
                    case 8: {
                        conversions.add(new ConversionImpl(from, to, ordinal, 2, null));
                        return true;
                    }
                    case 7: {
                        conversions.add(new ConversionImpl(from, to, ordinal, 3, null));
                        return true;
                    }
                    case 9: 
                    case 13: {
                        conversions.add(new ConversionImpl(from, to, ordinal, 4, null));
                        return true;
                    }
                }
                return false;
            }
            case 13: {
                switch (to) {
                    case 5: 
                    case 7: 
                    case 9: {
                        conversions.add(new ConversionImpl(from, to, ordinal, 2, null));
                        return true;
                    }
                }
                return false;
            }
            case 11: {
                return false;
            }
            case 16: {
                if (Category.isScalar(to)) {
                    return true;
                }
                if (to == 6) {
                    conversions.add(new ConversionImpl(from, to, ordinal, 2, null));
                    return true;
                }
                return false;
            }
            case 17: {
                return false;
            }
        }
        throw Util.newInternal("unknown category " + from + " for type " + fromType);
    }

    static <T> T neq(T t1, T t2) {
        return (T)(t1 == null ? t2 : (t2 == null ? t1 : (t1.equals(t2) ? t1 : null)));
    }

    public static List<Hierarchy> getHierarchies(Type type) {
        if (type instanceof SetType) {
            type = ((SetType)type).getElementType();
        }
        if (type instanceof TupleType) {
            TupleType tupleType = (TupleType)type;
            ArrayList<Hierarchy> hierarchyList = new ArrayList<Hierarchy>();
            for (Type elementType : tupleType.elementTypes) {
                hierarchyList.add(elementType.getHierarchy());
            }
            return hierarchyList;
        }
        Hierarchy hierarchy = type.getHierarchy();
        return hierarchy == null ? Collections.emptyList() : Collections.singletonList(hierarchy);
    }

    private static class ConversionImpl
    implements Resolver.Conversion {
        final int from;
        final int to;
        final int ordinal;
        final int cost;
        final RuntimeException e;

        public ConversionImpl(int from, int to, int ordinal, int cost, RuntimeException e) {
            this.from = from;
            this.to = to;
            this.ordinal = ordinal;
            this.cost = cost;
            this.e = e;
        }

        @Override
        public int getCost() {
            return this.cost;
        }

        @Override
        public void checkValid() {
            if (this.e != null) {
                throw this.e;
            }
        }

        @Override
        public void apply(Validator validator, List<Exp> args) {
            Exp arg = args.get(this.ordinal);
            block0 : switch (this.from) {
                case 6: 
                case 10: {
                    switch (this.to) {
                        case 8: {
                            Exp newArg = validator.validate(new UnresolvedFunCall("{}", Syntax.Braces, new Exp[]{arg}), false);
                            args.set(this.ordinal, newArg);
                            break block0;
                        }
                    }
                }
            }
        }

        public String toString() {
            return "Conversion(from=" + Category.instance().getName(this.from) + ", to=" + Category.instance().getName(this.to) + ", ordinal=" + this.ordinal + ", cost=" + this.cost + ", e=" + this.e + ")";
        }
    }
}

