/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import mondrian.olap.Util;
import mondrian.rolap.SqlStatement;
import mondrian.spi.Dialect;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.JdbcDialectImpl;

public class MonetDbDialect
extends JdbcDialectImpl {
    private static final String DOT = "\\.";
    public static final JdbcDialectFactory FACTORY = new JdbcDialectFactory(MonetDbDialect.class, Dialect.DatabaseProduct.MONETDB);

    public MonetDbDialect(Connection connection) throws SQLException {
        super(connection);
    }

    public MonetDbDialect() {
    }

    @Override
    public boolean allowsMultipleDistinctSqlMeasures() {
        return false;
    }

    @Override
    public boolean allowsCountDistinct() {
        return this.compareVersions(this.productVersion, "11.5.7") >= 0;
    }

    @Override
    public boolean allowsCountDistinctWithOtherAggs() {
        return false;
    }

    @Override
    public boolean allowsMultipleCountDistinct() {
        return false;
    }

    @Override
    public boolean requiresAliasForFromQuery() {
        return true;
    }

    @Override
    public boolean allowsCompoundCountDistinct() {
        return false;
    }

    @Override
    public boolean supportsGroupByExpressions() {
        return false;
    }

    @Override
    public void quoteStringLiteral(StringBuilder buf, String s) {
        buf.append('\'');
        String s0 = Util.replace(s, "'", "''");
        String s1 = Util.replace(s0, "\\", "\\\\");
        buf.append(s1);
        buf.append('\'');
    }

    @Override
    public SqlStatement.Type getType(ResultSetMetaData metaData, int columnIndex) throws SQLException {
        int columnType = metaData.getColumnType(columnIndex + 1);
        int precision = metaData.getPrecision(columnIndex + 1);
        int scale = metaData.getScale(columnIndex + 1);
        if (columnType == 2 || columnType == 3) {
            if (scale == 0 && precision == 0) {
                this.logTypeInfo(metaData, columnIndex, SqlStatement.Type.DOUBLE);
                return SqlStatement.Type.DOUBLE;
            }
        } else if (columnType == 16) {
            return SqlStatement.Type.OBJECT;
        }
        return super.getType(metaData, columnIndex);
    }

    public int compareVersions(String v1, String v2) {
        int result = v1.compareTo(v2);
        if (result == 0) {
            return result;
        }
        String[] parts1 = v1.split(DOT);
        String[] parts2 = v2.split(DOT);
        int partsCount = Math.min(parts1.length, parts2.length);
        for (int i = 0; i < partsCount; ++i) {
            result = Integer.valueOf(parts1[i]).compareTo(Integer.valueOf(parts2[i]));
            if (result == 0) continue;
            return result;
        }
        result = parts1.length - parts2.length;
        return result;
    }
}

