/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metastore.stores.memory;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.metastore.api.IMetaStoreElement;
import org.pentaho.metastore.api.IMetaStoreElementType;
import org.pentaho.metastore.api.security.IMetaStoreElementOwner;
import org.pentaho.metastore.api.security.MetaStoreOwnerPermissions;
import org.pentaho.metastore.stores.memory.MemoryMetaStoreAttribute;
import org.pentaho.metastore.stores.xml.XmlMetaStoreElementOwner;

public class MemoryMetaStoreElement
extends MemoryMetaStoreAttribute
implements IMetaStoreElement {
    protected String name;
    protected IMetaStoreElementType elementType;
    protected IMetaStoreElementOwner owner;
    protected List<MetaStoreOwnerPermissions> ownerPermissionsList;

    public MemoryMetaStoreElement() {
        this(null, null, null);
    }

    public MemoryMetaStoreElement(IMetaStoreElementType elementType, String id, Object value) {
        super(id, value);
        this.elementType = elementType;
        this.ownerPermissionsList = new ArrayList<MetaStoreOwnerPermissions>();
    }

    public MemoryMetaStoreElement(IMetaStoreElement element) {
        super(element);
        this.name = element.getName();
        this.elementType = element.getElementType();
        this.ownerPermissionsList = new ArrayList<MetaStoreOwnerPermissions>();
        if (element.getOwner() != null) {
            this.owner = new XmlMetaStoreElementOwner(element.getOwner());
        }
        for (MetaStoreOwnerPermissions ownerPermissions : element.getOwnerPermissionsList()) {
            this.getOwnerPermissionsList().add(new MetaStoreOwnerPermissions(ownerPermissions.getOwner(), ownerPermissions.getPermissions()));
        }
    }

    @Override
    public IMetaStoreElementOwner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(IMetaStoreElementOwner owner) {
        this.owner = owner;
    }

    @Override
    public List<MetaStoreOwnerPermissions> getOwnerPermissionsList() {
        return this.ownerPermissionsList;
    }

    @Override
    public void setOwnerPermissionsList(List<MetaStoreOwnerPermissions> ownerPermissions) {
        this.ownerPermissionsList = ownerPermissions;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public IMetaStoreElementType getElementType() {
        return this.elementType;
    }

    @Override
    public void setElementType(IMetaStoreElementType elementType) {
        this.elementType = elementType;
    }
}

