/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.BackupType;
import org.apache.hadoop.hbase.backup.HBackupFileSystem;
import org.apache.hadoop.hbase.backup.RestoreClient;
import org.apache.hadoop.hbase.backup.impl.BackupManifest;
import org.apache.hadoop.hbase.backup.impl.BackupSystemTable;
import org.apache.hadoop.hbase.backup.mapreduce.MapReduceRestoreService;
import org.apache.hadoop.hbase.backup.util.BackupClientUtil;
import org.apache.hadoop.hbase.backup.util.RestoreServerUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class RestoreClientImpl
implements RestoreClient {
    private static final Log LOG = LogFactory.getLog(RestoreClientImpl.class);
    private Configuration conf;
    private String fullBackupId;

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public void restore(String backupRootDir, String backupId, boolean check, TableName[] sTableArray, TableName[] tTableArray, boolean isOverwrite) throws IOException {
        HashMap<TableName, BackupManifest> backupManifestMap = new HashMap<TableName, BackupManifest>();
        Path rootPath = new Path(backupRootDir);
        HBackupFileSystem.checkImageManifestExist(backupManifestMap, sTableArray, this.conf, rootPath, backupId);
        try {
            if (check) {
                if (this.validate(backupManifestMap)) {
                    LOG.info((Object)"Checking backup images: ok");
                } else {
                    String errMsg = "Some dependencies are missing for restore";
                    LOG.error((Object)errMsg);
                    throw new IOException(errMsg);
                }
            }
            if (tTableArray == null) {
                tTableArray = sTableArray;
            }
            this.checkTargetTables(tTableArray, isOverwrite);
            this.restoreStage(backupId, backupManifestMap, sTableArray, tTableArray, isOverwrite);
            LOG.info((Object)("Restore for " + Arrays.asList(sTableArray) + " are successful!"));
        }
        catch (IOException e) {
            LOG.error((Object)("ERROR: restore failed with error: " + e.getMessage()));
            throw e;
        }
    }

    private boolean validate(HashMap<TableName, BackupManifest> backupManifestMap) throws IOException {
        boolean isValid = true;
        block0: for (Map.Entry<TableName, BackupManifest> manifestEntry : backupManifestMap.entrySet()) {
            TableName table = manifestEntry.getKey();
            TreeSet<BackupManifest.BackupImage> imageSet = new TreeSet<BackupManifest.BackupImage>();
            ArrayList<BackupManifest.BackupImage> depList = manifestEntry.getValue().getDependentListByTable(table);
            if (depList != null && !depList.isEmpty()) {
                imageSet.addAll(depList);
            }
            LOG.info((Object)"Dependent image(s) from old to new:");
            for (BackupManifest.BackupImage image : imageSet) {
                String imageDir = HBackupFileSystem.getTableBackupDir(image.getRootDir(), image.getBackupId(), table);
                if (!BackupClientUtil.checkPathExist((String)imageDir, (Configuration)this.conf)) {
                    LOG.error((Object)("ERROR: backup image does not exist: " + imageDir));
                    isValid = false;
                    continue block0;
                }
                LOG.info((Object)("Backup image: " + image.getBackupId() + " for '" + table + "' is available"));
            }
        }
        return isValid;
    }

    private void checkTargetTables(TableName[] tTableArray, boolean isOverwrite) throws IOException {
        ArrayList<TableName> existTableList = new ArrayList<TableName>();
        ArrayList<TableName> disabledTableList = new ArrayList<TableName>();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)this.conf);
             Admin admin = conn.getAdmin();){
            for (TableName tableName : tTableArray) {
                if (admin.tableExists(tableName)) {
                    existTableList.add(tableName);
                    if (!admin.isTableDisabled(tableName)) continue;
                    disabledTableList.add(tableName);
                    continue;
                }
                LOG.info((Object)("HBase table " + tableName + " does not exist. It will be created during restore process"));
            }
        }
        if (existTableList.size() > 0) {
            if (!isOverwrite) {
                LOG.error((Object)"Existing table found in the restore target, please add \"-overwrite\" option in the command if you mean to restore to these existing tables");
                LOG.info((Object)("Existing table list in restore target: " + existTableList));
                throw new IOException("Existing table found in target while no \"-overwrite\" option found");
            }
            if (disabledTableList.size() > 0) {
                LOG.error((Object)"Found offline table in the restore target, please enable them before restore with \"-overwrite\" option");
                LOG.info((Object)("Offline table list in restore target: " + disabledTableList));
                throw new IOException("Found offline table in the target when restore with \"-overwrite\" option");
            }
        }
    }

    private void restoreStage(String backupId, HashMap<TableName, BackupManifest> backupManifestMap, TableName[] sTableArray, TableName[] tTableArray, boolean isOverwrite) throws IOException {
        TreeSet restoreImageSet = new TreeSet();
        boolean truncateIfExists = isOverwrite;
        try {
            HashSet<String> backupIdSet = new HashSet<String>();
            for (int i = 0; i < sTableArray.length; ++i) {
                TableName table = sTableArray[i];
                BackupManifest manifest = backupManifestMap.get(table);
                ArrayList<BackupManifest.BackupImage> list = new ArrayList<BackupManifest.BackupImage>();
                list.add(manifest.getBackupImage());
                ArrayList<BackupManifest.BackupImage> depList = manifest.getDependentListByTable(table);
                list.addAll(depList);
                TreeSet restoreList = new TreeSet(list);
                LOG.debug((Object)"need to clear merged Image. to be implemented in future jira");
                this.restoreImages(restoreList.iterator(), table, tTableArray[i], truncateIfExists);
                restoreImageSet.addAll(restoreList);
                if (restoreImageSet == null || restoreImageSet.isEmpty()) continue;
                LOG.info((Object)"Restore includes the following image(s):");
                for (BackupManifest.BackupImage image : restoreImageSet) {
                    LOG.info((Object)("Backup: " + image.getBackupId() + " " + HBackupFileSystem.getTableBackupDir(image.getRootDir(), image.getBackupId(), table)));
                    if (image.getType() != BackupType.INCREMENTAL) continue;
                    backupIdSet.add(image.getBackupId());
                    LOG.debug((Object)("adding " + image.getBackupId() + " for bulk load"));
                }
            }
            try (Connection conn = ConnectionFactory.createConnection((Configuration)this.conf);
                 BackupSystemTable table = new BackupSystemTable(conn);){
                List<TableName> sTableList = Arrays.asList(sTableArray);
                for (String id : backupIdSet) {
                    LOG.debug((Object)("restoring bulk load for " + id));
                    Map[] mapForSrc = table.readBulkLoadedFiles(id, sTableList);
                    this.conf.setBoolean("always.copy.files", true);
                    LoadIncrementalHFiles loader = MapReduceRestoreService.createLoader(this.conf);
                    for (int i = 0; i < sTableList.size(); ++i) {
                        if (mapForSrc[i] == null || mapForSrc[i].isEmpty()) continue;
                        Map<LoadIncrementalHFiles.LoadQueueItem, ByteBuffer> loaderResult = loader.run(null, mapForSrc[i], tTableArray[i]);
                        LOG.debug((Object)("bulk loading " + sTableList.get(i) + " to " + tTableArray[i]));
                        if (!loaderResult.isEmpty()) continue;
                        String msg = "Couldn't bulk load for " + sTableList.get(i) + " to " + tTableArray[i];
                        LOG.error((Object)msg);
                        throw new IOException(msg);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed", (Throwable)e);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
        LOG.debug((Object)"restoreStage finished");
    }

    static long getTsFromBackupId(String backupId) {
        if (backupId == null) {
            return 0L;
        }
        return Long.valueOf(backupId.substring(backupId.lastIndexOf("_") + 1));
    }

    static boolean withinRange(long a, long lower, long upper) {
        return a >= lower && a <= upper;
    }

    int getIndex(TableName tbl, List<TableName> sTableList) {
        for (int i = 0; i < sTableList.size(); ++i) {
            if (!tbl.equals((Object)sTableList.get(i))) continue;
            return i;
        }
        return -1;
    }

    private void restoreImages(Iterator<BackupManifest.BackupImage> it, TableName sTable, TableName tTable, boolean truncateIfExists) throws IOException {
        BackupManifest.BackupImage image = it.next();
        String rootDir = image.getRootDir();
        String backupId = image.getBackupId();
        Path backupRoot = new Path(rootDir);
        RestoreServerUtil restoreTool = new RestoreServerUtil(this.conf, backupRoot, backupId);
        BackupManifest manifest = HBackupFileSystem.getManifest(sTable, this.conf, backupRoot, backupId);
        Path tableBackupPath = HBackupFileSystem.getTableBackupPath(sTable, backupRoot, backupId);
        boolean converted = false;
        if (manifest.getType() == BackupType.FULL || converted) {
            if (manifest.getType() == BackupType.FULL) {
                this.fullBackupId = manifest.getBackupImage().getBackupId();
            }
        } else {
            throw new IOException("Unexpected backup type " + image.getType());
        }
        LOG.info((Object)("Restoring '" + sTable + "' to '" + tTable + "' from " + (converted ? "converted" : "full") + " backup image " + tableBackupPath.toString()));
        restoreTool.fullRestoreTable(tableBackupPath, sTable, tTable, converted, truncateIfExists);
        if (it.hasNext()) {
            ArrayList<String> fileDirList = new ArrayList<String>();
            while (it.hasNext()) {
                BackupManifest.BackupImage im = it.next();
                String fileBackupDir = HBackupFileSystem.getTableBackupDir(im.getRootDir(), im.getBackupId(), sTable) + "/" + "data";
                fileDirList.add(fileBackupDir);
            }
            String logDirs = StringUtils.join(fileDirList, (String)",");
            LOG.info((Object)("Restoring '" + sTable + "' to '" + tTable + "' from file dirs: " + logDirs));
            String[] sarr = new String[fileDirList.size()];
            fileDirList.toArray(sarr);
            Path[] paths = org.apache.hadoop.util.StringUtils.stringToPath((String[])sarr);
            restoreTool.incrementalRestoreTable(paths, new TableName[]{sTable}, new TableName[]{tTable});
        }
        LOG.info((Object)(sTable + " has been successfully restored to " + tTable));
    }
}

