/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
public class MasterMobCompactionThread {
    static final Log LOG = LogFactory.getLog(MasterMobCompactionThread.class);
    private final HMaster master;
    private final Configuration conf;
    private final ExecutorService mobCompactorPool;
    private final ExecutorService masterMobPool;

    public MasterMobCompactionThread(HMaster master) {
        this.master = master;
        this.conf = master.getConfiguration();
        final String n = Thread.currentThread().getName();
        this.masterMobPool = new ThreadPoolExecutor(1, 2, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName(n + "-MasterMobCompaction-" + EnvironmentEdgeManager.currentTime());
                return t;
            }
        });
        ((ThreadPoolExecutor)this.masterMobPool).allowCoreThreadTimeOut(true);
        this.mobCompactorPool = MobUtils.createMobCompactorThreadPool(master.getConfiguration());
    }

    public void requestMobCompaction(Configuration conf, FileSystem fs, TableName tableName, List<HColumnDescriptor> columns, TableLockManager tableLockManager, boolean allFiles) throws IOException {
        this.master.reportMobCompactionStart(tableName);
        try {
            this.masterMobPool.execute(new CompactionRunner(fs, tableName, columns, tableLockManager, allFiles, this.mobCompactorPool));
        }
        catch (RejectedExecutionException e) {
            try {
                this.master.reportMobCompactionEnd(tableName);
            }
            catch (IOException e1) {
                LOG.error((Object)"Failed to mark end of mob compation", (Throwable)e1);
            }
            throw e;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The mob compaction is requested for the columns " + columns + " of the table " + tableName.getNameAsString()));
        }
    }

    private void interruptIfNecessary() {
        this.mobCompactorPool.shutdown();
        this.masterMobPool.shutdown();
    }

    private void join() {
        this.waitFor(this.mobCompactorPool, "Mob Compaction Thread");
        this.waitFor(this.masterMobPool, "Region Server Mob Compaction Thread");
    }

    public void close() {
        this.interruptIfNecessary();
        this.join();
    }

    private void waitFor(ExecutorService t, String name) {
        boolean done = false;
        while (!done) {
            try {
                done = t.awaitTermination(60L, TimeUnit.SECONDS);
                LOG.info((Object)("Waiting for " + name + " to finish..."));
                if (done) continue;
                t.shutdownNow();
            }
            catch (InterruptedException ie) {
                LOG.warn((Object)("Interrupted waiting for " + name + " to finish..."));
            }
        }
    }

    private class CompactionRunner
    implements Runnable {
        private FileSystem fs;
        private TableName tableName;
        private List<HColumnDescriptor> hcds;
        private TableLockManager tableLockManager;
        private boolean allFiles;
        private ExecutorService pool;

        public CompactionRunner(FileSystem fs, TableName tableName, List<HColumnDescriptor> hcds, TableLockManager tableLockManager, boolean allFiles, ExecutorService pool) {
            this.fs = fs;
            this.tableName = tableName;
            this.hcds = hcds;
            this.tableLockManager = tableLockManager;
            this.allFiles = allFiles;
            this.pool = pool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                for (HColumnDescriptor hcd : this.hcds) {
                    MobUtils.doMobCompaction(MasterMobCompactionThread.this.conf, this.fs, this.tableName, hcd, this.pool, this.tableLockManager, this.allFiles);
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to perform the mob compaction", (Throwable)e);
            }
            finally {
                try {
                    MasterMobCompactionThread.this.master.reportMobCompactionEnd(this.tableName);
                }
                catch (IOException e) {
                    LOG.error((Object)"Failed to mark end of mob compation", (Throwable)e);
                }
            }
        }
    }
}

