/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.quotas.QuotaObserverChore;
import org.apache.hadoop.hbase.quotas.QuotaSnapshotStore;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;

public class NamespaceQuotaSnapshotStore
implements QuotaSnapshotStore<String> {
    private final Connection conn;
    private final QuotaObserverChore chore;
    private final Map<HRegionInfo, Long> regionUsage;

    public NamespaceQuotaSnapshotStore(Connection conn, QuotaObserverChore chore, Map<HRegionInfo, Long> regionUsage) {
        this.conn = Objects.requireNonNull(conn);
        this.chore = Objects.requireNonNull(chore);
        this.regionUsage = Objects.requireNonNull(regionUsage);
    }

    @Override
    public QuotaProtos.SpaceQuota getSpaceQuota(String namespace) throws IOException {
        QuotaProtos.Quotas quotas = this.getQuotaForNamespace(namespace);
        if (null != quotas && quotas.hasSpace()) {
            return quotas.getSpace();
        }
        return null;
    }

    QuotaProtos.Quotas getQuotaForNamespace(String namespace) throws IOException {
        return QuotaTableUtil.getNamespaceQuota((Connection)this.conn, (String)namespace);
    }

    @Override
    public SpaceQuotaSnapshot getCurrentState(String namespace) {
        return this.chore.getNamespaceQuotaViolation(namespace);
    }

    @Override
    public SpaceQuotaSnapshot getTargetState(String subject, QuotaProtos.SpaceQuota spaceQuota) {
        long sizeLimitInBytes = spaceQuota.getSoftLimit();
        long sum = 0L;
        for (Map.Entry<HRegionInfo, Long> entry : this.filterBySubject(subject)) {
            sum += entry.getValue().longValue();
        }
        SpaceQuotaSnapshot.SpaceQuotaStatus status = sum <= sizeLimitInBytes ? SpaceQuotaSnapshot.SpaceQuotaStatus.notInViolation() : new SpaceQuotaSnapshot.SpaceQuotaStatus(ProtobufUtil.toViolationPolicy((QuotaProtos.SpaceViolationPolicy)spaceQuota.getViolationPolicy()));
        return new SpaceQuotaSnapshot(status, sum, sizeLimitInBytes);
    }

    @Override
    public Iterable<Map.Entry<HRegionInfo, Long>> filterBySubject(final String namespace) {
        return Iterables.filter(this.regionUsage.entrySet(), (Predicate)new Predicate<Map.Entry<HRegionInfo, Long>>(){

            public boolean apply(Map.Entry<HRegionInfo, Long> input) {
                return namespace.equals(input.getKey().getTable().getNamespaceAsString());
            }
        });
    }

    @Override
    public void setCurrentState(String namespace, SpaceQuotaSnapshot snapshot) {
        this.chore.setNamespaceQuotaViolation(namespace, snapshot);
    }
}

