/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory;
import org.apache.hadoop.hbase.regionserver.MetricsUserAggregateSource;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;

public class MetricsUserAggregate {
    private final UserProvider userProvider;
    private final MetricsUserAggregateSource source = ((MetricsRegionServerSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class)).getUserAggregate();

    public MetricsUserAggregate(Configuration conf) {
        this.userProvider = UserProvider.instantiate((Configuration)conf);
    }

    private String getActiveUser() {
        User user = RpcServer.getRequestUser();
        if (user == null) {
            try {
                user = this.userProvider.getCurrent();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return user != null ? user.getShortName() : null;
    }

    @VisibleForTesting
    MetricsUserAggregateSource getSource() {
        return this.source;
    }

    public void updatePut(long t) {
        String user = this.getActiveUser();
        if (user != null) {
            this.source.getOrCreateMetricsUser(user).updatePut(t);
        }
    }

    public void updateDelete(long t) {
        String user = this.getActiveUser();
        if (user != null) {
            this.source.getOrCreateMetricsUser(user).updateDelete(t);
        }
    }

    public void updateGet(long t) {
        String user = this.getActiveUser();
        if (user != null) {
            this.source.getOrCreateMetricsUser(user).updateGet(t);
        }
    }

    public void updateIncrement(long t) {
        String user = this.getActiveUser();
        if (user != null) {
            this.source.getOrCreateMetricsUser(user).updateIncrement(t);
        }
    }

    public void updateAppend(long t) {
        String user = this.getActiveUser();
        if (user != null) {
            this.source.getOrCreateMetricsUser(user).updateAppend(t);
        }
    }

    public void updateReplay(long t) {
        String user = this.getActiveUser();
        if (user != null) {
            this.source.getOrCreateMetricsUser(user).updateReplay(t);
        }
    }

    public void updateScanTime(long t) {
        String user = this.getActiveUser();
        if (user != null) {
            this.source.getOrCreateMetricsUser(user).updateScanTime(t);
        }
    }
}

