/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import com.google.protobuf.Message;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class SplitOrMergeTracker {
    private String splitZnode;
    private String mergeZnode;
    private SwitchStateTracker splitStateTracker;
    private SwitchStateTracker mergeStateTracker;

    public SplitOrMergeTracker(ZooKeeperWatcher watcher, Configuration conf, Abortable abortable) {
        try {
            if (ZKUtil.checkExists((ZooKeeperWatcher)watcher, (String)watcher.getSwitchZNode()) < 0) {
                ZKUtil.createAndFailSilent((ZooKeeperWatcher)watcher, (String)watcher.getSwitchZNode());
            }
        }
        catch (KeeperException e) {
            throw new RuntimeException(e);
        }
        this.splitZnode = ZKUtil.joinZNode((String)watcher.getSwitchZNode(), (String)conf.get("zookeeper.znode.switch.split", "split"));
        this.mergeZnode = ZKUtil.joinZNode((String)watcher.getSwitchZNode(), (String)conf.get("zookeeper.znode.switch.merge", "merge"));
        this.splitStateTracker = new SwitchStateTracker(watcher, this.splitZnode, abortable);
        this.mergeStateTracker = new SwitchStateTracker(watcher, this.mergeZnode, abortable);
    }

    public void start() {
        this.splitStateTracker.start();
        this.mergeStateTracker.start();
    }

    public boolean isSplitOrMergeEnabled(Admin.MasterSwitchType switchType) {
        switch (switchType) {
            case SPLIT: {
                return this.splitStateTracker.isSwitchEnabled();
            }
            case MERGE: {
                return this.mergeStateTracker.isSwitchEnabled();
            }
        }
        return false;
    }

    public void setSplitOrMergeEnabled(boolean enabled, Admin.MasterSwitchType switchType) throws KeeperException {
        switch (switchType) {
            case SPLIT: {
                this.splitStateTracker.setSwitchEnabled(enabled);
                break;
            }
            case MERGE: {
                this.mergeStateTracker.setSwitchEnabled(enabled);
                break;
            }
        }
    }

    private static class SwitchStateTracker
    extends ZooKeeperNodeTracker {
        public SwitchStateTracker(ZooKeeperWatcher watcher, String node, Abortable abortable) {
            super(watcher, node, abortable);
        }

        public boolean isSwitchEnabled() {
            byte[] upData = super.getData(false);
            try {
                return upData == null || this.parseFrom(upData).getEnabled();
            }
            catch (DeserializationException dex) {
                LOG.error((Object)("ZK state for LoadBalancer could not be parsed " + Bytes.toStringBinary((byte[])upData)));
                return false;
            }
        }

        public void setSwitchEnabled(boolean enabled) throws KeeperException {
            byte[] upData = this.toByteArray(enabled);
            try {
                ZKUtil.setData((ZooKeeperWatcher)this.watcher, (String)this.node, (byte[])upData);
            }
            catch (KeeperException.NoNodeException nne) {
                ZKUtil.createAndWatch((ZooKeeperWatcher)this.watcher, (String)this.node, (byte[])upData);
            }
            super.nodeDataChanged(this.node);
        }

        private byte[] toByteArray(boolean enabled) {
            ZooKeeperProtos.SwitchState.Builder builder = ZooKeeperProtos.SwitchState.newBuilder();
            builder.setEnabled(enabled);
            return ProtobufUtil.prependPBMagic((byte[])builder.build().toByteArray());
        }

        private ZooKeeperProtos.SwitchState parseFrom(byte[] bytes) throws DeserializationException {
            ProtobufUtil.expectPBMagicPrefix((byte[])bytes);
            ZooKeeperProtos.SwitchState.Builder builder = ZooKeeperProtos.SwitchState.newBuilder();
            try {
                int magicLen = ProtobufUtil.lengthOfPBMagic();
                ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])bytes, (int)magicLen, (int)(bytes.length - magicLen));
            }
            catch (IOException e) {
                throw new DeserializationException((Throwable)e);
            }
            return builder.build();
        }
    }
}

