/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cli;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.llap.cli.LlapStatusServiceDriver;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.client.ServiceClient;
import org.apache.hadoop.yarn.service.utils.CoreFileSystem;
import org.apache.hadoop.yarn.util.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapSliderUtils {
    private static final Logger LOG = LoggerFactory.getLogger(LlapSliderUtils.class);
    private static final String LLAP_PACKAGE_DIR = ".yarn/package/LLAP/";

    public static ServiceClient createServiceClient(Configuration conf) throws Exception {
        ServiceClient serviceClient = new ServiceClient();
        serviceClient.init(conf);
        serviceClient.start();
        return serviceClient;
    }

    public static ApplicationReport getAppReport(String appName, ServiceClient serviceClient, long timeoutMs) throws LlapStatusServiceDriver.LlapStatusCliException {
        ApplicationId appId;
        SystemClock clock = SystemClock.getInstance();
        long startTime = clock.getTime();
        long timeoutTime = timeoutMs < 0L ? Long.MAX_VALUE : startTime + timeoutMs;
        ApplicationReport appReport = null;
        try {
            appId = serviceClient.getAppId(appName);
        }
        catch (IOException | YarnException e) {
            return null;
        }
        while (appReport == null) {
            try {
                appReport = serviceClient.getYarnClient().getApplicationReport(appId);
                if (timeoutMs == 0L) break;
                if (appReport != null) continue;
                long remainingTime = Math.min(timeoutTime - clock.getTime(), 500L);
                if (remainingTime <= 0L) break;
                Thread.sleep(remainingTime);
            }
            catch (Exception e) {
                throw new LlapStatusServiceDriver.LlapStatusCliException(LlapStatusServiceDriver.ExitCode.YARN_ERROR, "Failed to get Yarn AppReport", e);
            }
        }
        return appReport;
    }

    public static Service getService(Configuration conf, String name) {
        ServiceClient sc;
        LOG.info("Get service details for " + name);
        try {
            sc = LlapSliderUtils.createServiceClient(conf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Service service = null;
        try {
            service = sc.getStatus(name);
        }
        catch (IOException | YarnException e) {
            LOG.info(e.getLocalizedMessage());
            throw new RuntimeException(e);
        }
        finally {
            try {
                sc.close();
            }
            catch (IOException e) {
                LOG.info("Failed to close service client", (Throwable)e);
            }
        }
        return service;
    }

    public static void startCluster(Configuration conf, String name, String packageName, Path packageDir, String queue) {
        ServiceClient sc;
        LOG.info("Starting cluster with " + name + ", " + packageName + ", " + queue + ", " + packageDir);
        try {
            sc = LlapSliderUtils.createServiceClient(conf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            try {
                LOG.info("Executing the stop command");
                sc.actionStop(name, true);
            }
            catch (Exception ex) {
                LOG.info(ex.getLocalizedMessage());
            }
            try {
                LOG.info("Executing the destroy command");
                sc.actionDestroy(name);
            }
            catch (Exception ex) {
                LOG.info(ex.getLocalizedMessage());
            }
            LOG.info("Uploading the app tarball");
            CoreFileSystem fs = new CoreFileSystem(conf);
            fs.copyLocalFileToHdfs(new File(packageDir.toString(), packageName), new Path(LLAP_PACKAGE_DIR), new FsPermission("755"));
            LOG.info("Executing the launch command");
            File yarnfile = new File(new Path(packageDir, "Yarnfile").toString());
            Long lifetime = null;
            sc.actionLaunch(yarnfile.getAbsolutePath(), name, lifetime, queue);
            LOG.debug("Started the cluster via service API");
        }
        catch (IOException | YarnException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                sc.close();
            }
            catch (IOException e) {
                LOG.info("Failed to close service client", (Throwable)e);
            }
        }
    }
}

