/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.FutureCallback;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.counters.WmFragmentCounters;
import org.apache.hadoop.hive.llap.daemon.FragmentCompletionHandler;
import org.apache.hadoop.hive.llap.daemon.HistoryLogger;
import org.apache.hadoop.hive.llap.daemon.KilledTaskHandler;
import org.apache.hadoop.hive.llap.daemon.SchedulerFragmentCompletingListener;
import org.apache.hadoop.hive.llap.daemon.impl.AMReporter;
import org.apache.hadoop.hive.llap.daemon.impl.ContainerRunnerImpl;
import org.apache.hadoop.hive.llap.daemon.impl.QueryFragmentInfo;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonExecutorMetrics;
import org.apache.hadoop.hive.llap.protocol.LlapTaskUmbilicalProtocol;
import org.apache.hadoop.hive.llap.tez.Converters;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.log4j.NDC;
import org.apache.tez.common.CallableWithNdc;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.apache.tez.common.security.TokenCache;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.hadoop.shim.HadoopShim;
import org.apache.tez.runtime.api.ExecutionContext;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.runtime.common.objectregistry.ObjectRegistryImpl;
import org.apache.tez.runtime.internals.api.TaskReporterInterface;
import org.apache.tez.runtime.library.input.UnorderedKVInput;
import org.apache.tez.runtime.task.TaskRunner2Result;
import org.apache.tez.runtime.task.TezTaskRunner2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class TaskRunnerCallable
extends CallableWithNdc<TaskRunner2Result> {
    private static final Logger LOG = LoggerFactory.getLogger(TaskRunnerCallable.class);
    private final LlapDaemonProtocolProtos.SubmitWorkRequestProto request;
    private final Configuration conf;
    private final Map<String, String> envMap;
    private final String pid;
    private final ObjectRegistryImpl objectRegistry;
    private final ExecutionContext executionContext;
    private final Credentials credentials;
    private final long memoryAvailable;
    private final ConfParams confParams;
    private final Token<JobTokenIdentifier> jobToken;
    private final AMReporter amReporter;
    private final TaskSpec taskSpec;
    private final QueryFragmentInfo fragmentInfo;
    private final KilledTaskHandler killedTaskHandler;
    private final FragmentCompletionHandler fragmentCompletionHanler;
    private volatile TezTaskRunner2 taskRunner;
    private volatile TaskReporterInterface taskReporter;
    private volatile ExecutorService executor;
    private LlapTaskUmbilicalProtocol umbilical;
    private volatile long startTime;
    private volatile String threadName;
    private final LlapDaemonExecutorMetrics metrics;
    private final String requestId;
    private final String threadNameSuffix;
    private final String queryId;
    private final HadoopShim tezHadoopShim;
    private boolean shouldRunTask = true;
    final Stopwatch runtimeWatch = Stopwatch.createUnstarted();
    final Stopwatch killtimerWatch = Stopwatch.createUnstarted();
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private final AtomicBoolean isCompleted = new AtomicBoolean(false);
    private final AtomicBoolean killInvoked = new AtomicBoolean(false);
    private final LlapDaemonProtocolProtos.SignableVertexSpec vertex;
    private final TezEvent initialEvent;
    private final SchedulerFragmentCompletingListener completionListener;
    private UserGroupInformation fsTaskUgi;
    private final SocketFactory socketFactory;
    private boolean isGuaranteed;
    private WmFragmentCounters wmCounters;
    private final AMReporter.AMNodeInfo amNodeInfo;

    @VisibleForTesting
    public TaskRunnerCallable(LlapDaemonProtocolProtos.SubmitWorkRequestProto request, QueryFragmentInfo fragmentInfo, Configuration conf, ExecutionContext executionContext, Map<String, String> envMap, Credentials credentials, long memoryAvailable, AMReporter amReporter, ConfParams confParams, LlapDaemonExecutorMetrics metrics, KilledTaskHandler killedTaskHandler, FragmentCompletionHandler fragmentCompleteHandler, HadoopShim tezHadoopShim, TezTaskAttemptID attemptId, LlapDaemonProtocolProtos.SignableVertexSpec vertex, TezEvent initialEvent, UserGroupInformation fsTaskUgi, SchedulerFragmentCompletingListener completionListener, SocketFactory socketFactory, boolean isGuaranteed, WmFragmentCounters wmCounters) {
        this.pid = null;
        this.request = request;
        this.fragmentInfo = fragmentInfo;
        this.conf = conf;
        this.executionContext = executionContext;
        this.envMap = envMap;
        this.objectRegistry = new ObjectRegistryImpl();
        this.credentials = credentials;
        this.memoryAvailable = memoryAvailable;
        this.confParams = confParams;
        this.jobToken = TokenCache.getSessionToken((Credentials)credentials);
        this.vertex = vertex;
        this.taskSpec = Converters.getTaskSpecfromProto((LlapDaemonProtocolProtos.SignableVertexSpec)vertex, (int)request.getFragmentNumber(), (int)request.getAttemptNumber(), (TezTaskAttemptID)attemptId);
        this.amReporter = amReporter;
        this.amNodeInfo = amReporter != null && this.jobToken != null ? amReporter.registerTask(request.getAmHost(), request.getAmPort(), vertex.getTokenIdentifier(), this.jobToken, fragmentInfo.getQueryInfo().getQueryIdentifier(), attemptId, isGuaranteed) : null;
        this.metrics = metrics;
        this.requestId = this.taskSpec.getTaskAttemptID().toString();
        this.threadNameSuffix = this.constructThreadNameSuffix(this.taskSpec.getTaskAttemptID());
        this.queryId = ContainerRunnerImpl.constructUniqueQueryId(vertex.getHiveQueryId(), fragmentInfo.getQueryInfo().getDagIdentifier());
        this.killedTaskHandler = killedTaskHandler;
        this.fragmentCompletionHanler = fragmentCompleteHandler;
        this.tezHadoopShim = tezHadoopShim;
        this.initialEvent = initialEvent;
        this.fsTaskUgi = fsTaskUgi;
        this.completionListener = completionListener;
        this.socketFactory = socketFactory;
        this.isGuaranteed = isGuaranteed;
        this.wmCounters = wmCounters;
    }

    public long getStartTime() {
        return this.startTime;
    }

    /*
     * Exception decompiling
     */
    protected TaskRunner2Result callInternal() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setMDCFromNDC() {
        Stack clonedNDC = NDC.cloneStack();
        String fragId = (String)clonedNDC.pop();
        String queryId = (String)clonedNDC.pop();
        String dagId = (String)clonedNDC.pop();
        MDC.put((String)"dagId", (String)dagId);
        MDC.put((String)"queryId", (String)queryId);
        MDC.put((String)"fragmentId", (String)fragId);
    }

    private String constructThreadNameSuffix(TezTaskAttemptID taskAttemptId) {
        StringBuilder sb = new StringBuilder();
        TezTaskID taskId = taskAttemptId.getTaskID();
        TezVertexID vertexId = taskId.getVertexID();
        TezDAGID dagId = vertexId.getDAGId();
        ApplicationId appId = dagId.getApplicationId();
        long clusterTs = appId.getClusterTimestamp();
        long clusterTsShort = clusterTs % 1000000L;
        sb.append(clusterTsShort).append("_");
        sb.append(appId.getId()).append("_");
        sb.append(dagId.getId()).append("_");
        sb.append(vertexId.getId()).append("_");
        sb.append(taskId.getId()).append("_");
        sb.append(taskAttemptId.getId());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killTask() {
        if (!this.isCompleted.get()) {
            if (!this.killInvoked.getAndSet(true)) {
                TaskRunnerCallable taskRunnerCallable = this;
                synchronized (taskRunnerCallable) {
                    TezTaskAttemptID ta = this.taskSpec.getTaskAttemptID();
                    LOG.info("Kill task requested for id={}, taskRunnerSetup={}", (Object)ta, (Object)(this.taskRunner != null ? 1 : 0));
                    this.shouldRunTask = false;
                    if (this.taskRunner != null) {
                        this.killtimerWatch.start();
                        LOG.info("Issuing kill to task {}", (Object)this.taskSpec.getTaskAttemptID());
                        boolean killed = this.taskRunner.killTask();
                        if (killed) {
                            LOG.info("Kill request for task {} completed. Informing AM", (Object)ta);
                            this.completionListener.fragmentCompleting(this.getRequestId(), SchedulerFragmentCompletingListener.State.KILLED);
                            this.reportTaskKilled();
                        } else {
                            LOG.info("Kill request for task {} did not complete because the task is already complete", (Object)ta);
                        }
                    } else {
                        LOG.debug("Reporting taskKilled for non-started fragment {}", (Object)this.getRequestId());
                        this.reportTaskKilled();
                    }
                    if (!this.isStarted.get()) {
                        this.fragmentCompletionHanler.fragmentComplete(this.fragmentInfo);
                        this.amReporter.unregisterTask(this.request.getAmHost(), this.request.getAmPort(), this.fragmentInfo.getQueryInfo().getQueryIdentifier(), ta);
                    }
                }
            } else {
                LOG.warn("Ignoring kill request for task {} since a previous kill request was processed", (Object)this.taskSpec.getTaskAttemptID());
            }
        } else {
            LOG.info("Ignoring kill request for task {} since it's already complete", (Object)this.taskSpec.getTaskAttemptID());
        }
    }

    public void reportTaskKilled() {
        this.killedTaskHandler.taskKilled(this.request.getAmHost(), this.request.getAmPort(), this.vertex.getTokenIdentifier(), this.jobToken, this.fragmentInfo.getQueryInfo().getQueryIdentifier(), this.taskSpec.getTaskAttemptID());
    }

    public boolean canFinish() {
        return QueryFragmentInfo.canFinish(this.fragmentInfo);
    }

    public boolean canFinishForPriority() {
        return this.fragmentInfo.canFinishForPriority();
    }

    public void updateCanFinishForPriority(boolean value) {
        this.fragmentInfo.setCanFinishForPriority(value);
    }

    private static Multimap<String, String> createStartedInputMap(LlapDaemonProtocolProtos.SignableVertexSpec vertex) {
        HashMultimap startedInputMap = HashMultimap.create();
        for (LlapDaemonProtocolProtos.IOSpecProto inputSpec : vertex.getInputSpecsList()) {
            if (!inputSpec.getIoDescriptor().getClassName().equals(UnorderedKVInput.class.getName())) continue;
            startedInputMap.put((Object)vertex.getVertexName(), (Object)inputSpec.getConnectedVertexName());
        }
        return startedInputMap;
    }

    public void shutdown() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        if (this.taskReporter != null) {
            this.taskReporter.shutdown();
        }
        if (this.umbilical != null) {
            RPC.stopProxy((Object)this.umbilical);
        }
    }

    public String toString() {
        return this.requestId + " {canFinish: " + this.canFinish() + ", vertexParallelism: " + this.vertex.getVertexParallelism() + ", selfAndUpstreamParallelism: " + this.request.getFragmentRuntimeInfo().getNumSelfAndUpstreamTasks() + ", selfAndUpstreamComplete: " + this.request.getFragmentRuntimeInfo().getNumSelfAndUpstreamCompletedTasks() + ", firstAttemptStartTime: " + this.getFragmentRuntimeInfo().getFirstAttemptStartTime() + ", dagStartTime:" + this.getFragmentRuntimeInfo().getDagStartTime() + ", withinDagPriority: " + this.getFragmentRuntimeInfo().getWithinDagPriority() + "}";
    }

    public int hashCode() {
        return this.requestId.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TaskRunnerCallable)) {
            return false;
        }
        return this.requestId.equals(((TaskRunnerCallable)((Object)obj)).getRequestId());
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public QueryFragmentInfo getFragmentInfo() {
        return this.fragmentInfo;
    }

    public TaskRunnerCallback getCallback() {
        return new TaskRunnerCallback(this.request, this.vertex, this);
    }

    public LlapDaemonProtocolProtos.SubmitWorkRequestProto getRequest() {
        return this.request;
    }

    public static String getTaskIdentifierString(LlapDaemonProtocolProtos.SubmitWorkRequestProto request, LlapDaemonProtocolProtos.SignableVertexSpec vertex, String queryId) {
        StringBuilder sb = new StringBuilder();
        sb.append("AppId=").append(vertex.getQueryIdentifier().getApplicationIdString()).append(", containerId=").append(request.getContainerIdString()).append(", QueryId=").append(queryId).append(", Vertex=").append(vertex.getVertexName()).append(", FragmentNum=").append(request.getFragmentNumber()).append(", Attempt=").append(request.getAttemptNumber());
        return sb.toString();
    }

    public LlapDaemonProtocolProtos.FragmentRuntimeInfo getFragmentRuntimeInfo() {
        return this.request.getFragmentRuntimeInfo();
    }

    public LlapDaemonProtocolProtos.SignableVertexSpec getVertexSpec() {
        return this.vertex;
    }

    public boolean isGuaranteed() {
        return this.isGuaranteed;
    }

    public void setIsGuaranteed(boolean isGuaranteed) {
        this.isGuaranteed = isGuaranteed;
        if (this.amNodeInfo != null) {
            this.amNodeInfo.updateTaskAttempt(this.taskSpec.getTaskAttemptID(), isGuaranteed);
        }
        if (this.wmCounters != null) {
            this.wmCounters.changeGuaranteed(isGuaranteed);
        }
    }

    public void setWmCountersDone() {
        if (this.wmCounters != null) {
            this.wmCounters.changeStateDone();
        }
    }

    public void setWmCountersQueued() {
        if (this.wmCounters != null) {
            this.wmCounters.changeStateQueued(this.isGuaranteed);
        }
    }

    public void setWmCountersRunning() {
        if (this.wmCounters != null) {
            this.wmCounters.changeStateRunning(this.isGuaranteed);
        }
    }

    public static class ConfParams {
        final int amHeartbeatIntervalMsMax;
        final long amCounterHeartbeatInterval;
        final int amMaxEventsPerHeartbeat;

        public ConfParams(int amHeartbeatIntervalMsMax, long amCounterHeartbeatInterval, int amMaxEventsPerHeartbeat) {
            this.amHeartbeatIntervalMsMax = amHeartbeatIntervalMsMax;
            this.amCounterHeartbeatInterval = amCounterHeartbeatInterval;
            this.amMaxEventsPerHeartbeat = amMaxEventsPerHeartbeat;
        }
    }

    final class TaskRunnerCallback
    implements FutureCallback<TaskRunner2Result> {
        private final LlapDaemonProtocolProtos.SubmitWorkRequestProto request;
        private final LlapDaemonProtocolProtos.SignableVertexSpec vertex;
        private final TaskRunnerCallable taskRunnerCallable;

        TaskRunnerCallback(LlapDaemonProtocolProtos.SubmitWorkRequestProto request, LlapDaemonProtocolProtos.SignableVertexSpec vertex, TaskRunnerCallable taskRunnerCallable) {
            this.request = request;
            this.vertex = vertex;
            this.taskRunnerCallable = taskRunnerCallable;
        }

        public void onSuccess(TaskRunner2Result result) {
            TaskRunnerCallable.this.isCompleted.set(true);
            switch (result.getEndReason()) {
                case SUCCESS: {
                    LOG.debug("Successfully finished {}", (Object)TaskRunnerCallable.this.requestId);
                    if (TaskRunnerCallable.this.metrics == null) break;
                    TaskRunnerCallable.this.metrics.incrExecutorTotalSuccess();
                    break;
                }
                case CONTAINER_STOP_REQUESTED: {
                    LOG.info("Received container stop request (AM preemption) for {}", (Object)TaskRunnerCallable.this.requestId);
                    if (TaskRunnerCallable.this.metrics == null) break;
                    TaskRunnerCallable.this.metrics.incrExecutorTotalKilled();
                    break;
                }
                case KILL_REQUESTED: {
                    LOG.info("Killed task {}", (Object)TaskRunnerCallable.this.requestId);
                    if (TaskRunnerCallable.this.killtimerWatch.isRunning()) {
                        TaskRunnerCallable.this.killtimerWatch.stop();
                        long elapsed = TaskRunnerCallable.this.killtimerWatch.elapsed(TimeUnit.MILLISECONDS);
                        LOG.info("Time to die for task {}", (Object)elapsed);
                        if (TaskRunnerCallable.this.metrics != null) {
                            TaskRunnerCallable.this.metrics.addMetricsPreemptionTimeToKill(elapsed);
                        }
                    }
                    if (TaskRunnerCallable.this.metrics == null) break;
                    TaskRunnerCallable.this.metrics.addMetricsPreemptionTimeLost(TaskRunnerCallable.this.runtimeWatch.elapsed(TimeUnit.MILLISECONDS));
                    TaskRunnerCallable.this.metrics.incrExecutorTotalKilled();
                    break;
                }
                case COMMUNICATION_FAILURE: {
                    LOG.info("Failed to run {} due to communication failure", (Object)TaskRunnerCallable.this.requestId);
                    if (TaskRunnerCallable.this.metrics == null) break;
                    TaskRunnerCallable.this.metrics.incrExecutorTotalExecutionFailed();
                    break;
                }
                case TASK_ERROR: {
                    LOG.info("Failed to run {} due to task error", (Object)TaskRunnerCallable.this.requestId);
                    if (TaskRunnerCallable.this.metrics == null) break;
                    TaskRunnerCallable.this.metrics.incrExecutorTotalExecutionFailed();
                }
            }
            TaskRunnerCallable.this.fragmentCompletionHanler.fragmentComplete(TaskRunnerCallable.this.fragmentInfo);
            this.taskRunnerCallable.shutdown();
            this.logFragmentEnd(true);
        }

        public void onFailure(Throwable t) {
            LOG.error("TezTaskRunner execution failed for : " + TaskRunnerCallable.getTaskIdentifierString(this.request, this.vertex, TaskRunnerCallable.this.queryId), t);
            TaskRunnerCallable.this.isCompleted.set(true);
            TaskRunnerCallable.this.fragmentCompletionHanler.fragmentComplete(TaskRunnerCallable.this.fragmentInfo);
            this.taskRunnerCallable.shutdown();
            this.logFragmentEnd(false);
        }

        protected void logFragmentEnd(boolean success) {
            LOG.info("WM counters: {}", (Object)TaskRunnerCallable.this.wmCounters);
            HistoryLogger.logFragmentEnd(this.vertex.getQueryIdentifier().getApplicationIdString(), this.request.getContainerIdString(), TaskRunnerCallable.this.executionContext.getHostName(), TaskRunnerCallable.this.queryId, TaskRunnerCallable.this.fragmentInfo.getQueryInfo().getDagIdentifier(), this.vertex.getVertexName(), this.request.getFragmentNumber(), this.request.getAttemptNumber(), this.taskRunnerCallable.threadName, this.taskRunnerCallable.startTime, success);
        }
    }
}

