/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase.highlight;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.SourceFieldMapper;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.fetch.subphase.highlight.Highlighter;
import org.elasticsearch.search.fetch.subphase.highlight.HighlighterContext;
import org.elasticsearch.search.fetch.subphase.highlight.SearchContextHighlight;
import org.elasticsearch.search.internal.SearchContext;

public class HighlightPhase
extends AbstractComponent
implements FetchSubPhase {
    private final Map<String, Highlighter> highlighters;

    public HighlightPhase(Settings settings, Map<String, Highlighter> highlighters) {
        super(settings);
        this.highlighters = highlighters;
    }

    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) {
        if (context.highlight() == null) {
            return;
        }
        HashMap<String, HighlightField> highlightFields = new HashMap<String, HighlightField>();
        for (SearchContextHighlight.Field field : context.highlight().fields()) {
            SourceFieldMapper sourceFieldMapper;
            Collection<String> fieldNamesToHighlight = Regex.isSimpleMatchPattern(field.field()) ? context.mapperService().simpleMatchToFullName(field.field()) : Collections.singletonList(field.field());
            if (context.highlight().forceSource(field) && !(sourceFieldMapper = context.mapperService().documentMapper(hitContext.hit().getType()).sourceMapper()).enabled()) {
                throw new IllegalArgumentException("source is forced for fields " + fieldNamesToHighlight + " but type [" + hitContext.hit().getType() + "] has disabled _source");
            }
            boolean fieldNameContainsWildcards = field.field().contains("*");
            for (String fieldName : fieldNamesToHighlight) {
                HighlightField highlightField;
                Highlighter highlighter;
                MappedFieldType fieldType = context.mapperService().fullName(fieldName);
                if (fieldType == null || fieldNameContainsWildcards && !fieldType.typeName().equals("text") && !fieldType.typeName().equals("keyword")) continue;
                String highlighterType = field.fieldOptions().highlighterType();
                if (highlighterType == null) {
                    highlighterType = "unified";
                }
                if ((highlighter = this.highlighters.get(highlighterType)) == null) {
                    throw new IllegalArgumentException("unknown highlighter type [" + highlighterType + "] for the field [" + fieldName + "]");
                }
                Query highlightQuery = field.fieldOptions().highlightQuery();
                if (highlightQuery == null) {
                    highlightQuery = context.parsedQuery().query();
                }
                HighlighterContext highlighterContext = new HighlighterContext(fieldType.name(), field, fieldType, context, hitContext, highlightQuery);
                if (!highlighter.canHighlight(fieldType) && fieldNameContainsWildcards || (highlightField = highlighter.highlight(highlighterContext)) == null) continue;
                highlightFields.put(fieldName, new HighlightField(fieldName, highlightField.fragments()));
            }
        }
        hitContext.hit().highlightFields(highlightFields);
    }
}

