/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.http;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryHTTP
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static final String URL_FIELDNAME = "URL";
    private String url;
    private String targetFilename;
    private boolean fileAppended;
    private boolean dateTimeAdded;
    private String targetFilenameExtention;
    private String uploadFilename;
    private String urlFieldname;
    private boolean runForEveryRow;
    private String proxyHostname;
    private String proxyPort;
    private String nonProxyHosts;
    private String username;
    private String password;

    public JobEntryHTTP(String n) {
        super(n, "");
        this.url = null;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.HTTP);
    }

    public JobEntryHTTP() {
        this("");
    }

    public JobEntryHTTP(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryHTTP je = (JobEntryHTTP)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"url", (String)this.url));
        retval.append("      ").append(XMLHandler.addTagValue((String)"targetfilename", (String)this.targetFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"file_appended", (boolean)this.fileAppended));
        retval.append("      ").append(XMLHandler.addTagValue((String)"date_time_added", (boolean)this.dateTimeAdded));
        retval.append("      ").append(XMLHandler.addTagValue((String)"targetfilename_extention", (String)this.targetFilenameExtention));
        retval.append("      ").append(XMLHandler.addTagValue((String)"uploadfilename", (String)this.uploadFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"url_fieldname", (String)this.urlFieldname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"run_every_row", (boolean)this.runForEveryRow));
        retval.append("      ").append(XMLHandler.addTagValue((String)"username", (String)this.username));
        retval.append("      ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_host", (String)this.proxyHostname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_port", (String)this.proxyPort));
        retval.append("      ").append(XMLHandler.addTagValue((String)"non_proxy_hosts", (String)this.nonProxyHosts));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.url = XMLHandler.getTagValue((Node)entrynode, (String)"url");
            this.targetFilename = XMLHandler.getTagValue((Node)entrynode, (String)"targetfilename");
            this.fileAppended = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"file_appended"));
            this.dateTimeAdded = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"date_time_added"));
            this.targetFilenameExtention = XMLHandler.getTagValue((Node)entrynode, (String)"targetfilename_extention");
            this.uploadFilename = XMLHandler.getTagValue((Node)entrynode, (String)"uploadfilename");
            this.urlFieldname = XMLHandler.getTagValue((Node)entrynode, (String)"url_fieldname");
            this.runForEveryRow = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"run_every_row"));
            this.username = XMLHandler.getTagValue((Node)entrynode, (String)"username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"password"));
            this.proxyHostname = XMLHandler.getTagValue((Node)entrynode, (String)"proxy_host");
            this.proxyPort = XMLHandler.getTagValue((Node)entrynode, (String)"proxy_port");
            this.nonProxyHosts = XMLHandler.getTagValue((Node)entrynode, (String)"non_proxy_hosts");
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'HTTP' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.url = rep.getJobEntryAttributeString(id_jobentry, "url");
            this.targetFilename = rep.getJobEntryAttributeString(id_jobentry, "targetfilename");
            this.fileAppended = rep.getJobEntryAttributeBoolean(id_jobentry, "file_appended");
            this.dateTimeAdded = "Y".equalsIgnoreCase(rep.getJobEntryAttributeString(id_jobentry, "date_time_added"));
            this.targetFilenameExtention = rep.getJobEntryAttributeString(id_jobentry, "targetfilename_extention");
            this.uploadFilename = rep.getJobEntryAttributeString(id_jobentry, "uploadfilename");
            this.urlFieldname = rep.getJobEntryAttributeString(id_jobentry, "url_fieldname");
            this.runForEveryRow = rep.getJobEntryAttributeBoolean(id_jobentry, "run_every_row");
            this.username = rep.getJobEntryAttributeString(id_jobentry, "username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "password"));
            this.proxyHostname = rep.getJobEntryAttributeString(id_jobentry, "proxy_host");
            int intPort = (int)rep.getJobEntryAttributeInteger(id_jobentry, "proxy_port");
            this.proxyPort = rep.getJobEntryAttributeString(id_jobentry, "proxy_port");
            if (intPort > 0 && Const.isEmpty((String)this.proxyPort)) {
                this.proxyPort = Integer.toString(intPort);
            }
            this.nonProxyHosts = rep.getJobEntryAttributeString(id_jobentry, "non_proxy_hosts");
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'HTTP' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "url", this.url);
            rep.saveJobEntryAttribute(id_job, this.getID(), "targetfilename", this.targetFilename);
            rep.saveJobEntryAttribute(id_job, this.getID(), "file_appended", this.fileAppended);
            rep.saveJobEntryAttribute(id_job, this.getID(), "date_time_added", this.dateTimeAdded);
            rep.saveJobEntryAttribute(id_job, this.getID(), "targetfilename_extention", this.targetFilenameExtention);
            rep.saveJobEntryAttribute(id_job, this.getID(), "uploadfilename", this.uploadFilename);
            rep.saveJobEntryAttribute(id_job, this.getID(), "url_fieldname", this.urlFieldname);
            rep.saveJobEntryAttribute(id_job, this.getID(), "run_every_row", this.runForEveryRow);
            rep.saveJobEntryAttribute(id_job, this.getID(), "username", this.username);
            rep.saveJobEntryAttribute(id_job, this.getID(), "password", Encr.encryptPasswordIfNotUsingVariables((String)this.password));
            rep.saveJobEntryAttribute(id_job, this.getID(), "proxy_host", this.proxyHostname);
            rep.saveJobEntryAttribute(id_job, this.getID(), "proxy_port", this.proxyPort);
            rep.saveJobEntryAttribute(id_job, this.getID(), "non_proxy_hosts", this.nonProxyHosts);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to load job entry of type 'HTTP' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getTargetFilename() {
        return this.targetFilename;
    }

    public void setTargetFilename(String targetFilename) {
        this.targetFilename = targetFilename;
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public void setNonProxyHosts(String nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getProxyHostname() {
        return this.proxyHostname;
    }

    public void setProxyHostname(String proxyHostname) {
        this.proxyHostname = proxyHostname;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public synchronized Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        ArrayList<RowMetaAndData> resultRows;
        LogWriter log = LogWriter.getInstance();
        Result result = previousResult;
        result.setResult(false);
        log.logBasic(this.toString(), "Start of HTTP job entry.", new Object[0]);
        String urlFieldnameToUse = Const.isEmpty((String)this.urlFieldname) ? URL_FIELDNAME : this.urlFieldname;
        if (this.runForEveryRow) {
            resultRows = previousResult.getRows();
            if (resultRows == null) {
                result.setNrErrors(1L);
                log.logError(this.toString(), "Unable to get result from previous job entry : can't continue.", new Object[0]);
                return result;
            }
        } else {
            resultRows = new ArrayList<RowMetaAndData>();
            RowMetaAndData row = new RowMetaAndData();
            row.addValue(new ValueMeta(urlFieldnameToUse, 2), (Object)this.environmentSubstitute(this.url));
            resultRows.add(row);
            System.out.println("Added one row to rows: " + row);
        }
        URL server = null;
        String beforeProxyHost = System.getProperty("http.proxyHost");
        String beforeProxyPort = System.getProperty("http.proxyPort");
        String beforeNonProxyHosts = System.getProperty("http.nonProxyHosts");
        for (int i = 0; i < resultRows.size() && result.getNrErrors() == 0L; ++i) {
            int oneChar;
            RowMetaAndData row = (RowMetaAndData)resultRows.get(i);
            OutputStream outputFile = null;
            OutputStream uploadStream = null;
            BufferedInputStream fileStream = null;
            InputStream input = null;
            String urlToUse = this.environmentSubstitute(row.getString(urlFieldnameToUse, ""));
            log.logBasic(this.toString(), "Connecting to URL: " + urlToUse, new Object[0]);
            if (!Const.isEmpty((String)this.proxyHostname)) {
                System.setProperty("http.proxyHost", this.environmentSubstitute(this.proxyHostname));
                System.setProperty("http.proxyPort", this.environmentSubstitute(this.proxyPort));
                if (this.nonProxyHosts != null) {
                    System.setProperty("http.nonProxyHosts", this.environmentSubstitute(this.nonProxyHosts));
                }
            }
            if (!Const.isEmpty((String)this.username)) {
                Authenticator.setDefault(new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        String realPassword = JobEntryHTTP.this.environmentSubstitute(JobEntryHTTP.this.password);
                        return new PasswordAuthentication(JobEntryHTTP.this.environmentSubstitute(JobEntryHTTP.this.username), realPassword != null ? realPassword.toCharArray() : new char[]{});
                    }
                });
            }
            String realTargetFile = this.environmentSubstitute(this.targetFilename);
            if (this.dateTimeAdded) {
                SimpleDateFormat daf = new SimpleDateFormat();
                Date now = new Date();
                daf.applyPattern("yyyMMdd");
                realTargetFile = realTargetFile + "_" + daf.format(now);
                daf.applyPattern("HHmmss");
                realTargetFile = realTargetFile + "_" + daf.format(now);
                if (!Const.isEmpty((String)this.targetFilenameExtention)) {
                    realTargetFile = realTargetFile + "." + this.environmentSubstitute(this.targetFilenameExtention);
                }
            }
            outputFile = KettleVFS.getOutputStream((String)realTargetFile, (boolean)this.fileAppended);
            server = new URL(urlToUse);
            URLConnection connection = server.openConnection();
            String realUploadFilename = this.environmentSubstitute(this.uploadFilename);
            if (!Const.isEmpty((String)realUploadFilename)) {
                int c;
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), "Start sending content of file [" + realUploadFilename + "] to server.", new Object[0]);
                }
                connection.setDoOutput(true);
                uploadStream = connection.getOutputStream();
                fileStream = new BufferedInputStream(new FileInputStream(new File(realUploadFilename)));
                while ((c = fileStream.read()) >= 0) {
                    uploadStream.write(c);
                }
                uploadStream.close();
                uploadStream = null;
                fileStream.close();
                fileStream = null;
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), "Finished sending content to server.", new Object[0]);
                }
            }
            if (log.isDetailed()) {
                log.logDetailed(this.toString(), "Start reading reply from webserver.", new Object[0]);
            }
            input = server.openStream();
            Date date = new Date(connection.getLastModified());
            log.logBasic(this.toString(), "Resource type: \"" + connection.getContentType() + "\", last modified on: \"" + date + "\".", new Object[0]);
            long bytesRead = 0L;
            while ((oneChar = input.read()) != -1) {
                outputFile.write(oneChar);
                ++bytesRead;
            }
            log.logBasic(this.toString(), "Finished writing " + bytesRead + " bytes to result file [" + realTargetFile + "]", new Object[0]);
            ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)realTargetFile), parentJob.getJobname(), this.toString());
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
            result.setResult(true);
            Object var29_31 = null;
            try {
                if (uploadStream != null) {
                    uploadStream.close();
                }
                if (fileStream != null) {
                    fileStream.close();
                }
                if (input != null) {
                    input.close();
                }
                if (outputFile != null) {
                    outputFile.close();
                }
            }
            catch (Exception e2) {
                log.logError(this.toString(), "Unable to close streams : " + e2.getMessage(), new Object[0]);
                result.setNrErrors(1L);
            }
            System.setProperty("http.proxyHost", Const.NVL((String)beforeProxyHost, (String)""));
            System.setProperty("http.proxyPort", Const.NVL((String)beforeProxyPort, (String)""));
            System.setProperty("http.nonProxyHosts", Const.NVL((String)beforeNonProxyHosts, (String)""));
            {
                continue;
                catch (MalformedURLException e) {
                    result.setNrErrors(1L);
                    log.logError(this.toString(), "The specified URL is not valid [" + this.url + "] : " + e.getMessage(), new Object[0]);
                    log.logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
                    var29_31 = null;
                    try {
                        if (uploadStream != null) {
                            uploadStream.close();
                        }
                        if (fileStream != null) {
                            fileStream.close();
                        }
                        if (input != null) {
                            input.close();
                        }
                        if (outputFile != null) {
                            outputFile.close();
                        }
                    }
                    catch (Exception e2) {
                        log.logError(this.toString(), "Unable to close streams : " + e2.getMessage(), new Object[0]);
                        result.setNrErrors(1L);
                    }
                    System.setProperty("http.proxyHost", Const.NVL((String)beforeProxyHost, (String)""));
                    System.setProperty("http.proxyPort", Const.NVL((String)beforeProxyPort, (String)""));
                    System.setProperty("http.nonProxyHosts", Const.NVL((String)beforeNonProxyHosts, (String)""));
                    continue;
                }
                catch (IOException e) {
                    result.setNrErrors(1L);
                    log.logError(this.toString(), "I was unable to save the HTTP result to file because of a I/O error: " + e.getMessage(), new Object[0]);
                    log.logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
                    var29_31 = null;
                    try {
                        if (uploadStream != null) {
                            uploadStream.close();
                        }
                        if (fileStream != null) {
                            fileStream.close();
                        }
                        if (input != null) {
                            input.close();
                        }
                        if (outputFile != null) {
                            outputFile.close();
                        }
                    }
                    catch (Exception e2) {
                        log.logError(this.toString(), "Unable to close streams : " + e2.getMessage(), new Object[0]);
                        result.setNrErrors(1L);
                    }
                    System.setProperty("http.proxyHost", Const.NVL((String)beforeProxyHost, (String)""));
                    System.setProperty("http.proxyPort", Const.NVL((String)beforeProxyPort, (String)""));
                    System.setProperty("http.nonProxyHosts", Const.NVL((String)beforeNonProxyHosts, (String)""));
                    continue;
                }
                catch (Exception e) {
                    result.setNrErrors(1L);
                    log.logError(this.toString(), "Error getting file from HTTP : " + e.getMessage(), new Object[0]);
                    log.logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
                    var29_31 = null;
                    try {
                        if (uploadStream != null) {
                            uploadStream.close();
                        }
                        if (fileStream != null) {
                            fileStream.close();
                        }
                        if (input != null) {
                            input.close();
                        }
                        if (outputFile != null) {
                            outputFile.close();
                        }
                    }
                    catch (Exception e2) {
                        log.logError(this.toString(), "Unable to close streams : " + e2.getMessage(), new Object[0]);
                        result.setNrErrors(1L);
                    }
                    System.setProperty("http.proxyHost", Const.NVL((String)beforeProxyHost, (String)""));
                    System.setProperty("http.proxyPort", Const.NVL((String)beforeProxyPort, (String)""));
                    System.setProperty("http.nonProxyHosts", Const.NVL((String)beforeNonProxyHosts, (String)""));
                    continue;
                }
            }
            catch (Throwable throwable) {
                var29_31 = null;
                try {
                    if (uploadStream != null) {
                        uploadStream.close();
                    }
                    if (fileStream != null) {
                        fileStream.close();
                    }
                    if (input != null) {
                        input.close();
                    }
                    if (outputFile != null) {
                        outputFile.close();
                    }
                }
                catch (Exception e2) {
                    log.logError(this.toString(), "Unable to close streams : " + e2.getMessage(), new Object[0]);
                    result.setNrErrors(1L);
                }
                System.setProperty("http.proxyHost", Const.NVL((String)beforeProxyHost, (String)""));
                System.setProperty("http.proxyPort", Const.NVL((String)beforeProxyPort, (String)""));
                System.setProperty("http.nonProxyHosts", Const.NVL((String)beforeNonProxyHosts, (String)""));
                throw throwable;
            }
        }
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public String getUploadFilename() {
        return this.uploadFilename;
    }

    public void setUploadFilename(String uploadFilename) {
        this.uploadFilename = uploadFilename;
    }

    public String getUrlFieldname() {
        return this.urlFieldname;
    }

    public void setUrlFieldname(String getFieldname) {
        this.urlFieldname = getFieldname;
    }

    public boolean isRunForEveryRow() {
        return this.runForEveryRow;
    }

    public void setRunForEveryRow(boolean runForEveryRow) {
        this.runForEveryRow = runForEveryRow;
    }

    public boolean isFileAppended() {
        return this.fileAppended;
    }

    public void setFileAppended(boolean fileAppended) {
        this.fileAppended = fileAppended;
    }

    public boolean isDateTimeAdded() {
        return this.dateTimeAdded;
    }

    public void setDateTimeAdded(boolean dateTimeAdded) {
        this.dateTimeAdded = dateTimeAdded;
    }

    public String getTargetFilenameExtention() {
        return this.targetFilenameExtention;
    }

    public void setTargetFilenameExtention(String uploadFilenameExtention) {
        this.targetFilenameExtention = uploadFilenameExtention;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        String realUrl = jobMeta.environmentSubstitute(this.url);
        ResourceReference reference = new ResourceReference(this);
        reference.getEntries().add(new ResourceEntry(realUrl, ResourceEntry.ResourceType.URL));
        references.add(reference);
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        JobEntryValidatorUtils.andValidator().validate(this, "targetFilename", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "targetFilenameExtention", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "uploadFilename", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "proxyPort", remarks, AndValidator.putValidators(JobEntryValidatorUtils.integerValidator()));
    }
}

