/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public abstract class SwtUniversalImage {
    private Map<String, Image> cache = new TreeMap<String, Image>();

    @Deprecated
    protected abstract Image renderSimple(Device var1);

    protected abstract Image renderSimple(Device var1, int var2, int var3);

    protected abstract Image renderRotated(Device var1, int var2, int var3, double var4);

    public synchronized void dispose() {
        if (this.cache == null) {
            return;
        }
        for (Image img : this.cache.values()) {
            if (img.isDisposed()) continue;
            img.dispose();
        }
        this.cache = null;
    }

    private void checkDisposed() {
        if (this.cache == null) {
            throw new RuntimeException("Already disposed");
        }
    }

    @Deprecated
    public synchronized Image getAsBitmap(Device device) {
        this.checkDisposed();
        Image result = this.cache.get("");
        if (result == null) {
            result = this.renderSimple(device);
            this.cache.put("", result);
        }
        return result;
    }

    public synchronized Image getAsBitmapForSize(Device device, int width, int height) {
        this.checkDisposed();
        String key = width + "x" + height;
        Image result = this.cache.get(key);
        if (result == null) {
            result = this.renderSimple(device, width, height);
            this.cache.put(key, result);
        }
        return result;
    }

    public synchronized Image getAsBitmapForSize(Device device, int width, int height, double angleRadians) {
        int angleDegree;
        this.checkDisposed();
        for (angleDegree = (int)Math.round(Math.toDegrees(angleRadians)); angleDegree < 0; angleDegree += 360) {
        }
        angleRadians = Math.toRadians(angleDegree %= 360);
        String key = width + "x" + height + "/" + angleDegree;
        Image result = this.cache.get(key);
        if (result == null) {
            result = this.renderRotated(device, width, height, angleRadians);
            this.cache.put(key, result);
        }
        return result;
    }

    protected Image swing2swt(Device device, BufferedImage img) {
        PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
        ImageData data = new ImageData(img.getWidth(), img.getHeight(), 32, palette);
        for (int y = 0; y < data.height; ++y) {
            for (int x = 0; x < data.width; ++x) {
                int rgba = img.getRGB(x, y);
                int rgb = palette.getPixel(new RGB(rgba >> 16 & 0xFF, rgba >> 8 & 0xFF, rgba & 0xFF));
                int a = rgba >> 24 & 0xFF;
                data.setPixel(x, y, rgb);
                data.setAlpha(x, y, a);
            }
        }
        return new Image(device, data);
    }
}

