/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import java.lang.reflect.Field;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.i18n.BaseMessages;

public class SimpleMessageDialog
extends MessageDialog {
    protected static Class<?> PKG = SimpleMessageDialog.class;
    public static final int BUTTON_WIDTH = 65;
    public static final int DEFULT_WIDTH = 450;
    private int width;
    private int buttonWidth;

    public SimpleMessageDialog(Shell parentShell, String title, String message, int dialogType) {
        this(parentShell, title, message, dialogType, BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]), 450, 65);
    }

    public SimpleMessageDialog(Shell parentShell, String title, String message, int dialogType, String buttonLabel) {
        this(parentShell, title, message, dialogType, buttonLabel, 450, 65);
    }

    public SimpleMessageDialog(Shell parentShell, String title, String message, int dialogType, String buttonLabel, int width, int buttonWidth) {
        super(parentShell, title, null, message, dialogType, new String[]{buttonLabel}, 0);
        this.width = width;
        this.buttonWidth = buttonWidth;
    }

    protected void constrainShellSize() {
        super.constrainShellSize();
        try {
            Field shellField = Window.class.getDeclaredField("shell");
            shellField.setAccessible(true);
            Shell thisShell = (Shell)shellField.get((Object)this);
            thisShell.pack();
            int height = thisShell.computeSize((int)this.width, (int)-1).y;
            thisShell.setBounds(thisShell.getBounds().x, thisShell.getBounds().y, this.width + 4, height + 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setBackground(shell.getDisplay().getSystemColor(1));
        shell.setBackgroundMode(2);
    }

    public void create() {
        super.create();
        Button button = this.getButton(0);
        int newX = button.getBounds().x + button.getBounds().width - this.buttonWidth;
        button.setBounds(newX, button.getBounds().y, this.buttonWidth, button.getBounds().height);
    }
}

