/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.gui;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class WindowProperty {
    private String name;
    private boolean maximized;
    private Rectangle rectangle;

    public WindowProperty(String name, boolean maximized, Rectangle rectangle) {
        this.name = name;
        this.maximized = maximized;
        this.rectangle = rectangle;
    }

    public WindowProperty(String name, boolean maximized, int x, int y, int width, int height) {
        this.name = name;
        this.maximized = maximized;
        this.rectangle = new Rectangle(x, y, width, height);
    }

    public WindowProperty(Shell shell) {
        this.name = shell.getText();
        this.maximized = shell.getMaximized();
        this.rectangle = shell.getBounds();
    }

    public void setShell(Shell shell) {
        this.setShell(shell, false);
    }

    public void setShell(Shell shell, boolean onlyPosition) {
        this.setShell(shell, onlyPosition, -1, -1);
    }

    public void setShell(Shell shell, int minWidth, int minHeight) {
        this.setShell(shell, false, minWidth, minHeight);
    }

    public void setShell(Shell shell, boolean onlyPosition, int minWidth, int minHeight) {
        shell.setMaximized(this.maximized);
        shell.setBounds(this.rectangle);
        if (minWidth > 0 || minHeight > 0) {
            Rectangle bounds = shell.getBounds();
            if (bounds.width < minWidth) {
                bounds.width = minWidth;
            }
            if (bounds.height < minHeight) {
                bounds.height = minHeight;
            }
            shell.setSize(bounds.width, bounds.height);
        }
        Point computedSize = shell.computeSize(-1, -1);
        Rectangle shellSize = shell.getBounds();
        if (shellSize.width < computedSize.x) {
            shellSize.width = computedSize.x;
        }
        if (shellSize.height < computedSize.y) {
            shellSize.height = computedSize.y;
        }
        shell.setBounds(shellSize);
        Rectangle entireClientArea = shell.getDisplay().getClientArea();
        Rectangle resizedRect = Geometry.copy((Rectangle)shellSize);
        this.constrainRectangleToContainer(resizedRect, entireClientArea);
        if (!resizedRect.equals((Object)shellSize) || this.isClippedByUnalignedMonitors(resizedRect, shell.getDisplay())) {
            Monitor monitor = shell.getDisplay().getPrimaryMonitor();
            if (shell.getParent() != null) {
                monitor = shell.getParent().getMonitor();
            }
            Rectangle monitorClientArea = monitor.getClientArea();
            this.constrainRectangleToContainer(resizedRect, monitorClientArea);
            resizedRect.x = monitorClientArea.x + (monitorClientArea.width - resizedRect.width) / 2;
            resizedRect.y = monitorClientArea.y + (monitorClientArea.height - resizedRect.height) / 2;
            shell.setBounds(resizedRect);
        }
    }

    private void constrainRectangleToContainer(Rectangle constrainee, Rectangle container) {
        Point originalSize = Geometry.getSize((Rectangle)constrainee);
        Point containerSize = Geometry.getSize((Rectangle)container);
        Point oversize = Geometry.subtract((Point)originalSize, (Point)containerSize);
        if (oversize.x > 0) {
            constrainee.width = originalSize.x - oversize.x;
        }
        if (oversize.y > 0) {
            constrainee.height = originalSize.y - oversize.y;
        }
        Geometry.moveInside((Rectangle)constrainee, (Rectangle)container);
    }

    private boolean isClippedByUnalignedMonitors(Rectangle constrainee, Display display) {
        boolean isClipped;
        Monitor[] monitors = display.getMonitors();
        if (monitors.length > 0) {
            isClipped = true;
            for (Monitor monitor : monitors) {
                if (!monitor.getClientArea().contains(constrainee.x + 10, constrainee.y + 10)) continue;
                isClipped = false;
                break;
            }
        } else {
            isClipped = false;
        }
        return isClipped;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isMaximized() {
        return this.maximized;
    }

    public void setMaximized(boolean maximized) {
        this.maximized = maximized;
    }

    public Rectangle getRectangle() {
        return this.rectangle;
    }

    public void setRectangle(Rectangle rectangle) {
        this.rectangle = rectangle;
    }

    public int getX() {
        return this.rectangle.x;
    }

    public int getY() {
        return this.rectangle.y;
    }

    public int getWidth() {
        return this.rectangle.width;
    }

    public int getHeight() {
        return this.rectangle.height;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equal(Object obj) {
        return ((WindowProperty)obj).getName().equalsIgnoreCase(this.name);
    }
}

