/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.widget;

import java.util.Arrays;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.widget.GetCaretPositionInterface;
import org.pentaho.di.ui.core.widget.InsertTextInterface;

public class VariableButtonListenerFactory {
    private static Class<?> PKG = VariableButtonListenerFactory.class;

    public static final SelectionAdapter getSelectionAdapter(Composite composite, Text destination, VariableSpace space) {
        return VariableButtonListenerFactory.getSelectionAdapter(composite, destination, null, null, space);
    }

    public static final SelectionAdapter getSelectionAdapter(final Composite composite, final Text destination, final GetCaretPositionInterface getCaretPositionInterface, final InsertTextInterface insertTextInterface, final VariableSpace space) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String variableName;
                int position = 0;
                if (getCaretPositionInterface != null) {
                    position = getCaretPositionInterface.getCaretPosition();
                }
                if ((variableName = VariableButtonListenerFactory.getVariableName(composite.getShell(), space)) != null) {
                    String var = "${" + variableName + "}";
                    if (insertTextInterface == null) {
                        destination.insert(var);
                        e.doit = false;
                    } else {
                        insertTextInterface.insertText(var, position);
                    }
                }
            }
        };
    }

    public static final String getVariableName(Shell shell, VariableSpace space) {
        Object[] keys = space.listVariables();
        Arrays.sort(keys);
        int size = keys.length;
        String[] key = new String[size];
        String[] val = new String[size];
        String[] str = new String[size];
        for (int i = 0; i < keys.length; ++i) {
            key[i] = keys[i];
            val[i] = space.getVariable(key[i]);
            str[i] = key[i] + "  [" + val[i] + "]";
        }
        EnterSelectionDialog esd = new EnterSelectionDialog(shell, str, BaseMessages.getString(PKG, (String)"System.Dialog.SelectEnvironmentVar.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.SelectEnvironmentVar.Message", (String[])new String[0]));
        esd.clearModal();
        if (esd.open() != null) {
            int nr = esd.getSelectionNr();
            String var = key[nr];
            return var;
        }
        return null;
    }
}

