/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.wizards;

import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.spoon.wizards.RipDatabaseWizard;
import org.pentaho.di.ui.spoon.wizards.RipDatabaseWizardPage1;

public class RipDatabaseWizardPage2
extends WizardPage {
    private PropsUI props = PropsUI.getInstance();
    private String[] input;
    private Hashtable<Integer, String> selection = new Hashtable();
    private Shell shell;
    private List wListSource;
    private List wListDest;
    private Label wlListSource;
    private Label wlListDest;
    private Button wAddOne;
    private Button wAddAll;
    private Button wRemoveAll;
    private Button wRemoveOne;

    public RipDatabaseWizardPage2(String arg) {
        super(arg);
        this.setTitle("Select the tables");
        this.setDescription("Select the tables to rip from the source database");
    }

    public void createControl(Composite parent) {
        this.shell = parent.getShell();
        int margin = 4;
        Composite composite = new Composite(parent, 0);
        this.props.setLook((Control)composite);
        FormLayout compLayout = new FormLayout();
        compLayout.marginHeight = 5;
        compLayout.marginWidth = 5;
        composite.setLayout((Layout)compLayout);
        Composite top = new Composite(composite, 0);
        FormLayout topLayout = new FormLayout();
        topLayout.marginHeight = margin;
        topLayout.marginWidth = margin;
        top.setLayout((Layout)topLayout);
        FormData fdTop = new FormData();
        fdTop.left = new FormAttachment(0, 0);
        fdTop.top = new FormAttachment(0, 0);
        fdTop.right = new FormAttachment(100, 0);
        fdTop.bottom = new FormAttachment(100, -50);
        top.setLayoutData((Object)fdTop);
        this.props.setLook((Control)top);
        Composite bottom = new Composite(composite, 0);
        bottom.setLayout((Layout)new FormLayout());
        FormData fdBottom = new FormData();
        fdBottom.left = new FormAttachment(0, 0);
        fdBottom.top = new FormAttachment((Control)top, 0);
        fdBottom.right = new FormAttachment(100, 0);
        fdBottom.bottom = new FormAttachment(100, 0);
        bottom.setLayoutData((Object)fdBottom);
        this.props.setLook((Control)bottom);
        SashForm sashform = new SashForm(top, 256);
        sashform.setLayout((Layout)new FormLayout());
        FormData fdSashform = new FormData();
        fdSashform.left = new FormAttachment(0, 0);
        fdSashform.top = new FormAttachment(0, 0);
        fdSashform.right = new FormAttachment(100, 0);
        fdSashform.bottom = new FormAttachment(100, 0);
        sashform.setLayoutData((Object)fdSashform);
        Composite leftsplit = new Composite((Composite)sashform, 0);
        leftsplit.setLayout((Layout)new FormLayout());
        FormData fdLeftsplit = new FormData();
        fdLeftsplit.left = new FormAttachment(0, 0);
        fdLeftsplit.top = new FormAttachment(0, 0);
        fdLeftsplit.right = new FormAttachment(100, 0);
        fdLeftsplit.bottom = new FormAttachment(100, 0);
        leftsplit.setLayoutData((Object)fdLeftsplit);
        this.props.setLook((Control)leftsplit);
        this.wlListSource = new Label(leftsplit, 0);
        this.wlListSource.setText("Available items:");
        this.props.setLook((Control)this.wlListSource);
        FormData fdlListSource = new FormData();
        fdlListSource.left = new FormAttachment(0, 0);
        fdlListSource.top = new FormAttachment(0, 0);
        this.wlListSource.setLayoutData((Object)fdlListSource);
        this.wListSource = new List(leftsplit, 2818);
        this.props.setLook((Control)this.wListSource);
        FormData fdListSource = new FormData();
        fdListSource.left = new FormAttachment(0, 0);
        fdListSource.top = new FormAttachment((Control)this.wlListSource, 0);
        fdListSource.right = new FormAttachment(100, 0);
        fdListSource.bottom = new FormAttachment(100, 0);
        this.wListSource.setLayoutData((Object)fdListSource);
        Composite compmiddle = new Composite((Composite)sashform, 0);
        compmiddle.setLayout((Layout)new FormLayout());
        FormData fdCompMiddle = new FormData();
        fdCompMiddle.left = new FormAttachment(0, 0);
        fdCompMiddle.top = new FormAttachment(0, 0);
        fdCompMiddle.right = new FormAttachment(100, 0);
        fdCompMiddle.bottom = new FormAttachment(100, 0);
        compmiddle.setLayoutData((Object)fdCompMiddle);
        this.props.setLook((Control)compmiddle);
        this.wAddOne = new Button(compmiddle, 8);
        this.wAddOne.setText(" > ");
        this.wAddOne.setToolTipText("Add the selected items on the left.");
        this.wAddAll = new Button(compmiddle, 8);
        this.wAddAll.setText(" >> ");
        this.wAddAll.setToolTipText("Add all items on the left.");
        this.wRemoveOne = new Button(compmiddle, 8);
        this.wRemoveOne.setText(" < ");
        this.wRemoveOne.setToolTipText("Remove the selected items on the right.");
        this.wRemoveAll = new Button(compmiddle, 8);
        this.wRemoveAll.setText(" << ");
        this.wRemoveAll.setToolTipText("Add all items on the right.");
        FormData fdAddOne = new FormData();
        fdAddOne.left = new FormAttachment((Control)compmiddle, 0, 0x1000000);
        fdAddOne.top = new FormAttachment(30, 0);
        this.wAddOne.setLayoutData((Object)fdAddOne);
        FormData fdAddAll = new FormData();
        fdAddAll.left = new FormAttachment((Control)compmiddle, 0, 0x1000000);
        fdAddAll.top = new FormAttachment((Control)this.wAddOne, margin);
        this.wAddAll.setLayoutData((Object)fdAddAll);
        FormData fdRemoveAll = new FormData();
        fdRemoveAll.left = new FormAttachment((Control)compmiddle, 0, 0x1000000);
        fdRemoveAll.top = new FormAttachment((Control)this.wAddAll, margin);
        this.wRemoveAll.setLayoutData((Object)fdRemoveAll);
        FormData fdRemoveOne = new FormData();
        fdRemoveOne.left = new FormAttachment((Control)compmiddle, 0, 0x1000000);
        fdRemoveOne.top = new FormAttachment((Control)this.wRemoveAll, margin);
        this.wRemoveOne.setLayoutData((Object)fdRemoveOne);
        Composite rightsplit = new Composite((Composite)sashform, 0);
        rightsplit.setLayout((Layout)new FormLayout());
        FormData fdRightsplit = new FormData();
        fdRightsplit.left = new FormAttachment(0, 0);
        fdRightsplit.top = new FormAttachment(0, 0);
        fdRightsplit.right = new FormAttachment(100, 0);
        fdRightsplit.bottom = new FormAttachment(100, 0);
        rightsplit.setLayoutData((Object)fdRightsplit);
        this.props.setLook((Control)rightsplit);
        this.wlListDest = new Label(rightsplit, 0);
        this.wlListDest.setText("Your selection:");
        this.props.setLook((Control)this.wlListDest);
        FormData fdlListDest = new FormData();
        fdlListDest.left = new FormAttachment(0, 0);
        fdlListDest.top = new FormAttachment(0, 0);
        this.wlListDest.setLayoutData((Object)fdlListDest);
        this.wListDest = new List(rightsplit, 2818);
        this.props.setLook((Control)this.wListDest);
        FormData fdListDest = new FormData();
        fdListDest.left = new FormAttachment(0, 0);
        fdListDest.top = new FormAttachment((Control)this.wlListDest, 0);
        fdListDest.right = new FormAttachment(100, 0);
        fdListDest.bottom = new FormAttachment(100, 0);
        this.wListDest.setLayoutData((Object)fdListDest);
        sashform.setWeights(new int[]{45, 10, 45});
        Transfer[] ttypes = new Transfer[]{TextTransfer.getInstance()};
        DragSource ddSource = new DragSource((Control)this.wListSource, 3);
        ddSource.setTransfer(ttypes);
        ddSource.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
            }

            public void dragSetData(DragSourceEvent event) {
                String[] ti = RipDatabaseWizardPage2.this.wListSource.getSelection();
                String data = new String();
                for (int i = 0; i < ti.length; ++i) {
                    data = data + ti[i] + Const.CR;
                }
                event.data = data;
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        DropTarget ddTarget = new DropTarget((Control)this.wListDest, 3);
        ddTarget.setTransfer(ttypes);
        ddTarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                if (event.data == null) {
                    event.detail = 0;
                    return;
                }
                StringTokenizer strtok = new StringTokenizer((String)event.data, Const.CR);
                while (strtok.hasMoreTokens()) {
                    String source = strtok.nextToken();
                    RipDatabaseWizardPage2.this.addToDestination(source);
                }
            }

            public void dropAccept(DropTargetEvent event) {
            }
        });
        this.wListSource.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    RipDatabaseWizardPage2.this.addToSelection(RipDatabaseWizardPage2.this.wListSource.getSelection());
                }
            }
        });
        this.wListDest.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    RipDatabaseWizardPage2.this.delFromSelection(RipDatabaseWizardPage2.this.wListDest.getSelection());
                }
            }
        });
        this.wListSource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                RipDatabaseWizardPage2.this.addToSelection(RipDatabaseWizardPage2.this.wListSource.getSelection());
            }
        });
        this.wListDest.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                String[] sel = RipDatabaseWizardPage2.this.wListDest.getSelection();
                RipDatabaseWizardPage2.this.delFromSelection(sel);
            }
        });
        this.wAddOne.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RipDatabaseWizardPage2.this.addToSelection(RipDatabaseWizardPage2.this.wListSource.getSelection());
            }
        });
        this.wRemoveOne.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RipDatabaseWizardPage2.this.delFromSelection(RipDatabaseWizardPage2.this.wListDest.getSelection());
            }
        });
        this.wAddAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RipDatabaseWizardPage2.this.addAllToSelection();
            }
        });
        this.wRemoveAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RipDatabaseWizardPage2.this.removeAllFromSelection();
            }
        });
        this.setControl((Control)composite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getInputData() {
        RipDatabaseWizardPage1 page1 = (RipDatabaseWizardPage1)this.getPreviousPage();
        Database sourceDb = new Database(RipDatabaseWizard.loggingObject, page1.getSourceDatabase());
        try {
            sourceDb.connect();
            this.input = sourceDb.getTablenames(false);
        }
        catch (KettleDatabaseException dbe) {
            new ErrorDialog(this.shell, "Error getting tables", "Error obtaining table list from database!", (Exception)((Object)dbe));
            this.input = null;
            boolean bl = false;
            return bl;
        }
        finally {
            sourceDb.disconnect();
        }
        return true;
    }

    public void getData() {
        this.wListSource.removeAll();
        this.wListDest.removeAll();
        if (this.input != null) {
            for (int i = 0; i < this.input.length; ++i) {
                Integer idx = i;
                String str = this.selection.get(idx);
                if (str == null) {
                    this.wListSource.add(this.input[i]);
                    continue;
                }
                this.wListDest.add(this.input[i]);
            }
        }
        this.setPageComplete(this.canFlipToNextPage());
    }

    public void addAllToSelection() {
        this.wListSource.removeAll();
        this.wListDest.removeAll();
        this.selection.clear();
        for (int i = 0; i < this.input.length; ++i) {
            this.wListDest.add(this.input[i]);
            this.selection.put(i, this.input[i]);
        }
        this.setPageComplete(this.canFlipToNextPage());
    }

    public void removeAllFromSelection() {
        this.wListSource.removeAll();
        this.wListDest.removeAll();
        this.selection.clear();
        for (int i = 0; i < this.input.length; ++i) {
            this.wListSource.add(this.input[i]);
        }
        this.setPageComplete(this.canFlipToNextPage());
    }

    public void addToSelection(String[] string) {
        for (int i = 0; i < string.length; ++i) {
            this.addToDestination(string[i]);
        }
        this.setPageComplete(this.canFlipToNextPage());
    }

    public void delFromSelection(String[] string) {
        for (int i = 0; i < string.length; ++i) {
            this.delFromDestination(string[i]);
        }
        this.setPageComplete(this.canFlipToNextPage());
    }

    public void addToDestination(String string) {
        int idxInput = Const.indexOfString((String)string, (String[])this.input);
        this.selection.put(idxInput, string);
        this.getData();
    }

    public void delFromDestination(String string) {
        int idxInput = Const.indexOfString((String)string, (String[])this.input);
        this.selection.remove(idxInput);
        this.getData();
    }

    public boolean canFlipToNextPage() {
        boolean canFlip = this.wListDest.getItemCount() > 0;
        return canFlip;
    }

    public String[] getSelection() {
        return this.wListDest.getItems();
    }
}

