/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.constant;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.constant.ConstantMeta;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class ConstantDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = ConstantMeta.class;
    private Label wlFields;
    private TableView wFields;
    private FormData fdlFields;
    private FormData fdFields;
    private ConstantMeta input;

    public ConstantDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (ConstantMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConstantDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ConstantDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"System.Label.StepName", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlFields = new Label((Composite)this.shell, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"ConstantDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        this.fdlFields = new FormData();
        this.fdlFields.left = new FormAttachment(0, 0);
        this.fdlFields.top = new FormAttachment((Control)this.wStepname, margin);
        this.wlFields.setLayoutData((Object)this.fdlFields);
        int FieldsCols = 10;
        int FieldsRows = this.input.getFieldName().length;
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ConstantDialog.Name.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ConstantDialog.Type.Column", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames()), new ColumnInfo(BaseMessages.getString(PKG, (String)"ConstantDialog.Format.Column", (String[])new String[0]), 5, 2), new ColumnInfo(BaseMessages.getString(PKG, (String)"ConstantDialog.Length.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ConstantDialog.Precision.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ConstantDialog.Currency.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ConstantDialog.Decimal.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ConstantDialog.Group.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ConstantDialog.Value.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ConstantDialog.Value.SetEmptyString", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])})};
        this.wFields = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 67586, colinf, FieldsRows, lsMod, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment(100, -50);
        this.wFields.setLayoutData(this.fdFields);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wFields);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                ConstantDialog.this.ok();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                ConstantDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ConstantDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                ConstantDialog.this.cancel();
            }
        });
        this.lsResize = new Listener(){

            public void handleEvent(Event event) {
                Point size = ConstantDialog.this.shell.getSize();
                ConstantDialog.this.wFields.setSize(size.x - 10, size.y - 50);
                ((ConstantDialog)ConstantDialog.this).wFields.table.setSize(size.x - 10, size.y - 50);
                ConstantDialog.this.wFields.redraw();
            }
        };
        this.shell.addListener(11, this.lsResize);
        this.setSize();
        this.getData();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void getData() {
        if (this.log.isDebug()) {
            this.logDebug("getting fields info...");
        }
        for (int i = 0; i < this.input.getFieldName().length; ++i) {
            if (this.input.getFieldName()[i] == null) continue;
            TableItem item = this.wFields.table.getItem(i);
            int col = 1;
            item.setText(col++, this.input.getFieldName()[i]);
            String type = this.input.getFieldType()[i];
            String format = this.input.getFieldFormat()[i];
            String length = this.input.getFieldLength()[i] < 0 ? "" : "" + this.input.getFieldLength()[i];
            String prec = this.input.getFieldPrecision()[i] < 0 ? "" : "" + this.input.getFieldPrecision()[i];
            String curr = this.input.getCurrency()[i];
            String group = this.input.getGroup()[i];
            String decim = this.input.getDecimal()[i];
            String def = this.input.getValue()[i];
            item.setText(col++, Const.NVL((String)type, (String)""));
            item.setText(col++, Const.NVL((String)format, (String)""));
            item.setText(col++, Const.NVL((String)length, (String)""));
            item.setText(col++, Const.NVL((String)prec, (String)""));
            item.setText(col++, Const.NVL((String)curr, (String)""));
            item.setText(col++, Const.NVL((String)decim, (String)""));
            item.setText(col++, Const.NVL((String)group, (String)""));
            item.setText(col++, Const.NVL((String)def, (String)""));
            item.setText(col++, this.input.isSetEmptyString()[i] ? BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]));
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        int nrfields = this.wFields.nrNonEmpty();
        this.input.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            this.input.getFieldName()[i] = item.getText(1);
            this.input.isSetEmptyString()[i] = BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]).equalsIgnoreCase(item.getText(10));
            this.input.getFieldType()[i] = this.input.isSetEmptyString()[i] ? "String" : item.getText(2);
            this.input.getFieldFormat()[i] = item.getText(3);
            String slength = item.getText(4);
            String sprec = item.getText(5);
            this.input.getCurrency()[i] = item.getText(6);
            this.input.getDecimal()[i] = item.getText(7);
            this.input.getGroup()[i] = item.getText(8);
            this.input.getValue()[i] = this.input.isSetEmptyString()[i] ? "" : item.getText(9);
            try {
                this.input.getFieldLength()[i] = Integer.parseInt(slength);
            }
            catch (Exception e) {
                this.input.getFieldLength()[i] = -1;
            }
            try {
                this.input.getFieldPrecision()[i] = Integer.parseInt(sprec);
                continue;
            }
            catch (Exception e) {
                this.input.getFieldPrecision()[i] = -1;
            }
        }
        this.dispose();
    }
}

