/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public final class Enumerations {
    private Enumerations() {
    }

    public static final Enumeration empty() {
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public static Enumeration singleton(Object object) {
        return Collections.enumeration(Collections.singleton(object));
    }

    public static Enumeration concat(Enumeration enumeration, Enumeration enumeration2) {
        return new SeqEn(enumeration, enumeration2);
    }

    public static Enumeration concat(Enumeration enumeration) {
        return new SeqEn(enumeration);
    }

    public static Enumeration removeDuplicates(Enumeration enumeration) {
        class RDupls
        implements Processor {
            private Set set = new HashSet();

            RDupls() {
            }

            public Object process(Object object, Collection collection) {
                return this.set.add(object) ? object : null;
            }
        }
        return Enumerations.filter(enumeration, new RDupls());
    }

    public static Enumeration array(Object[] objectArray) {
        return Collections.enumeration(Arrays.asList(objectArray));
    }

    public static Enumeration removeNulls(Enumeration enumeration) {
        return Enumerations.filter(enumeration, new RNulls());
    }

    public static Enumeration convert(Enumeration enumeration, Processor processor) {
        return new AltEn(enumeration, processor);
    }

    public static Enumeration filter(Enumeration enumeration, Processor processor) {
        return new FilEn(enumeration, processor);
    }

    public static Enumeration queue(Enumeration enumeration, Processor processor) {
        QEn qEn = new QEn(processor);
        while (enumeration.hasMoreElements()) {
            qEn.put(enumeration.nextElement());
        }
        return qEn;
    }

    private static class RNulls
    implements Processor {
        private RNulls() {
        }

        public Object process(Object object, Collection collection) {
            return object;
        }
    }

    private static final class FilEn
    implements Enumeration {
        private static final Object EMPTY = new Object();
        private Enumeration en;
        private Object next = EMPTY;
        private Processor filter;

        public FilEn(Enumeration enumeration, Processor processor) {
            this.en = enumeration;
            this.filter = processor;
        }

        public boolean hasMoreElements() {
            if (this.next != EMPTY) {
                return true;
            }
            while (this.en.hasMoreElements()) {
                this.next = this.filter.process(this.en.nextElement(), null);
                if (this.next == null) continue;
                return true;
            }
            this.next = EMPTY;
            return false;
        }

        public Object nextElement() {
            if (this.next == EMPTY && !this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            Object object = this.next;
            this.next = EMPTY;
            return object;
        }
    }

    private static class QEn
    implements Enumeration {
        private ListItem next = null;
        private ListItem last = null;
        private Processor processor;

        public QEn(Processor processor) {
            this.processor = processor;
        }

        public void put(Object object) {
            if (this.last != null) {
                ListItem listItem;
                this.last.next = listItem = new ListItem(object);
                this.last = listItem;
            } else {
                this.next = this.last = new ListItem(object);
            }
        }

        public void put(Object[] objectArray) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.put(objectArray[i]);
            }
        }

        public boolean hasMoreElements() {
            return this.next != null;
        }

        public Object nextElement() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object object = this.next.object;
            this.next = this.next.next;
            if (this.next == null) {
                this.last = null;
            }
            ToAdd toAdd = new ToAdd(this);
            object = this.processor.process(object, toAdd);
            toAdd.finish();
            return object;
        }

        private static final class ToAdd
        implements Collection {
            private QEn q;

            public ToAdd(QEn qEn) {
                this.q = qEn;
            }

            public void finish() {
                this.q = null;
            }

            public boolean add(Object object) {
                this.q.put(object);
                return true;
            }

            public boolean addAll(Collection collection) {
                this.q.put(collection.toArray());
                return true;
            }

            private String msg() {
                return "Only add and addAll are implemented";
            }

            public void clear() {
                throw new UnsupportedOperationException(this.msg());
            }

            public boolean contains(Object object) {
                throw new UnsupportedOperationException(this.msg());
            }

            public boolean containsAll(Collection collection) {
                throw new UnsupportedOperationException(this.msg());
            }

            public boolean isEmpty() {
                throw new UnsupportedOperationException(this.msg());
            }

            public Iterator iterator() {
                throw new UnsupportedOperationException(this.msg());
            }

            public boolean remove(Object object) {
                throw new UnsupportedOperationException(this.msg());
            }

            public boolean removeAll(Collection collection) {
                throw new UnsupportedOperationException(this.msg());
            }

            public boolean retainAll(Collection collection) {
                throw new UnsupportedOperationException(this.msg());
            }

            public int size() {
                throw new UnsupportedOperationException(this.msg());
            }

            public Object[] toArray() {
                throw new UnsupportedOperationException(this.msg());
            }

            public Object[] toArray(Object[] objectArray) {
                throw new UnsupportedOperationException(this.msg());
            }
        }

        private static final class ListItem {
            Object object;
            ListItem next;

            ListItem(Object object) {
                this.object = object;
            }
        }
    }

    private static final class SeqEn
    implements Enumeration {
        private Enumeration en;
        private Enumeration current;
        private boolean checked = false;

        public SeqEn(Enumeration enumeration) {
            this.en = enumeration;
        }

        public SeqEn(Enumeration enumeration, Enumeration enumeration2) {
            this(Enumerations.array(new Enumeration[]{enumeration, enumeration2}));
        }

        private void ensureCurrent() {
            while (this.current == null || !this.current.hasMoreElements()) {
                if (this.en.hasMoreElements()) {
                    this.current = (Enumeration)this.en.nextElement();
                    continue;
                }
                this.current = null;
                return;
            }
        }

        public boolean hasMoreElements() {
            if (!this.checked) {
                this.ensureCurrent();
                this.checked = true;
            }
            return this.current != null;
        }

        public Object nextElement() {
            if (!this.checked) {
                this.ensureCurrent();
            }
            if (this.current != null) {
                this.checked = false;
                return this.current.nextElement();
            }
            this.checked = true;
            throw new NoSuchElementException();
        }
    }

    private static final class AltEn
    implements Enumeration {
        private Enumeration en;
        private Processor process;

        public AltEn(Enumeration enumeration, Processor processor) {
            this.en = enumeration;
            this.process = processor;
        }

        public boolean hasMoreElements() {
            return this.en.hasMoreElements();
        }

        public Object nextElement() {
            return this.process.process(this.en.nextElement(), null);
        }
    }

    public static interface Processor {
        public Object process(Object var1, Collection var2);
    }
}

