/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.runtime.test.test.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.pentaho.runtime.test.RuntimeTest;

public abstract class BaseRuntimeTest
implements RuntimeTest {
    private final Class<?> classUnderTest;
    private final String module;
    private final String id;
    private final String name;
    private final boolean configInitTest;
    private final Set<String> dependencies;

    public BaseRuntimeTest(Class<?> classUnderTest, String module, String id, String name, Set<String> dependencies) {
        this(classUnderTest, module, id, name, false, dependencies);
    }

    public BaseRuntimeTest(Class<?> classUnderTest, String module, String id, String name, boolean configInitTest, Set<String> dependencies) {
        this.classUnderTest = classUnderTest;
        this.module = module;
        this.id = id;
        this.name = name;
        this.configInitTest = configInitTest;
        this.dependencies = Collections.unmodifiableSet(new HashSet<String>(dependencies));
    }

    @Override
    public boolean accepts(Object objectUnderTest) {
        return this.classUnderTest.isInstance(objectUnderTest);
    }

    @Override
    public String getModule() {
        return this.module;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<String> getDependencies() {
        return this.dependencies;
    }

    @Override
    public boolean isConfigInitTest() {
        return this.configInitTest;
    }

    public String toString() {
        return "BaseRuntimeTest{module='" + this.module + '\'' + ", id='" + this.id + '\'' + ", getName='" + this.name + '\'' + ", configInitTest=" + this.configInitTest + ", dependencies=" + this.dependencies + '}';
    }
}

